/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.StringBufferStream;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.TestRepositoryListener;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ArtifactRepositoryManagerTest
extends AbstractProvisioningTest {
    private IArtifactRepositoryManager manager;

    public static Test suite() {
        return new TestSuite(ArtifactRepositoryManagerTest.class);
    }

    public ArtifactRepositoryManagerTest(String name) {
        super(name);
    }

    private boolean managerContains(URI location) {
        URI[] locations = this.manager.getKnownRepositories(0);
        int i = 0;
        while (i < locations.length) {
            if (locations[i].equals(location)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.manager = ArtifactRepositoryManagerTest.getArtifactRepositoryManager();
        ArtifactRepositoryManagerTest.assertNotNull((Object)this.manager);
    }

    public void testLoadMissingRepository() throws IOException {
        File tempFile = File.createTempFile("testLoadMissingArtifactRepository", null);
        URI location = tempFile.toURI();
        PrintStream out = System.out;
        try {
            try {
                System.setOut(new PrintStream(new StringBufferStream()));
                this.manager.loadRepository(location, null);
                ArtifactRepositoryManagerTest.fail((String)"1.0");
            }
            catch (ProvisionException e) {
                ArtifactRepositoryManagerTest.assertEquals((String)"1.1", (int)4, (int)e.getStatus().getSeverity());
                ArtifactRepositoryManagerTest.assertEquals((String)"1.2", (int)1000, (int)e.getStatus().getCode());
                System.setOut(out);
                tempFile.delete();
            }
        }
        finally {
            System.setOut(out);
            tempFile.delete();
        }
    }

    public void testLoadMissingRepositoryElement() {
        File site = ArtifactRepositoryManagerTest.getTestData("Update site", "/testData/artifactRepo/broken/");
        try {
            URI location = site.toURI();
            this.manager.loadRepository(location, null);
            ArtifactRepositoryManagerTest.fail((String)"1.0");
        }
        catch (ProvisionException provisionException) {}
    }

    public void testLostArtifactRepositories() {
        File site = ArtifactRepositoryManagerTest.getTestData("Repository", "/testData/artifactRepo/simple/");
        URI location = site.toURI();
        this.manager.addRepository(location);
        ArtifactRepositoryManagerTest.assertTrue((String)"0.1", (boolean)this.manager.contains(location));
        IPreferencesService prefService = (IPreferencesService)ServiceHelper.getService((BundleContext)TestActivator.getContext(), (String)IPreferencesService.class.getName());
        IAgentLocation agentLocation = (IAgentLocation)ArtifactRepositoryManagerTest.getAgent().getService(IAgentLocation.SERVICE_NAME);
        String locationString = EncodingUtils.encodeSlashes((String)agentLocation.getRootLocation().toString());
        Preferences prefs = prefService.getRootNode().node("/profile/" + locationString + "/_SELF_/" + "org.eclipse.equinox.p2.artifact.repository" + "/repositories");
        try {
            String[] children = prefs.childrenNames();
            int i = 0;
            while (i < children.length) {
                prefs.node(children[i]).removeNode();
                ++i;
            }
            prefs.flush();
        }
        catch (BackingStoreException e) {
            ArtifactRepositoryManagerTest.fail("0.99", e);
        }
        try {
            ArtifactRepositoryManagerTest.restartBundle(TestActivator.getBundle("org.eclipse.equinox.p2.artifact.repository"));
        }
        catch (BundleException e) {
            ArtifactRepositoryManagerTest.fail("1.99", e);
        }
        this.manager = (IArtifactRepositoryManager)ArtifactRepositoryManagerTest.getAgent().getService(IArtifactRepositoryManager.SERVICE_NAME);
        ArtifactRepositoryManagerTest.assertTrue((String)"1.0", (boolean)this.manager.contains(location));
    }

    public void testNickname() throws ProvisionException {
        File site = ArtifactRepositoryManagerTest.getTestData("Repository", "/testData/artifactRepo/simple/");
        URI location = site.toURI();
        this.manager.addRepository(location);
        String nick = this.manager.getRepositoryProperty(location, "p2.nickname");
        ArtifactRepositoryManagerTest.assertNull((Object)nick);
        nick = "Nick";
        this.manager.setRepositoryProperty(location, "p2.nickname", nick);
        nick = this.manager.getRepositoryProperty(location, "p2.nickname");
        ArtifactRepositoryManagerTest.assertEquals((String)"Nick", (String)nick);
        this.manager.loadRepository(location, this.getMonitor());
        nick = this.manager.getRepositoryProperty(location, "p2.nickname");
        ArtifactRepositoryManagerTest.assertEquals((String)"Nick", (String)nick);
        this.manager.removeRepository(location);
        this.manager.loadRepository(location, this.getMonitor());
        nick = this.manager.getRepositoryProperty(location, "p2.nickname");
        ArtifactRepositoryManagerTest.assertNull((Object)nick);
    }

    public void testPathWithSpaces() {
        File site = ArtifactRepositoryManagerTest.getTestData("Repository", "/testData/artifactRepo/simple with spaces/");
        URI location = site.toURI();
        ArtifactRepositoryManagerTest.assertEquals((String)"1.0", (int)2, (int)this.getArtifactKeyCount(location));
    }

    public void testRefresh() throws ProvisionException {
        File site = ArtifactRepositoryManagerTest.getTestData("Repositoy", "/testData/artifactRepo/simple/");
        URI location = site.toURI();
        this.manager.addRepository(location);
        this.manager.refreshRepository(location, this.getMonitor());
        ArtifactRepositoryManagerTest.assertTrue((String)"1.0", (boolean)this.manager.contains(location));
        ArtifactRepositoryManagerTest.assertTrue((String)"1.1", (boolean)this.manager.isEnabled(location));
        this.manager.setEnabled(location, false);
        this.manager.setRepositoryProperty(location, "p2.nickname", "MyNick");
        this.manager.refreshRepository(location, this.getMonitor());
        ArtifactRepositoryManagerTest.assertTrue((String)"2.0", (boolean)this.manager.contains(location));
        ArtifactRepositoryManagerTest.assertFalse((String)"2.1", (boolean)this.manager.isEnabled(location));
        ArtifactRepositoryManagerTest.assertEquals((String)"2.2", (String)"MyNick", (String)this.manager.getRepositoryProperty(location, "p2.nickname"));
        this.manager.setRepositoryProperty(location, "p2.nickname", null);
    }

    public void testSetRepositoryProperty() {
        File site = ArtifactRepositoryManagerTest.getTestData("Repositoy", "/testData/artifactRepo/simple/");
        URI location = site.toURI();
        this.manager.removeRepository(location);
        this.manager.addRepository(location);
        this.manager.setRepositoryProperty(location, "name", "TestName");
        this.manager.setRepositoryProperty(location, "description", "TestDescription");
        this.manager.setRepositoryProperty(location, "p2.system", "true");
        ArtifactRepositoryManagerTest.assertEquals((String)"1.0", (String)"TestName", (String)this.manager.getRepositoryProperty(location, "name"));
        ArtifactRepositoryManagerTest.assertEquals((String)"1.1", (String)"TestDescription", (String)this.manager.getRepositoryProperty(location, "description"));
        ArtifactRepositoryManagerTest.assertEquals((String)"1.2", (String)"true", (String)this.manager.getRepositoryProperty(location, "p2.system"));
        try {
            this.manager.loadRepository(location, this.getMonitor());
        }
        catch (ProvisionException e) {
            ArtifactRepositoryManagerTest.fail("1.99", e);
        }
        ArtifactRepositoryManagerTest.assertEquals((String)"2.0", (String)"Good Test Repository", (String)this.manager.getRepositoryProperty(location, "name"));
        ArtifactRepositoryManagerTest.assertEquals((String)"2.1", (String)"Good test repository description", (String)this.manager.getRepositoryProperty(location, "description"));
        ArtifactRepositoryManagerTest.assertEquals((String)"2.2", (String)"false", (String)this.manager.getRepositoryProperty(location, "p2.system"));
    }

    public void testUpdateSitePathWithSpaces() {
        File site = ArtifactRepositoryManagerTest.getTestData("Repository", "/testData/updatesite/site with spaces/");
        URI location = site.toURI();
        ArtifactRepositoryManagerTest.assertEquals((String)"1.0", (int)3, (int)this.getArtifactKeyCount(location));
    }

    public void testTrailingSlashes() {
        URI locationNoSlash;
        URI locationSlash;
        File site = ArtifactRepositoryManagerTest.getTestData("Repository", "/testData/artifactRepo/simple/");
        try {
            locationSlash = site.toURI();
            String locationString = locationSlash.toString();
            locationString = locationString.substring(0, locationString.length() - 1);
            locationNoSlash = new URI(locationString);
        }
        catch (URISyntaxException e) {
            ArtifactRepositoryManagerTest.fail("0.99", e);
            return;
        }
        this.manager.addRepository(locationNoSlash);
        try {
            IArtifactRepository repoSlash = this.manager.loadRepository(locationSlash, null);
            IArtifactRepository repoNoSlash = this.manager.loadRepository(locationNoSlash, null);
            ArtifactRepositoryManagerTest.assertTrue((String)"1.0", (repoNoSlash == repoSlash ? 1 : 0) != 0);
        }
        catch (ProvisionException e) {
            ArtifactRepositoryManagerTest.fail("1.99", e);
        }
    }

    public void testBasicAddRemove() {
        File tempFile = new File(System.getProperty("java.io.tmpdir"));
        URI location = tempFile.toURI();
        ArtifactRepositoryManagerTest.assertTrue((!this.managerContains(location) ? 1 : 0) != 0);
        this.manager.addRepository(location);
        ArtifactRepositoryManagerTest.assertTrue((boolean)this.managerContains(location));
        this.manager.removeRepository(location);
        ArtifactRepositoryManagerTest.assertTrue((!this.managerContains(location) ? 1 : 0) != 0);
    }

    public void testContains() {
        File site = ArtifactRepositoryManagerTest.getTestData("Repositoy", "/testData/artifactRepo/simple/");
        URI location = site.toURI();
        this.manager.removeRepository(location);
        ArtifactRepositoryManagerTest.assertEquals((String)"1.0", (boolean)false, (boolean)this.manager.contains(location));
        this.manager.addRepository(location);
        ArtifactRepositoryManagerTest.assertEquals((String)"1.1", (boolean)true, (boolean)this.manager.contains(location));
        this.manager.removeRepository(location);
        ArtifactRepositoryManagerTest.assertEquals((String)"1.2", (boolean)false, (boolean)this.manager.contains(location));
    }

    public void testDuplicateElement() {
        File duplicateElementXML = ArtifactRepositoryManagerTest.getTestData("testDuplicateElement", "testData/artifactRepo/duplicateElement");
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            ArtifactRepositoryManagerTest.assertEquals((String)"Ensure correct number of artifact keys exist", (int)2, (int)this.getArtifactKeyCount(duplicateElementXML.toURI()));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testEnablement() {
        File site = ArtifactRepositoryManagerTest.getTestData("Repository", "/testData/artifactRepo/simple/");
        URI location = site.toURI();
        this.manager.addRepository(location);
        ArtifactRepositoryManagerTest.assertEquals((String)"1.0", (boolean)true, (boolean)this.manager.isEnabled(location));
        TestRepositoryListener listener = new TestRepositoryListener(location);
        this.getEventBus().addListener((ProvisioningListener)listener);
        this.manager.setEnabled(location, false);
        listener.waitForEvent();
        ArtifactRepositoryManagerTest.assertEquals((String)"2.0", (boolean)false, (boolean)listener.lastEnablement);
        ArtifactRepositoryManagerTest.assertEquals((String)"2.1", (boolean)false, (boolean)this.manager.isEnabled(location));
        ArtifactRepositoryManagerTest.assertEquals((String)"2.2", (int)1, (int)listener.lastRepoType);
        listener.reset();
        this.manager.setEnabled(location, true);
        listener.waitForEvent();
        ArtifactRepositoryManagerTest.assertEquals((String)"3.0", (boolean)true, (boolean)this.manager.isEnabled(location));
        ArtifactRepositoryManagerTest.assertEquals((String)"3.1", (int)8, (int)listener.lastKind);
        ArtifactRepositoryManagerTest.assertEquals((String)"3.2", (boolean)true, (boolean)listener.lastEnablement);
        ArtifactRepositoryManagerTest.assertEquals((String)"3.3", (int)1, (int)listener.lastRepoType);
        listener.reset();
    }

    public void testEnablementOnAdd() {
        File site = ArtifactRepositoryManagerTest.getTestData("Repository", "/testData/artifactRepo/simple/");
        URI location = site.toURI();
        this.manager.addRepository(location);
        this.manager.setEnabled(location, false);
        TestRepositoryListener listener = new TestRepositoryListener(location);
        this.getEventBus().addListener((ProvisioningListener)listener);
        this.manager.addRepository(location);
        listener.waitForEvent();
        ArtifactRepositoryManagerTest.assertEquals((String)"1.0", (boolean)true, (boolean)listener.lastEnablement);
        ArtifactRepositoryManagerTest.assertEquals((String)"1.1", (boolean)true, (boolean)this.manager.isEnabled(location));
        ArtifactRepositoryManagerTest.assertEquals((String)"1.2", (int)1, (int)listener.lastRepoType);
    }
}

