/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug265577
extends AbstractProvisioningTest {
    IProfile profile;
    IMetadataRepository metadataRepo;
    IArtifactRepository artifactRepo;
    ProvisioningContext context;
    IEngine engine;

    public void setUp() throws Exception {
        super.setUp();
        this.profile = this.createProfile(Bug265577.class.getName());
        this.engine = (IEngine)Bug265577.getAgent().getService(IEngine.SERVICE_NAME);
        File repoLocation = Bug265577.getTestData("Repository location", "/testData/bug265577/zipRepo.zip");
        if (repoLocation == null) {
            Bug265577.fail((String)"unable to load test data");
        }
        URI location = URIUtil.toJarURI((URI)repoLocation.toURI(), null);
        this.initializeArtifactRepo(location);
        this.initializeMetadataRepo(location);
    }

    private void initializeArtifactRepo(URI location) throws ProvisionException {
        IArtifactRepositoryManager mgr = Bug265577.getArtifactRepositoryManager();
        this.artifactRepo = mgr.loadRepository(location, (IProgressMonitor)new NullProgressMonitor());
    }

    private void initializeMetadataRepo(URI location) throws ProvisionException {
        IMetadataRepositoryManager mgr = Bug265577.getMetadataRepositoryManager();
        this.metadataRepo = mgr.loadRepository(location, (IProgressMonitor)new NullProgressMonitor());
        this.context = new ProvisioningContext(Bug265577.getAgent());
        this.context.setMetadataRepositories(mgr.getKnownRepositories(0));
    }

    public void testZippedRepoWithFolderFeature() {
        IQueryResult queryResult = this.metadataRepo.query(QueryUtil.createIUQuery((String)"Field_Assist_Example.feature.jar"), null);
        IInstallableUnit[] ius = (IInstallableUnit[])queryResult.toArray(IInstallableUnit.class);
        IArtifactKey key = (IArtifactKey)ius[0].getArtifacts().iterator().next();
        IArtifactDescriptor[] descriptors = this.artifactRepo.getArtifactDescriptors(key);
        ArtifactDescriptor desc = (ArtifactDescriptor)descriptors[0];
        desc.setProperty("artifact.folder", String.valueOf(true));
        IStatus status = null;
        try {
            BufferedOutputStream destination = new BufferedOutputStream(new FileOutputStream(new File(this.getTempFolder(), "FieldAssist")));
            status = this.artifactRepo.getArtifact((IArtifactDescriptor)desc, (OutputStream)destination, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (FileNotFoundException e) {
            Bug265577.fail((String)e.getMessage());
        }
        if (status.isOK()) {
            Bug265577.fail((String)"OK Status on download");
        }
        Bug265577.assertTrue((boolean)status.getMessage().equals(this.getJarFolderMessage(key)));
    }

    public void testZippedRepo() {
        IQueryResult queryResult = this.metadataRepo.query(QueryUtil.createIUQuery((String)"valid.feature.jar"), null);
        IInstallableUnit[] ius = (IInstallableUnit[])queryResult.toArray(IInstallableUnit.class);
        IArtifactKey key = (IArtifactKey)ius[0].getArtifacts().iterator().next();
        IArtifactDescriptor[] descriptors = this.artifactRepo.getArtifactDescriptors(key);
        IArtifactDescriptor desc = descriptors[0];
        IStatus status = null;
        try {
            BufferedOutputStream destination = new BufferedOutputStream(new FileOutputStream(new File(this.getTempFolder(), "valid")));
            status = this.artifactRepo.getArtifact(desc, (OutputStream)destination, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (FileNotFoundException e) {
            Bug265577.fail((String)e.getMessage());
        }
        Bug265577.assertTrue((String)status.getMessage(), (boolean)status.isOK());
    }

    private String getJarFolderMessage(IArtifactKey key) {
        return "Artifact " + key.toString() + " is a folder but the repository is an archive or remote location.";
    }
}

