/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.osgi.framework.BundleContext;

public class FoldersRepositoryTest
extends TestCase {
    private IArtifactRepositoryManager manager;
    private File testRepo;

    public FoldersRepositoryTest(String name) {
        super(name);
    }

    public FoldersRepositoryTest() {
        super("");
    }

    protected void setUp() throws Exception {
        IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)TestActivator.getContext(), (String)IProvisioningAgent.SERVICE_NAME);
        this.manager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
    }

    protected void tearDown() throws Exception {
        this.manager = null;
        if (this.testRepo != null) {
            AbstractProvisioningTest.delete(this.testRepo);
        }
    }

    public void testFolderRepository() throws Exception {
        String tempDir = System.getProperty("java.io.tmpdir");
        this.testRepo = new File(tempDir, "testRepo");
        AbstractProvisioningTest.delete(this.testRepo);
        this.testRepo.mkdir();
        this.manager.removeRepository(this.testRepo.toURI());
        IArtifactRepository repo = this.manager.createRepository(this.testRepo.toURI(), "testRepo", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
        File pluginsFolder = new File(this.testRepo, "plugins");
        pluginsFolder.mkdir();
        URL sourceBase = TestActivator.getContext().getBundle().getEntry("/testData/directorywatcher1");
        File sourceFolder = new File(FileLocator.toFileURL((URL)sourceBase).getPath());
        AbstractProvisioningTest.copy("0.99", sourceFolder, pluginsFolder);
        FileFilter filter = new FileFilter(){

            public boolean accept(File pathname) {
                return !pathname.getName().equals("CVS");
            }
        };
        File[] fileList = pluginsFolder.listFiles(filter);
        FoldersRepositoryTest.assertEquals((int)2, (int)fileList.length);
        int i = 0;
        while (i < fileList.length) {
            File file = fileList[i];
            String fileName = file.getName();
            if (fileName.endsWith(".jar")) {
                fileName = fileName.substring(0, fileName.length() - 4);
            }
            String identifier = fileName.substring(0, fileName.indexOf(95));
            String version = fileName.substring(fileName.indexOf(95) + 1);
            ArtifactKey key = new ArtifactKey("osgi.bundle", identifier, Version.create((String)version));
            ArtifactDescriptor descriptor = new ArtifactDescriptor((IArtifactKey)key);
            if (file.isDirectory()) {
                descriptor.setProperty("artifact.folder", "true");
            }
            repo.addDescriptor((IArtifactDescriptor)descriptor);
            ++i;
        }
        IQueryResult keys = repo.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
        FoldersRepositoryTest.assertEquals((int)2, (int)AbstractProvisioningTest.queryResultSize(keys));
        for (IArtifactKey key : keys) {
            repo.removeDescriptor(key);
        }
        keys = repo.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
        FoldersRepositoryTest.assertTrue((boolean)keys.isEmpty());
        FoldersRepositoryTest.assertEquals((int)0, (int)pluginsFolder.listFiles(filter).length);
        this.manager.removeRepository(repo.getLocation());
        AbstractProvisioningTest.delete(this.testRepo);
    }
}

