/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorSelector;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.spi.AbstractArtifactRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.testserver.helper.AbstractTestServerClientCase;

public class MirrorRequestTest2
extends AbstractTestServerClientCase {
    private SimpleArtifactRepository sourceRepository;
    private File targetLocation;
    private SimpleArtifactRepository targetRepository;

    public void setUp() throws Exception {
        super.setUp();
        this.targetLocation = File.createTempFile("target", ".repo");
        this.targetLocation.delete();
        this.targetLocation.mkdirs();
        this.targetRepository = new SimpleArtifactRepository(MirrorRequestTest2.getAgent(), "TargetRepo", this.targetLocation.toURI(), null);
        URI location = URI.create(String.valueOf(this.getBaseURL()) + "/mirrorrequest");
        IArtifactRepositoryManager mgr = (IArtifactRepositoryManager)MirrorRequestTest2.getAgent().getService(IArtifactRepositoryManager.SERVICE_NAME);
        this.sourceRepository = (SimpleArtifactRepository)mgr.loadRepository(location, null);
    }

    public void tearDown() throws Exception {
        IArtifactRepositoryManager mgr = (IArtifactRepositoryManager)MirrorRequestTest2.getAgent().getService(IArtifactRepositoryManager.SERVICE_NAME);
        mgr.removeRepository(this.targetLocation.toURI());
        AbstractProvisioningTest.delete(this.targetLocation);
        super.tearDown();
    }

    public void testRetryMirrorAfterTimeout() throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ArtifactKey key = new ArtifactKey("test.txt", "HelloWorldText", Version.parseVersion((String)"1.0.0"));
        MirrorRequest request = new MirrorRequest((IArtifactKey)key, (IArtifactRepository)this.targetRepository, null, null, (Transport)MirrorRequestTest2.getAgent().getService(Transport.SERVICE_NAME));
        MirrorRepo mirrorRepo = new MirrorRepo(this.sourceRepository);
        Field field = this.sourceRepository.getClass().getDeclaredField("mirrors");
        field.setAccessible(true);
        field.set(this.sourceRepository, new MirrorSelector((IRepository)mirrorRepo, (Transport)MirrorRequestTest2.getAgent().getService(Transport.SERVICE_NAME)){
            private int count;
            {
                this.count = 0;
            }

            public synchronized URI getMirrorLocation(URI inputLocation, IProgressMonitor monitor) {
                if (this.count++ == 0) {
                    return inputLocation;
                }
                return URI.create(String.valueOf(MirrorRequestTest2.this.getBaseURL()) + "/mirrorrequest/mirror-two/plugins/HelloWorldText_1.0.0.txt");
            }

            public synchronized boolean hasValidMirror() {
                return true;
            }
        });
        request.perform((IArtifactRepository)mirrorRepo, (IProgressMonitor)new NullProgressMonitor());
        MirrorRequestTest2.assertTrue((String)request.getResult().toString(), (boolean)request.getResult().isOK());
    }

    public void testTimeoutForgivableAfterTimeout() {
        try {
            System.setProperty("org.eclipse.equinox.p2.transport.ecf.retry", "4");
            ArtifactKey key = new ArtifactKey("test.txt", "HelloWorldText", Version.parseVersion((String)"1.0.0"));
            MirrorRequest request = new MirrorRequest((IArtifactKey)key, (IArtifactRepository)this.targetRepository, null, null, (Transport)MirrorRequestTest2.getAgent().getService(Transport.SERVICE_NAME));
            request.perform((IArtifactRepository)this.sourceRepository, (IProgressMonitor)new NullProgressMonitor());
            MirrorRequestTest2.assertTrue((String)request.getResult().toString(), (boolean)request.getResult().isOK());
        }
        finally {
            System.clearProperty("org.eclipse.equinox.p2.transport.ecf.retry");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MirrorRepo
    extends AbstractArtifactRepository {
        SimpleArtifactRepository delegate;
        int downloadCount;

        MirrorRepo(SimpleArtifactRepository repo) {
            super(MirrorRequestTest2.getAgent(), repo.getName(), repo.getType(), repo.getVersion(), repo.getLocation(), repo.getDescription(), repo.getProvider(), repo.getProperties());
            this.downloadCount = 0;
            this.delegate = repo;
        }

        public String getProperty(String key) {
            return this.getProperties().get(key);
        }

        public synchronized Map<String, String> getProperties() {
            HashMap<String, String> newProperties = new HashMap<String, String>(super.getProperties());
            newProperties.put("p2.mirrorsURL", String.valueOf(MirrorRequestTest2.this.getBaseURL()) + "/mirrorrequest/mirrors.xml");
            newProperties.put("p2.mirrorsBaseURL", String.valueOf(MirrorRequestTest2.this.getBaseURL()) + "/mirrorrequest");
            return newProperties;
        }

        public boolean contains(IArtifactDescriptor descriptor) {
            return this.delegate.contains(descriptor);
        }

        public boolean contains(IArtifactKey key) {
            return this.delegate.contains(key);
        }

        public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
            ++this.downloadCount;
            return this.delegate.getArtifact(descriptor, destination, monitor);
        }

        public IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
            return this.delegate.getArtifactDescriptors(key);
        }

        public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
            return this.delegate.getArtifacts(requests, monitor);
        }

        public OutputStream getOutputStream(IArtifactDescriptor descriptor) throws ProvisionException {
            return this.delegate.getOutputStream(descriptor);
        }

        public IStatus getRawArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
            return this.delegate.getRawArtifact(descriptor, destination, monitor);
        }

        public IQueryable<IArtifactDescriptor> descriptorQueryable() {
            return this.delegate.descriptorQueryable();
        }

        public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
            return this.delegate.query(query, monitor);
        }
    }
}

