/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class TransferTest
extends AbstractProvisioningTest {
    public void testGZFileAreNotUnzipped() throws URISyntaxException {
        FileOutputStream fos = null;
        File f = null;
        try {
            f = File.createTempFile("TransferTest", "pack.gz");
            fos = new FileOutputStream(f);
            Platform.getBundle((String)"org.eclipse.ecf.provider.filetransfer").start();
        }
        catch (IOException e) {
            TransferTest.fail("1.0", e);
        }
        catch (BundleException e) {
            TransferTest.fail("1.5", e);
        }
        URI toDownload = new URI("http://download.eclipse.org/eclipse/updates/3.4/plugins/javax.servlet.jsp_2.0.0.v200806031607.jar.pack.gz");
        IStatus s = this.getTransport().download(toDownload, (OutputStream)fos, (IProgressMonitor)new NullProgressMonitor());
        TransferTest.assertOK("2.0", s);
        int httpSize = -1;
        try {
            URL u = toDownload.toURL();
            HttpURLConnection c = (HttpURLConnection)u.openConnection();
            httpSize = c.getContentLength();
        }
        catch (MalformedURLException malformedURLException) {
            httpSize = -1;
        }
        catch (IOException iOException) {
            httpSize = -1;
        }
        try {
            try {
                fos.close();
                if (f != null) {
                    String[] ecfPlugins = new String[]{"org.eclipse.ecf", "org.eclipse.ecf.identity", "org.eclipse.ecf.filetransfer", "org.eclipse.ecf.provider.filetransfer", "org.eclipse.ecf.provider.filetransfer.httpclient4"};
                    StringBuffer buffer = new StringBuffer();
                    int i = 0;
                    while (i < ecfPlugins.length) {
                        Bundle bundle = Platform.getBundle((String)ecfPlugins[i]);
                        buffer.append(bundle.getSymbolicName()).append('-').append(bundle.getVersion()).append('\n');
                        ++i;
                    }
                    TransferTest.assertTrue((String)("4.0 - length found: " + f.length() + " using ECF bundles: " + buffer.toString()), (f.length() < 50000L ? 1 : 0) != 0);
                    TransferTest.assertTrue((String)"5.0", (boolean)(httpSize == -1 ? true : (long)httpSize == f.length()));
                }
            }
            catch (IOException e) {
                TransferTest.fail("5.0", e);
                if (f != null) {
                    f.delete();
                }
            }
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }
}

