/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.artifact.repository.processing;

import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStep;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;

public class ProcessingStepTest
extends TestCase {
    private ProcessingStep ps;
    private boolean flushed;
    private boolean closed;

    protected void setUp() throws Exception {
        super.setUp();
        this.ps = new ProcessingStep(){};
        this.flushed = false;
        this.closed = false;
    }

    public void testDefaultStatus() {
        ProcessingStepTest.assertNotNull((Object)this.ps.getStatus());
        ProcessingStepTest.assertTrue((boolean)this.ps.getStatus().isOK());
        ProcessingStepTest.assertTrue((boolean)this.ps.getStatus(false).isOK());
        ProcessingStepTest.assertTrue((boolean)this.ps.getStatus(true).isOK());
        ProcessingStepTest.assertTrue((boolean)ProcessingStepHandler.checkStatus((OutputStream)this.ps).isOK());
    }

    public void testGetDeepStatus() {
        ProcessingStep ps2 = new ProcessingStep(){};
        this.ps.link((OutputStream)ps2, (IProgressMonitor)new NullProgressMonitor());
        ProcessingStepTest.assertTrue((boolean)this.ps.getStatus(true).isOK());
        ps2.setStatus((IStatus)new Status(4, "plugin id", "message"));
        ProcessingStepTest.assertFalse((boolean)this.ps.getStatus(true).isOK());
        ProcessingStepTest.assertTrue((boolean)this.ps.getStatus(true).isMultiStatus());
        ProcessingStepTest.assertEquals((int)4, (int)this.ps.getStatus(true).getSeverity());
        MultiStatus multi = (MultiStatus)this.ps.getStatus(true);
        ProcessingStepTest.assertEquals((int)2, (int)multi.getChildren().length);
        ProcessingStep ps3 = new ProcessingStep(){};
        ps2.link((OutputStream)ps3, (IProgressMonitor)new NullProgressMonitor());
        ProcessingStepTest.assertFalse((boolean)this.ps.getStatus(true).isOK());
        ProcessingStepTest.assertTrue((boolean)this.ps.getStatus(true).isMultiStatus());
        ProcessingStepTest.assertEquals((int)4, (int)this.ps.getStatus(true).getSeverity());
        multi = (MultiStatus)this.ps.getStatus(true);
        ProcessingStepTest.assertEquals((int)3, (int)multi.getChildren().length);
        ps3.setStatus(Status.CANCEL_STATUS);
        ProcessingStepTest.assertFalse((boolean)this.ps.getStatus(true).isOK());
        ProcessingStepTest.assertTrue((boolean)this.ps.getStatus(true).isMultiStatus());
        ProcessingStepTest.assertEquals((int)8, (int)this.ps.getStatus(true).getSeverity());
    }

    public void testFlush() throws IOException {
        OutputStream destination = new OutputStream(){

            public void write(int b) {
            }

            public void flush() {
                ProcessingStepTest.this.flushed = true;
            }
        };
        this.ps.link(destination, (IProgressMonitor)new NullProgressMonitor());
        this.ps.flush();
        ProcessingStepTest.assertTrue((boolean)this.flushed);
    }

    public void testCloseSimpleOutputStreamAsDestination() throws IOException {
        OutputStream destination = new OutputStream(){

            public void write(int b) {
            }

            public void close() {
                ProcessingStepTest.this.closed = true;
            }
        };
        this.ps.link(destination, (IProgressMonitor)new NullProgressMonitor());
        this.ps.close();
        ProcessingStepTest.assertFalse((boolean)this.closed);
    }

    public void testCloseProcessingStepAsDestination() throws IOException {
        ProcessingStep destination = new ProcessingStep(){

            public void close() {
                ProcessingStepTest.this.closed = true;
            }
        };
        this.ps.link((OutputStream)destination, (IProgressMonitor)new NullProgressMonitor());
        this.ps.close();
        ProcessingStepTest.assertTrue((boolean)this.closed);
    }
}

