/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.director;

import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class AutomatedDirectorTest
extends AbstractProvisioningTest {
    public static Test suite() {
        return new TestSuite(AutomatedDirectorTest.class);
    }

    public AutomatedDirectorTest() {
        super("");
    }

    public AutomatedDirectorTest(String name) {
        super(name);
    }

    public void testInstallFilteredCapability() {
        IInstallableUnit requiredIU = AutomatedDirectorTest.createIU("required." + this.getName());
        IMatchExpression<IInstallableUnit> filter = AutomatedDirectorTest.createFilter("FilterKey", "true");
        IRequirement capability = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)requiredIU.getId(), (VersionRange)ANY_VERSION, filter, (boolean)false, (boolean)false);
        IInstallableUnit toInstallIU = AutomatedDirectorTest.createIU("toInstall." + this.getName(), new IRequirement[]{capability});
        IInstallableUnit[] allUnits = new IInstallableUnit[]{requiredIU, toInstallIU};
        this.createTestMetdataRepository(allUnits);
        IDirector director = AutomatedDirectorTest.createDirector();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.environments", "FilterKey=true");
        IProfile satisfied = this.createProfile("Satisfied." + this.getName(), properties);
        ProfileChangeRequest request = new ProfileChangeRequest(satisfied);
        request.add(toInstallIU);
        IStatus result = director.provision((IProfileChangeRequest)request, null, null);
        AutomatedDirectorTest.assertTrue((String)"1.0", (boolean)result.isOK());
        AutomatedDirectorTest.assertProfileContains("1.1", satisfied, allUnits);
    }

    public void testInstallOptionalAvailable() {
        String capabilityId = "test." + this.getName();
        IInstallableUnit requiredIU = AutomatedDirectorTest.createIU("required." + this.getName(), new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"test.capability", (String)capabilityId, (Version)DEFAULT_VERSION)});
        IRequirement required = MetadataFactory.createRequirement((String)"test.capability", (String)capabilityId, (VersionRange)ANY_VERSION, null, (boolean)true, (boolean)false, (boolean)false);
        IInstallableUnit toInstallIU = AutomatedDirectorTest.createIU("toInstall." + this.getName(), new IRequirement[]{required});
        IInstallableUnit[] allUnits = new IInstallableUnit[]{toInstallIU, requiredIU};
        IInstallableUnit[] toInstallArray = new IInstallableUnit[]{toInstallIU};
        this.createTestMetdataRepository(allUnits);
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        IDirector director = AutomatedDirectorTest.createDirector();
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(toInstallArray);
        IStatus result = director.provision((IProfileChangeRequest)request, null, null);
        if (!result.isOK()) {
            LogHelper.log((IStatus)result);
        }
        AutomatedDirectorTest.assertTrue((String)"1.0", (boolean)result.isOK());
        AutomatedDirectorTest.assertProfileContains("1.1", profile, toInstallArray);
    }

    public void testInstallOptionalUnavailable() {
        String capabilityId = "test." + this.getName();
        IRequirement required = MetadataFactory.createRequirement((String)"test.capability", (String)capabilityId, (VersionRange)ANY_VERSION, null, (boolean)true, (boolean)false);
        IInstallableUnit toInstallIU = AutomatedDirectorTest.createIU("toInstall." + this.getName(), new IRequirement[]{required});
        IInstallableUnit[] allUnits = new IInstallableUnit[]{toInstallIU};
        this.createTestMetdataRepository(allUnits);
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        IDirector director = AutomatedDirectorTest.createDirector();
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(allUnits);
        IStatus result = director.provision((IProfileChangeRequest)request, null, null);
        if (!result.isOK()) {
            LogHelper.log((IStatus)result);
        }
        AutomatedDirectorTest.assertTrue((String)"1.0", (boolean)result.isOK());
        AutomatedDirectorTest.assertProfileContains("1.1", profile, allUnits);
    }

    public void testInstallPlatformFilter() {
        String capabilityId = "test." + this.getName();
        IProvidedCapability[] provides = new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"test.capability", (String)capabilityId, (Version)DEFAULT_VERSION)};
        IInstallableUnit requiredIU = AutomatedDirectorTest.createIU("required." + this.getName(), AutomatedDirectorTest.createFilter("osgi.os", "blort"), provides);
        IInstallableUnit toInstallIU = AutomatedDirectorTest.createIU("toInstall." + this.getName(), AutomatedDirectorTest.createRequiredCapabilities("test.capability", capabilityId, ANY_VERSION, null));
        IInstallableUnit[] allUnits = new IInstallableUnit[]{requiredIU, toInstallIU};
        IInstallableUnit[] toInstallArray = new IInstallableUnit[]{toInstallIU};
        this.createTestMetdataRepository(allUnits);
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        IDirector director = AutomatedDirectorTest.createDirector();
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(toInstallArray);
        IStatus result = director.provision((IProfileChangeRequest)request, null, null);
        AutomatedDirectorTest.assertTrue((String)"1.0", (!result.isOK() ? 1 : 0) != 0);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.environments", "osgi.os=blort");
        IProfile profile2 = this.createProfile("TestProfile2." + this.getName(), properties);
        request = new ProfileChangeRequest(profile2);
        request.addInstallableUnits(toInstallArray);
        result = director.provision((IProfileChangeRequest)request, null, null);
        AutomatedDirectorTest.assertTrue((String)"2.0", (boolean)result.isOK());
    }

    public void testInstallPlatformFilterUnsatisfied() {
        IInstallableUnit toInstallIU = AutomatedDirectorTest.createIU("toInstall." + this.getName(), AutomatedDirectorTest.createFilter("osgi.os", "blort"), NO_PROVIDES);
        IInstallableUnit[] allUnits = new IInstallableUnit[]{toInstallIU};
        IInstallableUnit[] toInstallArray = new IInstallableUnit[]{toInstallIU};
        this.createTestMetdataRepository(allUnits);
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        IDirector director = AutomatedDirectorTest.createDirector();
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(toInstallArray);
        IStatus result = director.provision((IProfileChangeRequest)request, null, null);
        AutomatedDirectorTest.assertTrue((String)"1.0", (!result.isOK() ? 1 : 0) != 0);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.environments", "osgi.os=blort");
        IProfile profile2 = this.createProfile("TestProfile2." + this.getName(), properties);
        request = new ProfileChangeRequest(profile2);
        request.addInstallableUnits(toInstallArray);
        result = director.provision((IProfileChangeRequest)request, null, null);
        AutomatedDirectorTest.assertTrue((String)"2.0", (boolean)result.isOK());
    }

    public void testSimpleInstallRequired() {
        String capabilityId = "test." + this.getName();
        IInstallableUnit requiredIU = AutomatedDirectorTest.createIU("required." + this.getName(), new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"test.capability", (String)capabilityId, (Version)DEFAULT_VERSION)});
        IInstallableUnit toInstallIU = AutomatedDirectorTest.createIU("toInstall." + this.getName(), AutomatedDirectorTest.createRequiredCapabilities("test.capability", capabilityId, ANY_VERSION, null));
        IInstallableUnit[] allUnits = new IInstallableUnit[]{requiredIU, toInstallIU};
        IInstallableUnit[] toInstallArray = new IInstallableUnit[]{toInstallIU};
        this.createTestMetdataRepository(allUnits);
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        IDirector director = AutomatedDirectorTest.createDirector();
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(toInstallArray);
        IStatus result = director.provision((IProfileChangeRequest)request, null, null);
        if (!result.isOK()) {
            LogHelper.log((IStatus)result);
        }
        AutomatedDirectorTest.assertTrue((String)"1.0", (boolean)result.isOK());
        AutomatedDirectorTest.assertProfileContains("1.1", profile, allUnits);
    }

    public void testInstallRequiredNoVersion() {
        IInstallableUnit requiredIU = AutomatedDirectorTest.createIU("required." + this.getName());
        IRequirement capability = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)requiredIU.getId(), null, null, (boolean)false, (boolean)false);
        IInstallableUnit toInstallIU = AutomatedDirectorTest.createIU("toInstall." + this.getName(), new IRequirement[]{capability});
        IInstallableUnit[] allUnits = new IInstallableUnit[]{requiredIU, toInstallIU};
        IInstallableUnit[] toInstallArray = new IInstallableUnit[]{toInstallIU};
        this.createTestMetdataRepository(allUnits);
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        IDirector director = AutomatedDirectorTest.createDirector();
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(toInstallArray);
        IStatus result = director.provision((IProfileChangeRequest)request, null, null);
        if (!result.isOK()) {
            LogHelper.log((IStatus)result);
        }
        AutomatedDirectorTest.assertTrue((String)"1.0", (boolean)result.isOK());
        AutomatedDirectorTest.assertProfileContains("1.1", profile, allUnits);
    }

    public void testSimpleInstallRequiredIU() {
        IInstallableUnit requiredIU = AutomatedDirectorTest.createIU("required." + this.getName());
        IRequirement capability = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)requiredIU.getId(), (VersionRange)ANY_VERSION, null, (boolean)false, (boolean)false);
        IInstallableUnit toInstallIU = AutomatedDirectorTest.createIU("toInstall." + this.getName(), new IRequirement[]{capability});
        IInstallableUnit[] allUnits = new IInstallableUnit[]{requiredIU, toInstallIU};
        IInstallableUnit[] toInstallArray = new IInstallableUnit[]{toInstallIU};
        this.createTestMetdataRepository(allUnits);
        IProfile profile = this.createProfile("TestProfile." + this.getName());
        IDirector director = AutomatedDirectorTest.createDirector();
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(toInstallArray);
        IStatus result = director.provision((IProfileChangeRequest)request, null, null);
        if (!result.isOK()) {
            LogHelper.log((IStatus)result);
        }
        AutomatedDirectorTest.assertTrue((String)"1.0", (boolean)result.isOK());
        AutomatedDirectorTest.assertProfileContains("1.1", profile, allUnits);
    }
}

