/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.director;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.eclipse.equinox.internal.p2.director.app.IUListFormatter;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;

public class IUListFormatterTest
extends TestCase {
    public void testFormat() {
        IUListFormatter format = new IUListFormatter("${id}=${id},${version},${org.eclipse.equinox.p2.name}");
        String result = format.format(Arrays.asList(IUListFormatterTest.createIU("iu1", "1.0.0", "name", null)));
        IUListFormatterTest.assertEquals((String)"iu1=iu1,1.0.0,name", (String)result);
    }

    public void testFormat_MultipleIUs() {
        IUListFormatter format = new IUListFormatter("${id}=${version},${org.eclipse.equinox.p2.name}");
        String result = format.format(Arrays.asList(IUListFormatterTest.createIU("iu1", "1.0.0", "name", null), IUListFormatterTest.createIU("iu2", "2.0.0", "name2", null)));
        IUListFormatterTest.assertEquals((String)("iu1=1.0.0,name" + System.getProperty("line.separator") + "iu2=2.0.0,name2"), (String)result);
    }

    public void testFormat_UnknownFormatOption() {
        IUListFormatter format = new IUListFormatter("${id}${UNKNOWN}");
        String result = format.format(Arrays.asList(IUListFormatterTest.createIU("iu1", "1.0.0", "name", null)));
        IUListFormatterTest.assertEquals((String)"iu1", (String)result);
    }

    public void testFormat_Malformed() {
        IUListFormatter format = new IUListFormatter("${id=${version");
        String result = format.format(Arrays.asList(IUListFormatterTest.createIU("iu1", "1.0.0", "name", null)));
        IUListFormatterTest.assertEquals((String)"Input must be preserved", (String)"${id=${version", (String)result);
    }

    public static void main(String[] args) {
        IUListFormatter format = new IUListFormatter("${id=${version");
        ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>(20000);
        int i = 0;
        while (i < 20000) {
            ius.add(IUListFormatterTest.createIU("iu_" + i, "1.0.0", 30));
            ++i;
        }
        long start = System.currentTimeMillis();
        format.format(ius);
        System.out.println(System.currentTimeMillis() - start);
    }

    private static IInstallableUnit createIU(String id, String version, String name, String description) {
        IInstallableUnit iu = (IInstallableUnit)EasyMock.createNiceMock((String)id, IInstallableUnit.class);
        EasyMock.expect((Object)iu.getId()).andStubReturn((Object)id);
        EasyMock.expect((Object)iu.getVersion()).andStubReturn((Object)Version.create((String)version));
        HashMap<String, String> properties = new HashMap<String, String>(3, 1.0f);
        properties.put("org.eclipse.equinox.p2.name", name);
        properties.put("org.eclipse.equinox.p2.description", description);
        EasyMock.expect((Object)iu.getProperties()).andStubReturn(properties);
        EasyMock.expect((Object)iu.getProperty((String)EasyMock.anyObject())).andStubAnswer(new MapAnswer(properties));
        EasyMock.expect((Object)iu.getProperty((String)EasyMock.anyObject(), (String)EasyMock.anyObject())).andStubAnswer(new MapAnswer(properties));
        EasyMock.replay((Object[])new Object[]{iu});
        return iu;
    }

    private static IInstallableUnit createIU(String id, String version, int propCount) {
        IInstallableUnit iu = (IInstallableUnit)EasyMock.createNiceMock((String)id, IInstallableUnit.class);
        EasyMock.expect((Object)iu.getId()).andStubReturn((Object)id);
        EasyMock.expect((Object)iu.getVersion()).andStubReturn((Object)Version.create((String)version));
        HashMap<String, String> properties = new HashMap<String, String>(propCount, 1.0f);
        int i = 0;
        while (i < propCount) {
            properties.put("prop_" + i, "propValue_" + i);
            ++i;
        }
        EasyMock.expect((Object)iu.getProperties()).andStubReturn(properties);
        EasyMock.expect((Object)iu.getProperty((String)EasyMock.anyObject())).andStubAnswer(new MapAnswer(properties));
        EasyMock.expect((Object)iu.getProperty((String)EasyMock.anyObject(), (String)EasyMock.anyObject())).andStubAnswer(new MapAnswer(properties));
        EasyMock.replay((Object[])new Object[]{iu});
        return iu;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MapAnswer<T>
    implements IAnswer<T> {
        private final Map<?, T> map;

        MapAnswer(Map<?, T> map) {
            this.map = map;
        }

        public T answer() throws Throwable {
            return this.map.get(EasyMock.getCurrentArguments()[0]);
        }
    }
}

