/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.director;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class UninstallTest
extends AbstractProvisioningTest {
    private IInstallableUnit a1;
    private IProfile profile;
    private IDirector director;

    protected void setUp() throws Exception {
        this.a1 = UninstallTest.createIU("A", DEFAULT_VERSION, true);
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.director = UninstallTest.createDirector();
    }

    public void testUninstall() {
        IInstallableUnit[] units = new IInstallableUnit[]{this.a1};
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        request.addInstallableUnits(units);
        UninstallTest.assertTrue((String)"1.0", (boolean)this.director.provision((IProfileChangeRequest)request, null, null).isOK());
        UninstallTest.assertProfileContains("1.1", this.profile, units);
        request = new ProfileChangeRequest(this.profile);
        request.removeInstallableUnits(units);
        UninstallTest.assertTrue((String)"1.2", (boolean)this.director.provision((IProfileChangeRequest)request, null, null).isOK());
        UninstallTest.assertEmptyProfile(this.profile);
        UninstallTest.assertTrue((String)"1.3", (boolean)this.director.provision((IProfileChangeRequest)request, null, null).isOK());
        UninstallTest.assertEmptyProfile(this.profile);
    }
}

