/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.director;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class UpdateTest
extends AbstractProvisioningTest {
    IInstallableUnit f1;
    IInstallableUnit f1_1;
    IInstallableUnit f1_4;
    IInstallableUnit fa;
    IInstallableUnit fap;
    IDirector director;
    IPlanner planner;
    IProfile profile;

    protected void setUp() throws Exception {
        String f1Id = String.valueOf(this.getName()) + "f1";
        this.f1 = UpdateTest.createIU(f1Id, DEFAULT_VERSION, true);
        this.f1_1 = UpdateTest.createIU(f1Id, Version.createOSGi((int)1, (int)1, (int)0), true);
        this.f1_4 = UpdateTest.createIU(f1Id, Version.createOSGi((int)1, (int)4, (int)0), true);
        IRequirement[] requires = UpdateTest.createRequiredCapabilities("org.eclipse.equinox.p2.iu", f1Id, new VersionRange("[1.0.0, 1.3.0)"));
        String faId = String.valueOf(this.getName()) + ".fa";
        this.fa = UpdateTest.createIU(faId, requires, false);
        requires = UpdateTest.createRequiredCapabilities("org.eclipse.equinox.p2.iu", f1Id, new VersionRange("[1.0.0, 1.4.0)"));
        this.fap = UpdateTest.createIU(faId, Version.createOSGi((int)1, (int)1, (int)0), requires, NO_PROPERTIES, false);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.f1, this.fa});
        this.profile = this.createProfile("UpdateTest." + this.getName());
        this.director = UpdateTest.createDirector();
        this.planner = UpdateTest.createPlanner();
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        request.addInstallableUnits(new IInstallableUnit[]{this.fa});
        UpdateTest.assertOK("1.0", this.director.provision((IProfileChangeRequest)request, null, null));
        UpdateTest.assertProfileContains("Profile setup", this.profile, new IInstallableUnit[]{this.f1, this.fa});
        this.createTestMetdataRepository(new IInstallableUnit[]{this.f1_1, this.f1_4});
    }

    public void testInstall() {
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        request.addInstallableUnits(new IInstallableUnit[]{this.f1_1});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)request, new ProvisioningContext(UpdateTest.getAgent()), (IProgressMonitor)new NullProgressMonitor());
        UpdateTest.assertOK("1.0", plan.getStatus());
        UpdateTest.assertOK("1.1", this.director.provision((IProfileChangeRequest)request, null, null));
        request = new ProfileChangeRequest(this.profile);
        request.addInstallableUnits(new IInstallableUnit[]{this.f1_4});
        UpdateTest.assertEquals((int)4, (int)this.director.provision((IProfileChangeRequest)request, null, (IProgressMonitor)new NullProgressMonitor()).getSeverity());
    }
}

