/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.core.ProvisioningAgent;
import org.eclipse.equinox.internal.p2.engine.phases.CertificateChecker;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.TestData;

public class CertificateCheckerTest
extends AbstractProvisioningTest {
    CertificateChecker checker;
    CertificateTestService serviceUI;
    File unsigned;
    private ProvisioningAgent testAgent;

    protected void setUp() throws Exception {
        this.serviceUI = new CertificateTestService();
        this.testAgent = new ProvisioningAgent();
        this.testAgent.registerService(UIServices.SERVICE_NAME, (Object)this.serviceUI);
        this.testAgent.setBundleContext(TestActivator.getContext());
        this.checker = new CertificateChecker((IProvisioningAgent)this.testAgent);
        try {
            this.unsigned = TestData.getFile("CertificateChecker", "unsigned.jar");
        }
        catch (IOException e) {
            CertificateCheckerTest.fail("0.99", e);
        }
        CertificateCheckerTest.assertTrue((String)"1.0", (this.unsigned != null ? 1 : 0) != 0);
        CertificateCheckerTest.assertTrue((String)"1.0", (boolean)this.unsigned.exists());
    }

    public void testPolicyAllow() {
        try {
            this.serviceUI.unsignedReturnValue = false;
            System.getProperties().setProperty("eclipse.p2.unsignedPolicy", "allow");
            this.checker.add(this.unsigned);
            IStatus result = this.checker.start();
            CertificateCheckerTest.assertEquals((String)"1.0", (int)0, (int)result.getSeverity());
        }
        finally {
            System.getProperties().remove("eclipse.p2.unsignedPolicy");
        }
    }

    public void testPolicyFail() {
        try {
            System.getProperties().setProperty("eclipse.p2.unsignedPolicy", "fail");
            this.checker.add(this.unsigned);
            IStatus result = this.checker.start();
            CertificateCheckerTest.assertEquals((String)"1.0", (int)4, (int)result.getSeverity());
        }
        finally {
            System.getProperties().remove("eclipse.p2.unsignedPolicy");
        }
    }

    public void testPolicyPromptSuccess() {
        try {
            System.getProperties().setProperty("eclipse.p2.unsignedPolicy", "prompt");
            this.serviceUI.unsignedReturnValue = true;
            this.checker.add(this.unsigned);
            IStatus result = this.checker.start();
            CertificateCheckerTest.assertEquals((String)"1.0", (int)0, (int)result.getSeverity());
            CertificateCheckerTest.assertTrue((String)"1.1", (boolean)this.serviceUI.wasPrompted);
        }
        finally {
            System.getProperties().remove("eclipse.p2.unsignedPolicy");
        }
    }

    public void testPolicyDefault() {
        System.getProperties().remove("eclipse.p2.unsignedPolicy");
        this.serviceUI.unsignedReturnValue = true;
        this.checker.add(this.unsigned);
        IStatus result = this.checker.start();
        CertificateCheckerTest.assertEquals((String)"1.0", (int)0, (int)result.getSeverity());
        CertificateCheckerTest.assertTrue((String)"1.1", (boolean)this.serviceUI.wasPrompted);
    }

    public void testPolicyPromptCancel() {
        try {
            System.getProperties().setProperty("eclipse.p2.unsignedPolicy", "prompt");
            this.serviceUI.unsignedReturnValue = false;
            this.checker.add(this.unsigned);
            IStatus result = this.checker.start();
            CertificateCheckerTest.assertEquals((String)"1.0", (int)8, (int)result.getSeverity());
            CertificateCheckerTest.assertTrue((String)"1.1", (boolean)this.serviceUI.wasPrompted);
        }
        finally {
            System.getProperties().remove("eclipse.p2.unsignedPolicy");
        }
    }

    public void testBug291049() {
        try {
            this.testAgent.registerService(UIServices.SERVICE_NAME, null);
            this.checker.add(this.unsigned);
            System.getProperties().setProperty("eclipse.p2.unsignedPolicy", "prompt");
            IStatus result = this.checker.start();
            CertificateCheckerTest.assertTrue((String)"1.0", (boolean)result.isOK());
        }
        finally {
            System.getProperties().remove("eclipse.p2.unsignedPolicy");
        }
    }

    class CertificateTestService
    extends UIServices {
        public boolean unsignedReturnValue = true;
        public boolean wasPrompted = false;

        CertificateTestService() {
        }

        public UIServices.AuthenticationInfo getUsernamePassword(String location) {
            return null;
        }

        public UIServices.AuthenticationInfo getUsernamePassword(String location, UIServices.AuthenticationInfo previousInfo) {
            return null;
        }

        public UIServices.TrustInfo getTrustInfo(Certificate[][] untrustedChain, String[] unsignedDetail) {
            this.wasPrompted = true;
            return new UIServices.TrustInfo(null, false, this.unsignedReturnValue);
        }
    }
}

