/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.engine.Operand;
import org.eclipse.equinox.internal.p2.engine.Phase;
import org.eclipse.equinox.internal.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.p2.engine.phases.CheckTrust;
import org.eclipse.equinox.internal.p2.engine.phases.Collect;
import org.eclipse.equinox.internal.p2.engine.phases.Configure;
import org.eclipse.equinox.internal.p2.engine.phases.Install;
import org.eclipse.equinox.internal.p2.engine.phases.Property;
import org.eclipse.equinox.internal.p2.engine.phases.Sizing;
import org.eclipse.equinox.internal.p2.engine.phases.Unconfigure;
import org.eclipse.equinox.internal.p2.engine.phases.Uninstall;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class EngineTest
extends AbstractProvisioningTest {
    private IEngine engine;
    private File testProvisioning;

    public EngineTest(String name) {
        super(name);
    }

    public EngineTest() {
        this("");
    }

    private static boolean deleteDirectory(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    EngineTest.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return directory.delete();
    }

    protected void setUp() throws Exception {
        this.engine = this.getEngine();
        this.testProvisioning = new File(System.getProperty("java.io.tmpdir"), "testProvisioning");
        EngineTest.deleteDirectory(this.testProvisioning);
        this.testProvisioning.mkdir();
    }

    protected void tearDown() throws Exception {
        this.engine = null;
        EngineTest.deleteDirectory(this.testProvisioning);
    }

    public void testNullProfile() {
        IProfile profile = null;
        try {
            this.engine.perform(this.engine.createPlan(profile, null), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (AssertionFailedException assertionFailedException) {
            return;
        }
        EngineTest.fail();
    }

    public void testNullPhaseSet() {
        IProfile profile = this.createProfile("test");
        IPhaseSet phaseSet = null;
        try {
            this.engine.perform(this.engine.createPlan(profile, null), phaseSet, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        EngineTest.fail();
    }

    public void testNullPlan() {
        try {
            this.engine.perform(null, (IProgressMonitor)new NullProgressMonitor());
            EngineTest.fail();
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testCreatePhaseSetExcluding() {
        IPhaseSet set = PhaseSetFactory.createDefaultPhaseSetExcluding(null);
        EngineTest.assertEquals((String)"1.0", (int)7, (int)set.getPhaseIds().length);
        set = PhaseSetFactory.createDefaultPhaseSetExcluding((String[])new String[0]);
        EngineTest.assertEquals((String)"2.0", (int)7, (int)set.getPhaseIds().length);
        set = PhaseSetFactory.createDefaultPhaseSetExcluding((String[])new String[]{"blort"});
        EngineTest.assertEquals((String)"3.0", (int)7, (int)set.getPhaseIds().length);
        set = PhaseSetFactory.createDefaultPhaseSetExcluding((String[])new String[]{PhaseSetFactory.PHASE_CHECK_TRUST});
        String[] phases = set.getPhaseIds();
        EngineTest.assertEquals((String)"4.0", (int)6, (int)phases.length);
        int i = 0;
        while (i < phases.length) {
            if (phases[i].equals(PhaseSetFactory.PHASE_CHECK_TRUST)) {
                EngineTest.fail((String)("4.1." + i));
            }
            ++i;
        }
    }

    public void testCreatePhaseSetIncluding() {
        IPhaseSet set = PhaseSetFactory.createPhaseSetIncluding(null);
        EngineTest.assertNotNull((String)"1.0", (Object)set);
        EngineTest.assertEquals((String)"1.1", (int)0, (int)set.getPhaseIds().length);
        set = PhaseSetFactory.createPhaseSetIncluding((String[])new String[0]);
        EngineTest.assertNotNull((String)"2.0", (Object)set);
        EngineTest.assertEquals((String)"2.1", (int)0, (int)set.getPhaseIds().length);
        set = PhaseSetFactory.createPhaseSetIncluding((String[])new String[]{"blort", "not a phase", "bad input"});
        EngineTest.assertNotNull((String)"3.0", (Object)set);
        EngineTest.assertEquals((String)"3.1", (int)0, (int)set.getPhaseIds().length);
        set = PhaseSetFactory.createPhaseSetIncluding((String[])new String[]{PhaseSetFactory.PHASE_COLLECT});
        EngineTest.assertNotNull((String)"4.0", (Object)set);
        EngineTest.assertEquals((String)"4.1", (int)1, (int)set.getPhaseIds().length);
        EngineTest.assertEquals((String)"4.2", (String)PhaseSetFactory.PHASE_COLLECT, (String)set.getPhaseIds()[0]);
        set = PhaseSetFactory.createPhaseSetIncluding((String[])new String[]{PhaseSetFactory.PHASE_COLLECT, "bogus"});
        EngineTest.assertNotNull((String)"4.0", (Object)set);
        EngineTest.assertEquals((String)"4.1", (int)1, (int)set.getPhaseIds().length);
        EngineTest.assertEquals((String)"4.2", (String)PhaseSetFactory.PHASE_COLLECT, (String)set.getPhaseIds()[0]);
    }

    public void testEmptyOperands() {
        IProfile profile = this.createProfile("test");
        IStatus result = this.engine.perform(this.engine.createPlan(profile, null), (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertTrue((boolean)result.isOK());
    }

    public void testEmptyPhaseSet() {
        IProfile profile = this.createProfile("testEmptyPhaseSet");
        PhaseSet phaseSet = new PhaseSet(new Phase[0]){};
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        plan.removeInstallableUnit(this.createResolvedIU(EngineTest.createIU("name")));
        IStatus result = this.engine.perform(plan, (IPhaseSet)phaseSet, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertTrue((boolean)result.isOK());
    }

    public void testPerformAddSingleNullIU() {
        try {
            IProfile profile = this.createProfile("testPerformAddSingleNullIU");
            IProvisioningPlan plan = this.engine.createPlan(profile, null);
            plan.addInstallableUnit(null);
            EngineTest.fail((String)"Should not allow null iu");
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testPerformPropertyInstallUninstall() {
        IProfile profile = this.createProfile("testPerformPropertyInstallUninstall");
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        plan.setProfileProperty("test", "test");
        IInstallableUnit testIU = this.createResolvedIU(EngineTest.createIU("test"));
        plan.addInstallableUnit(testIU);
        plan.setInstallableUnitProfileProperty(testIU, "test", "test");
        IStatus result = this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertTrue((boolean)result.isOK());
        EngineTest.assertEquals((String)"test", (String)profile.getProperty("test"));
        EngineTest.assertEquals((String)"test", (String)profile.getInstallableUnitProperty(testIU, "test"));
        plan = this.engine.createPlan(profile, null);
        plan.setProfileProperty("test", null);
        plan.removeInstallableUnit(testIU);
        plan.setInstallableUnitProfileProperty(testIU, "test", null);
        result = this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertTrue((boolean)result.isOK());
        EngineTest.assertNull((String)"test", (Object)profile.getProperty("test"));
        EngineTest.assertNull((String)"test", (Object)profile.getInstallableUnitProperty(testIU, "test"));
    }

    public void testPerformSizingOSGiFrameworkNoArtifacts() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.installFolder", this.testProvisioning.getAbsolutePath());
        IProfile profile = this.createProfile("testPerformSizing", properties);
        Iterator it = EngineTest.getInstallableUnits(profile);
        while (it.hasNext()) {
            IProvisioningPlan plan = this.engine.createPlan(profile, null);
            IInstallableUnit doomed = (IInstallableUnit)it.next();
            plan.removeInstallableUnit(doomed);
            this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
        }
        Sizing sizingPhase = new Sizing(100);
        PhaseSet phaseSet = new PhaseSet(new Phase[]{sizingPhase});
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        plan.addInstallableUnit(this.createOSGiIU());
        IStatus result = this.engine.perform(plan, (IPhaseSet)phaseSet, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertTrue((boolean)result.isOK());
        EngineTest.assertTrue((sizingPhase.getDiskSize() == 0L ? 1 : 0) != 0);
        EngineTest.assertTrue((sizingPhase.getDownloadSize() == 0L ? 1 : 0) != 0);
    }

    public void testPerformInstallOSGiFramework() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.installFolder", this.testProvisioning.getAbsolutePath());
        IProfile profile = this.createProfile("testPerformInstallOSGiFramework", properties);
        Iterator it = EngineTest.getInstallableUnits(profile);
        while (it.hasNext()) {
            IProvisioningPlan plan = this.engine.createPlan(profile, null);
            IInstallableUnit doomed = (IInstallableUnit)it.next();
            plan.removeInstallableUnit(doomed);
            this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
        }
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        plan.addInstallableUnit(this.createOSGiIU());
        IStatus result = this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertTrue((boolean)result.isOK());
        Iterator ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertTrue((boolean)ius.hasNext());
    }

    public void testPerformUpdateOSGiFramework() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.installFolder", this.testProvisioning.getAbsolutePath());
        IProfile profile = this.createProfile("testPerformUpdateOSGiFramework", properties);
        IInstallableUnit iu33 = this.createOSGiIU("3.3");
        IInstallableUnit iu34 = this.createOSGiIU("3.4");
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        plan.addInstallableUnit(iu33);
        IStatus result = this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertTrue((boolean)result.isOK());
        Iterator ius = profile.query(QueryUtil.createIUQuery((IVersionedId)iu33), null).iterator();
        EngineTest.assertTrue((boolean)ius.hasNext());
        plan = this.engine.createPlan(profile, null);
        plan.updateInstallableUnit(iu33, iu34);
        result = this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertTrue((boolean)result.isOK());
        ius = profile.query(QueryUtil.createIUQuery((IVersionedId)iu34), null).iterator();
        EngineTest.assertTrue((boolean)ius.hasNext());
    }

    public void testPerformUninstallOSGiFramework() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.installFolder", this.testProvisioning.getAbsolutePath());
        IProfile profile = this.createProfile("testPerformUninstallOSGiFramework", properties);
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        plan.removeInstallableUnit(this.createOSGiIU());
        IStatus result = this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertTrue((boolean)result.isOK());
        EngineTest.assertEmptyProfile(profile);
    }

    public void testPerformRollback() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.installFolder", this.testProvisioning.getAbsolutePath());
        IProfile profile = this.createProfile("testPerformRollback", properties);
        Iterator ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertFalse((boolean)ius.hasNext());
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        plan.addInstallableUnit(this.createOSGiIU());
        plan.addInstallableUnit(this.createBadIU());
        IStatus result = this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertFalse((boolean)result.isOK());
        ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertFalse((boolean)ius.hasNext());
    }

    public void testPerformMissingAction() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.installFolder", this.testProvisioning.getAbsolutePath());
        IProfile profile = this.createProfile("testPerformMissingAction", properties);
        Iterator ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertFalse((boolean)ius.hasNext());
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        plan.addInstallableUnit(this.createOSGiIU());
        plan.addInstallableUnit(this.createMissingActionIU());
        IStatus result = this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertFalse((boolean)result.isOK());
        ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertFalse((boolean)ius.hasNext());
    }

    public void testPerformRollbackOnPhaseError() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.installFolder", this.testProvisioning.getAbsolutePath());
        IProfile profile = this.createProfile("testPerformRollbackOnError", properties);
        NPEPhase phase = new NPEPhase();
        TestPhaseSet phaseSet = new TestPhaseSet(phase);
        Iterator ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertFalse((boolean)ius.hasNext());
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        plan.addInstallableUnit(this.createOSGiIU());
        IStatus result = this.engine.perform(plan, (IPhaseSet)phaseSet, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertTrue((boolean)result.toString().contains("java.lang.NullPointerException"));
        EngineTest.assertFalse((boolean)result.isOK());
        ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertFalse((boolean)ius.hasNext());
        EngineTest.assertTrue((boolean)phase.isConsistent());
    }

    public void testPerformRollbackOnActionError() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.installFolder", this.testProvisioning.getAbsolutePath());
        IProfile profile = this.createProfile("testPerformRollbackOnError", properties);
        ActionNPEPhase phase = new ActionNPEPhase();
        TestPhaseSet phaseSet = new TestPhaseSet(phase);
        Iterator ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertFalse((boolean)ius.hasNext());
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        plan.addInstallableUnit(this.createOSGiIU());
        IStatus result = this.engine.perform(plan, (IPhaseSet)phaseSet, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertFalse((boolean)result.isOK());
        ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertFalse((boolean)ius.hasNext());
        EngineTest.assertTrue((boolean)phase.isConsistent());
    }

    public void testPerformForcedPhaseWithActionError() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.installFolder", this.testProvisioning.getAbsolutePath());
        IProfile profile = this.createProfile("testPerformForceWithActionError", properties);
        ActionNPEPhase phase = new ActionNPEPhase(true);
        TestPhaseSet phaseSet = new TestPhaseSet(phase);
        Iterator ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertFalse((boolean)ius.hasNext());
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        plan.addInstallableUnit(this.createOSGiIU());
        IStatus result = this.engine.perform(plan, (IPhaseSet)phaseSet, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertTrue((boolean)result.isOK());
        ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertTrue((boolean)ius.hasNext());
        EngineTest.assertTrue((boolean)phase.isConsistent());
    }

    public void testPerformForcedUninstallWithBadUninstallIUActionThrowsException() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.installFolder", this.testProvisioning.getAbsolutePath());
        IProfile profile = this.createProfile("testPerformForcedUninstallWithBadUninstallIUActionThrowsException", properties);
        Object phaseSet = PhaseSetFactory.createDefaultPhaseSet();
        Iterator ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertFalse((boolean)ius.hasNext());
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        IInstallableUnit badUninstallIU = this.createBadUninstallIUThrowsException();
        plan.addInstallableUnit(badUninstallIU);
        IStatus result = this.engine.perform(plan, phaseSet, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertTrue((boolean)result.isOK());
        ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertTrue((boolean)ius.hasNext());
        plan = this.engine.createPlan(profile, null);
        plan.removeInstallableUnit(badUninstallIU);
        result = this.engine.perform(plan, phaseSet, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertFalse((boolean)result.isOK());
        ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertTrue((boolean)ius.hasNext());
        phaseSet = new TestPhaseSet(true);
        plan = this.engine.createPlan(profile, null);
        plan.removeInstallableUnit(badUninstallIU);
        result = this.engine.perform(plan, phaseSet, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertTrue((boolean)result.isOK());
        ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertFalse((boolean)ius.hasNext());
    }

    public void testPerformForcedUninstallWithBadUninstallIUActionReturnsError() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.installFolder", this.testProvisioning.getAbsolutePath());
        IProfile profile = this.createProfile("testPerformForcedUninstallWithBadUninstallIUActionReturnsError", properties);
        Iterator ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertFalse((boolean)ius.hasNext());
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        IInstallableUnit badUninstallIU = this.createBadUninstallIUReturnsError();
        plan.addInstallableUnit(badUninstallIU);
        IStatus result = this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertTrue((boolean)result.isOK());
        ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertTrue((boolean)ius.hasNext());
        plan = this.engine.createPlan(profile, null);
        plan.removeInstallableUnit(badUninstallIU);
        result = this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertFalse((boolean)result.isOK());
        ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertTrue((boolean)ius.hasNext());
        TestPhaseSet phaseSet = new TestPhaseSet(true);
        plan = this.engine.createPlan(profile, null);
        plan.removeInstallableUnit(badUninstallIU);
        result = this.engine.perform(plan, (IPhaseSet)phaseSet, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertTrue((boolean)result.isOK());
        ius = EngineTest.getInstallableUnits(profile);
        EngineTest.assertFalse((boolean)ius.hasNext());
    }

    public void testOrphanedIUProperty() {
        IProfile profile = this.createProfile("testOrphanedIUProperty");
        IInstallableUnit iu = EngineTest.createIU("someIU");
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        plan.setInstallableUnitProfileProperty(iu, "key", "value");
        IStatus result = this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertTrue((boolean)result.isOK());
        EngineTest.assertFalse((boolean)profile.getInstallableUnitProperties(iu).containsKey("key"));
        plan = this.engine.createPlan(profile, null);
        plan.addInstallableUnit(iu);
        plan.setInstallableUnitProfileProperty(iu, "adifferentkey", "value");
        result = this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
        EngineTest.assertTrue((boolean)result.isOK());
        EngineTest.assertTrue((boolean)profile.getInstallableUnitProperties(iu).containsKey("adifferentkey"));
        EngineTest.assertFalse((boolean)profile.getInstallableUnitProperties(iu).containsKey("key"));
    }

    private IInstallableUnit createOSGiIU() {
        return this.createOSGiIU("3.3.1.R33x_v20070828");
    }

    private IInstallableUnit createOSGiIU(String version) {
        IInstallableUnitFragment fragment;
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        description.setId("org.eclipse.osgi");
        description.setVersion(Version.create((String)version));
        description.setTouchpointType(AbstractProvisioningTest.TOUCHPOINT_OSGI);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        String manifest = "Manifest-Version: 1.0\r\nBundle-Activator: org.eclipse.osgi.framework.internal.core.SystemBundl\r\n eActivator\r\nBundle-RequiredExecutionEnvironment: J2SE-1.4,OSGi/Minimum-1.0\r\nExport-Package: org.eclipse.osgi.event;version=\"1.0\",org.eclipse.osgi.\r\n framework.console;version=\"1.0\",org.eclipse.osgi.framework.eventmgr;v\r\n ersion=\"1.0\",org.eclipse.osgi.framework.log;version=\"1.0\",org.eclipse\r\n .osgi.service.datalocation;version=\"1.0\",org.eclipse.osgi.service.deb\r\n ug;version=\"1.0\",org.eclipse.osgi.service.environment;version=\"1.0\",o\r\n rg.eclipse.osgi.service.localization;version=\"1.0\",org.eclipse.osgi.s\r\n ervice.pluginconversion;version=\"1.0\",org.eclipse.osgi.service.resolv\r\n er;version=\"1.1\",org.eclipse.osgi.service.runnable;version=\"1.0\",org.\r\n eclipse.osgi.service.urlconversion;version=\"1.0\",org.eclipse.osgi.sto\r\n ragemanager;version=\"1.0\",org.eclipse.osgi.util;version=\"1.0\",org.osg\r\n i.framework;version=\"1.3\",org.osgi.service.condpermadmin;version=\"1.0\r\n \",org.osgi.service.packageadmin;version=\"1.2\",org.osgi.service.permis\r\n sionadmin;version=\"1.2\",org.osgi.service.startlevel;version=\"1.0\",org\r\n .osgi.service.url;version=\"1.0\",org.osgi.util.tracker;version=\"1.3.2\"\r\n ,org.eclipse.core.runtime.adaptor;x-friends:=\"org.eclipse.core.runtim\r\n e\",org.eclipse.core.runtime.internal.adaptor;x-internal:=true,org.ecl\r\n ipse.core.runtime.internal.stats;x-friends:=\"org.eclipse.core.runtime\r\n \",org.eclipse.osgi.baseadaptor;x-internal:=true,org.eclipse.osgi.base\r\n adaptor.bundlefile;x-internal:=true,org.eclipse.osgi.baseadaptor.hook\r\n s;x-internal:=true,org.eclipse.osgi.baseadaptor.loader;x-internal:=tr\r\n ue,org.eclipse.osgi.framework.adaptor;x-internal:=true,org.eclipse.os\r\n gi.framework.debug;x-internal:=true,org.eclipse.osgi.framework.intern\r\n al.core;x-internal:=true,org.eclipse.osgi.framework.internal.protocol\r\n ;x-internal:=true,org.eclipse.osgi.framework.internal.protocol.bundle\r\n entry;x-internal:=true,org.eclipse.osgi.framework.internal.protocol.b\r\n undleresource;x-internal:=true,org.eclipse.osgi.framework.internal.pr\r\n otocol.reference;x-internal:=true,org.eclipse.osgi.framework.internal\r\n .reliablefile;x-internal:=true,org.eclipse.osgi.framework.launcher;x-\r\n internal:=true,org.eclipse.osgi.framework.util;x-internal:=true,org.e\r\n clipse.osgi.internal.baseadaptor;x-internal:=true,org.eclipse.osgi.in\r\n ternal.module;x-internal:=true,org.eclipse.osgi.internal.profile;x-in\r\n ternal:=true,org.eclipse.osgi.internal.resolver;x-internal:=true,org.\r\n eclipse.osgi.internal.verifier;x-internal:=true,org.eclipse.osgi.inte\r\n rnal.provisional.verifier;x-friends:=\"org.eclipse.update.core,org.ecl\r\n ipse.ui.workbench\"\r\nBundle-Version: 3.3.0.v20060925\r\nEclipse-SystemBundle: true\r\nBundle-Copyright: %copyright\r\nBundle-Name: %systemBundle\r\nBundle-Description: %systemBundle\r\nBundle-DocUrl: http://www.eclipse.org\r\nBundle-ManifestVersion: 2\r\nExport-Service: org.osgi.service.packageadmin.PackageAdmin,org.osgi.se\r\n rvice.permissionadmin.PermissionAdmin,org.osgi.service.startlevel.Sta\r\n rtLevel,org.eclipse.osgi.service.debug.DebugOptions\r\nBundle-Vendor: %eclipse.org\r\nMain-Class: org.eclipse.core.runtime.adaptor.EclipseStarter\r\nBundle-SymbolicName: org.eclipse.osgi; singleton:=true\r\nBundle-Localization: systembundle\r\nEclipse-ExtensibleAPI: true\r\n\r\n";
        touchpointData.put("manifest", manifest);
        IInstallableUnitFragment[] cus = new IInstallableUnitFragment[1];
        MetadataFactory.InstallableUnitFragmentDescription desc = new MetadataFactory.InstallableUnitFragmentDescription();
        desc.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        cus[0] = fragment = MetadataFactory.createInstallableUnitFragment((MetadataFactory.InstallableUnitFragmentDescription)desc);
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
        return MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)iu, (IInstallableUnitFragment[])cus);
    }

    private IInstallableUnit createBadIU() {
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        description.setId("org.eclipse.osgi.bad");
        description.setVersion(Version.create((String)"3.3.1.R33x_v20070828"));
        description.setTouchpointType(AbstractProvisioningTest.TOUCHPOINT_OSGI);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        String manifest = "Manifest-Version: 1.0\r\nBundle-Activator: org.eclipse.osgi.framework.internal.core.SystemBundl\r\n eActivator\r\nBundle-RequiredExecutionEnvironment: J2SE-1.4,OSGi/Minimum-1.0\r\nExport-Package: org.eclipse.osgi.event;version=\"1.0\",org.eclipse.osgi.\r\n framework.console;version=\"1.0\",org.eclipse.osgi.framework.eventmgr;v\r\n ersion=\"1.0\",org.eclipse.osgi.framework.log;version=\"1.0\",org.eclipse\r\n .osgi.service.datalocation;version=\"1.0\",org.eclipse.osgi.service.deb\r\n ug;version=\"1.0\",org.eclipse.osgi.service.environment;version=\"1.0\",o\r\n rg.eclipse.osgi.service.localization;version=\"1.0\",org.eclipse.osgi.s\r\n ervice.pluginconversion;version=\"1.0\",org.eclipse.osgi.service.resolv\r\n er;version=\"1.1\",org.eclipse.osgi.service.runnable;version=\"1.0\",org.\r\n eclipse.osgi.service.urlconversion;version=\"1.0\",org.eclipse.osgi.sto\r\n ragemanager;version=\"1.0\",org.eclipse.osgi.util;version=\"1.0\",org.osg\r\n i.framework;version=\"1.3\",org.osgi.service.condpermadmin;version=\"1.0\r\n \",org.osgi.service.packageadmin;version=\"1.2\",org.osgi.service.permis\r\n sionadmin;version=\"1.2\",org.osgi.service.startlevel;version=\"1.0\",org\r\n .osgi.service.url;version=\"1.0\",org.osgi.util.tracker;version=\"1.3.2\"\r\n ,org.eclipse.core.runtime.adaptor;x-friends:=\"org.eclipse.core.runtim\r\n e\",org.eclipse.core.runtime.internal.adaptor;x-internal:=true,org.ecl\r\n ipse.core.runtime.internal.stats;x-friends:=\"org.eclipse.core.runtime\r\n \",org.eclipse.osgi.baseadaptor;x-internal:=true,org.eclipse.osgi.base\r\n adaptor.bundlefile;x-internal:=true,org.eclipse.osgi.baseadaptor.hook\r\n s;x-internal:=true,org.eclipse.osgi.baseadaptor.loader;x-internal:=tr\r\n ue,org.eclipse.osgi.framework.adaptor;x-internal:=true,org.eclipse.os\r\n gi.framework.debug;x-internal:=true,org.eclipse.osgi.framework.intern\r\n al.core;x-internal:=true,org.eclipse.osgi.framework.internal.protocol\r\n ;x-internal:=true,org.eclipse.osgi.framework.internal.protocol.bundle\r\n entry;x-internal:=true,org.eclipse.osgi.framework.internal.protocol.b\r\n undleresource;x-internal:=true,org.eclipse.osgi.framework.internal.pr\r\n otocol.reference;x-internal:=true,org.eclipse.osgi.framework.internal\r\n .reliablefile;x-internal:=true,org.eclipse.osgi.framework.launcher;x-\r\n internal:=true,org.eclipse.osgi.framework.util;x-internal:=true,org.e\r\n clipse.osgi.internal.baseadaptor;x-internal:=true,org.eclipse.osgi.in\r\n ternal.module;x-internal:=true,org.eclipse.osgi.internal.profile;x-in\r\n ternal:=true,org.eclipse.osgi.internal.resolver;x-internal:=true,org.\r\n eclipse.osgi.internal.verifier;x-internal:=true,org.eclipse.osgi.inte\r\n rnal.provisional.verifier;x-friends:=\"org.eclipse.update.core,org.ecl\r\n ipse.ui.workbench\"\r\nBundle-Version: 3.3.0.v20060925\r\nEclipse-SystemBundle: true\r\nBundle-Copyright: %copyright\r\nBundle-Name: %systemBundle\r\nBundle-Description: %systemBundle\r\nBundle-DocUrl: http://www.eclipse.org\r\nBundle-ManifestVersion: 2\r\nExport-Service: org.osgi.service.packageadmin.PackageAdmin,org.osgi.se\r\n rvice.permissionadmin.PermissionAdmin,org.osgi.service.startlevel.Sta\r\n rtLevel,org.eclipse.osgi.service.debug.DebugOptions\r\nBundle-Vendor: %eclipse.org\r\nMain-Class: org.eclipse.core.runtime.adaptor.EclipseStarter\r\nBundle-SymbolicName: org.eclipse.osgi; singleton:=true\r\nBundle-Localization: systembundle\r\nEclipse-ExtensibleAPI: true\r\n\r\n";
        touchpointData.put("manifest", manifest);
        touchpointData.put("install", "BAD");
        IInstallableUnitFragment[] cus = new IInstallableUnitFragment[1];
        MetadataFactory.InstallableUnitFragmentDescription desc = new MetadataFactory.InstallableUnitFragmentDescription();
        desc.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        cus[0] = MetadataFactory.createInstallableUnitFragment((MetadataFactory.InstallableUnitFragmentDescription)desc);
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
        return MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)iu, (IInstallableUnitFragment[])cus);
    }

    private IInstallableUnit createBadUninstallIUReturnsError() {
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        description.setId("org.eclipse.osgi.bad");
        description.setVersion(Version.create((String)"3.3.1.R33x_v20070828"));
        description.setTouchpointType(AbstractProvisioningTest.TOUCHPOINT_OSGI);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        String manifest = "Manifest-Version: 1.0\r\nBundle-Activator: org.eclipse.osgi.framework.internal.core.SystemBundl\r\n eActivator\r\nBundle-RequiredExecutionEnvironment: J2SE-1.4,OSGi/Minimum-1.0\r\nExport-Package: org.eclipse.osgi.event;version=\"1.0\",org.eclipse.osgi.\r\n framework.console;version=\"1.0\",org.eclipse.osgi.framework.eventmgr;v\r\n ersion=\"1.0\",org.eclipse.osgi.framework.log;version=\"1.0\",org.eclipse\r\n .osgi.service.datalocation;version=\"1.0\",org.eclipse.osgi.service.deb\r\n ug;version=\"1.0\",org.eclipse.osgi.service.environment;version=\"1.0\",o\r\n rg.eclipse.osgi.service.localization;version=\"1.0\",org.eclipse.osgi.s\r\n ervice.pluginconversion;version=\"1.0\",org.eclipse.osgi.service.resolv\r\n er;version=\"1.1\",org.eclipse.osgi.service.runnable;version=\"1.0\",org.\r\n eclipse.osgi.service.urlconversion;version=\"1.0\",org.eclipse.osgi.sto\r\n ragemanager;version=\"1.0\",org.eclipse.osgi.util;version=\"1.0\",org.osg\r\n i.framework;version=\"1.3\",org.osgi.service.condpermadmin;version=\"1.0\r\n \",org.osgi.service.packageadmin;version=\"1.2\",org.osgi.service.permis\r\n sionadmin;version=\"1.2\",org.osgi.service.startlevel;version=\"1.0\",org\r\n .osgi.service.url;version=\"1.0\",org.osgi.util.tracker;version=\"1.3.2\"\r\n ,org.eclipse.core.runtime.adaptor;x-friends:=\"org.eclipse.core.runtim\r\n e\",org.eclipse.core.runtime.internal.adaptor;x-internal:=true,org.ecl\r\n ipse.core.runtime.internal.stats;x-friends:=\"org.eclipse.core.runtime\r\n \",org.eclipse.osgi.baseadaptor;x-internal:=true,org.eclipse.osgi.base\r\n adaptor.bundlefile;x-internal:=true,org.eclipse.osgi.baseadaptor.hook\r\n s;x-internal:=true,org.eclipse.osgi.baseadaptor.loader;x-internal:=tr\r\n ue,org.eclipse.osgi.framework.adaptor;x-internal:=true,org.eclipse.os\r\n gi.framework.debug;x-internal:=true,org.eclipse.osgi.framework.intern\r\n al.core;x-internal:=true,org.eclipse.osgi.framework.internal.protocol\r\n ;x-internal:=true,org.eclipse.osgi.framework.internal.protocol.bundle\r\n entry;x-internal:=true,org.eclipse.osgi.framework.internal.protocol.b\r\n undleresource;x-internal:=true,org.eclipse.osgi.framework.internal.pr\r\n otocol.reference;x-internal:=true,org.eclipse.osgi.framework.internal\r\n .reliablefile;x-internal:=true,org.eclipse.osgi.framework.launcher;x-\r\n internal:=true,org.eclipse.osgi.framework.util;x-internal:=true,org.e\r\n clipse.osgi.internal.baseadaptor;x-internal:=true,org.eclipse.osgi.in\r\n ternal.module;x-internal:=true,org.eclipse.osgi.internal.profile;x-in\r\n ternal:=true,org.eclipse.osgi.internal.resolver;x-internal:=true,org.\r\n eclipse.osgi.internal.verifier;x-internal:=true,org.eclipse.osgi.inte\r\n rnal.provisional.verifier;x-friends:=\"org.eclipse.update.core,org.ecl\r\n ipse.ui.workbench\"\r\nBundle-Version: 3.3.0.v20060925\r\nEclipse-SystemBundle: true\r\nBundle-Copyright: %copyright\r\nBundle-Name: %systemBundle\r\nBundle-Description: %systemBundle\r\nBundle-DocUrl: http://www.eclipse.org\r\nBundle-ManifestVersion: 2\r\nExport-Service: org.osgi.service.packageadmin.PackageAdmin,org.osgi.se\r\n rvice.permissionadmin.PermissionAdmin,org.osgi.service.startlevel.Sta\r\n rtLevel,org.eclipse.osgi.service.debug.DebugOptions\r\nBundle-Vendor: %eclipse.org\r\nMain-Class: org.eclipse.core.runtime.adaptor.EclipseStarter\r\nBundle-SymbolicName: org.eclipse.osgi; singleton:=true\r\nBundle-Localization: systembundle\r\nEclipse-ExtensibleAPI: true\r\n\r\n";
        touchpointData.put("manifest", manifest);
        touchpointData.put("uninstall", "setProgramProperty(missing_mandatory_parameters:xyz)");
        IInstallableUnitFragment[] cus = new IInstallableUnitFragment[1];
        MetadataFactory.InstallableUnitFragmentDescription desc = new MetadataFactory.InstallableUnitFragmentDescription();
        desc.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        cus[0] = MetadataFactory.createInstallableUnitFragment((MetadataFactory.InstallableUnitFragmentDescription)desc);
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
        return MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)iu, (IInstallableUnitFragment[])cus);
    }

    private IInstallableUnit createBadUninstallIUThrowsException() {
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        description.setId("org.eclipse.osgi.bad");
        description.setVersion(Version.create((String)"3.3.1.R33x_v20070828"));
        description.setTouchpointType(AbstractProvisioningTest.TOUCHPOINT_OSGI);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        String manifest = "Manifest-Version: 1.0\r\nBundle-Activator: org.eclipse.osgi.framework.internal.core.SystemBundl\r\n eActivator\r\nBundle-RequiredExecutionEnvironment: J2SE-1.4,OSGi/Minimum-1.0\r\nExport-Package: org.eclipse.osgi.event;version=\"1.0\",org.eclipse.osgi.\r\n framework.console;version=\"1.0\",org.eclipse.osgi.framework.eventmgr;v\r\n ersion=\"1.0\",org.eclipse.osgi.framework.log;version=\"1.0\",org.eclipse\r\n .osgi.service.datalocation;version=\"1.0\",org.eclipse.osgi.service.deb\r\n ug;version=\"1.0\",org.eclipse.osgi.service.environment;version=\"1.0\",o\r\n rg.eclipse.osgi.service.localization;version=\"1.0\",org.eclipse.osgi.s\r\n ervice.pluginconversion;version=\"1.0\",org.eclipse.osgi.service.resolv\r\n er;version=\"1.1\",org.eclipse.osgi.service.runnable;version=\"1.0\",org.\r\n eclipse.osgi.service.urlconversion;version=\"1.0\",org.eclipse.osgi.sto\r\n ragemanager;version=\"1.0\",org.eclipse.osgi.util;version=\"1.0\",org.osg\r\n i.framework;version=\"1.3\",org.osgi.service.condpermadmin;version=\"1.0\r\n \",org.osgi.service.packageadmin;version=\"1.2\",org.osgi.service.permis\r\n sionadmin;version=\"1.2\",org.osgi.service.startlevel;version=\"1.0\",org\r\n .osgi.service.url;version=\"1.0\",org.osgi.util.tracker;version=\"1.3.2\"\r\n ,org.eclipse.core.runtime.adaptor;x-friends:=\"org.eclipse.core.runtim\r\n e\",org.eclipse.core.runtime.internal.adaptor;x-internal:=true,org.ecl\r\n ipse.core.runtime.internal.stats;x-friends:=\"org.eclipse.core.runtime\r\n \",org.eclipse.osgi.baseadaptor;x-internal:=true,org.eclipse.osgi.base\r\n adaptor.bundlefile;x-internal:=true,org.eclipse.osgi.baseadaptor.hook\r\n s;x-internal:=true,org.eclipse.osgi.baseadaptor.loader;x-internal:=tr\r\n ue,org.eclipse.osgi.framework.adaptor;x-internal:=true,org.eclipse.os\r\n gi.framework.debug;x-internal:=true,org.eclipse.osgi.framework.intern\r\n al.core;x-internal:=true,org.eclipse.osgi.framework.internal.protocol\r\n ;x-internal:=true,org.eclipse.osgi.framework.internal.protocol.bundle\r\n entry;x-internal:=true,org.eclipse.osgi.framework.internal.protocol.b\r\n undleresource;x-internal:=true,org.eclipse.osgi.framework.internal.pr\r\n otocol.reference;x-internal:=true,org.eclipse.osgi.framework.internal\r\n .reliablefile;x-internal:=true,org.eclipse.osgi.framework.launcher;x-\r\n internal:=true,org.eclipse.osgi.framework.util;x-internal:=true,org.e\r\n clipse.osgi.internal.baseadaptor;x-internal:=true,org.eclipse.osgi.in\r\n ternal.module;x-internal:=true,org.eclipse.osgi.internal.profile;x-in\r\n ternal:=true,org.eclipse.osgi.internal.resolver;x-internal:=true,org.\r\n eclipse.osgi.internal.verifier;x-internal:=true,org.eclipse.osgi.inte\r\n rnal.provisional.verifier;x-friends:=\"org.eclipse.update.core,org.ecl\r\n ipse.ui.workbench\"\r\nBundle-Version: 3.3.0.v20060925\r\nEclipse-SystemBundle: true\r\nBundle-Copyright: %copyright\r\nBundle-Name: %systemBundle\r\nBundle-Description: %systemBundle\r\nBundle-DocUrl: http://www.eclipse.org\r\nBundle-ManifestVersion: 2\r\nExport-Service: org.osgi.service.packageadmin.PackageAdmin,org.osgi.se\r\n rvice.permissionadmin.PermissionAdmin,org.osgi.service.startlevel.Sta\r\n rtLevel,org.eclipse.osgi.service.debug.DebugOptions\r\nBundle-Vendor: %eclipse.org\r\nMain-Class: org.eclipse.core.runtime.adaptor.EclipseStarter\r\nBundle-SymbolicName: org.eclipse.osgi; singleton:=true\r\nBundle-Localization: systembundle\r\nEclipse-ExtensibleAPI: true\r\n\r\n";
        touchpointData.put("manifest", manifest);
        touchpointData.put("uninstall", "thisactionismissing()");
        IInstallableUnitFragment[] cus = new IInstallableUnitFragment[1];
        MetadataFactory.InstallableUnitFragmentDescription desc = new MetadataFactory.InstallableUnitFragmentDescription();
        desc.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        cus[0] = MetadataFactory.createInstallableUnitFragment((MetadataFactory.InstallableUnitFragmentDescription)desc);
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
        return MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)iu, (IInstallableUnitFragment[])cus);
    }

    private IInstallableUnit createMissingActionIU() {
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        description.setId("org.eclipse.osgi.bad");
        description.setVersion(Version.create((String)"3.3.1.R33x_v20070828"));
        description.setTouchpointType(AbstractProvisioningTest.TOUCHPOINT_OSGI);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        String manifest = "Manifest-Version: 1.0\r\nBundle-Activator: org.eclipse.osgi.framework.internal.core.SystemBundl\r\n eActivator\r\nBundle-RequiredExecutionEnvironment: J2SE-1.4,OSGi/Minimum-1.0\r\nExport-Package: org.eclipse.osgi.event;version=\"1.0\",org.eclipse.osgi.\r\n framework.console;version=\"1.0\",org.eclipse.osgi.framework.eventmgr;v\r\n ersion=\"1.0\",org.eclipse.osgi.framework.log;version=\"1.0\",org.eclipse\r\n .osgi.service.datalocation;version=\"1.0\",org.eclipse.osgi.service.deb\r\n ug;version=\"1.0\",org.eclipse.osgi.service.environment;version=\"1.0\",o\r\n rg.eclipse.osgi.service.localization;version=\"1.0\",org.eclipse.osgi.s\r\n ervice.pluginconversion;version=\"1.0\",org.eclipse.osgi.service.resolv\r\n er;version=\"1.1\",org.eclipse.osgi.service.runnable;version=\"1.0\",org.\r\n eclipse.osgi.service.urlconversion;version=\"1.0\",org.eclipse.osgi.sto\r\n ragemanager;version=\"1.0\",org.eclipse.osgi.util;version=\"1.0\",org.osg\r\n i.framework;version=\"1.3\",org.osgi.service.condpermadmin;version=\"1.0\r\n \",org.osgi.service.packageadmin;version=\"1.2\",org.osgi.service.permis\r\n sionadmin;version=\"1.2\",org.osgi.service.startlevel;version=\"1.0\",org\r\n .osgi.service.url;version=\"1.0\",org.osgi.util.tracker;version=\"1.3.2\"\r\n ,org.eclipse.core.runtime.adaptor;x-friends:=\"org.eclipse.core.runtim\r\n e\",org.eclipse.core.runtime.internal.adaptor;x-internal:=true,org.ecl\r\n ipse.core.runtime.internal.stats;x-friends:=\"org.eclipse.core.runtime\r\n \",org.eclipse.osgi.baseadaptor;x-internal:=true,org.eclipse.osgi.base\r\n adaptor.bundlefile;x-internal:=true,org.eclipse.osgi.baseadaptor.hook\r\n s;x-internal:=true,org.eclipse.osgi.baseadaptor.loader;x-internal:=tr\r\n ue,org.eclipse.osgi.framework.adaptor;x-internal:=true,org.eclipse.os\r\n gi.framework.debug;x-internal:=true,org.eclipse.osgi.framework.intern\r\n al.core;x-internal:=true,org.eclipse.osgi.framework.internal.protocol\r\n ;x-internal:=true,org.eclipse.osgi.framework.internal.protocol.bundle\r\n entry;x-internal:=true,org.eclipse.osgi.framework.internal.protocol.b\r\n undleresource;x-internal:=true,org.eclipse.osgi.framework.internal.pr\r\n otocol.reference;x-internal:=true,org.eclipse.osgi.framework.internal\r\n .reliablefile;x-internal:=true,org.eclipse.osgi.framework.launcher;x-\r\n internal:=true,org.eclipse.osgi.framework.util;x-internal:=true,org.e\r\n clipse.osgi.internal.baseadaptor;x-internal:=true,org.eclipse.osgi.in\r\n ternal.module;x-internal:=true,org.eclipse.osgi.internal.profile;x-in\r\n ternal:=true,org.eclipse.osgi.internal.resolver;x-internal:=true,org.\r\n eclipse.osgi.internal.verifier;x-internal:=true,org.eclipse.osgi.inte\r\n rnal.provisional.verifier;x-friends:=\"org.eclipse.update.core,org.ecl\r\n ipse.ui.workbench\"\r\nBundle-Version: 3.3.0.v20060925\r\nEclipse-SystemBundle: true\r\nBundle-Copyright: %copyright\r\nBundle-Name: %systemBundle\r\nBundle-Description: %systemBundle\r\nBundle-DocUrl: http://www.eclipse.org\r\nBundle-ManifestVersion: 2\r\nExport-Service: org.osgi.service.packageadmin.PackageAdmin,org.osgi.se\r\n rvice.permissionadmin.PermissionAdmin,org.osgi.service.startlevel.Sta\r\n rtLevel,org.eclipse.osgi.service.debug.DebugOptions\r\nBundle-Vendor: %eclipse.org\r\nMain-Class: org.eclipse.core.runtime.adaptor.EclipseStarter\r\nBundle-SymbolicName: org.eclipse.osgi; singleton:=true\r\nBundle-Localization: systembundle\r\nEclipse-ExtensibleAPI: true\r\n\r\n";
        touchpointData.put("manifest", manifest);
        touchpointData.put("install", "thisactionismissing()");
        IInstallableUnitFragment[] cus = new IInstallableUnitFragment[1];
        MetadataFactory.InstallableUnitFragmentDescription desc = new MetadataFactory.InstallableUnitFragmentDescription();
        desc.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        cus[0] = MetadataFactory.createInstallableUnitFragment((MetadataFactory.InstallableUnitFragmentDescription)desc);
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
        return MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)iu, (IInstallableUnitFragment[])cus);
    }

    public void testIncompatibleProfile() {
        IProfile profile = new IProfile(){

            public IQueryResult<IInstallableUnit> available(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
                return new Collector();
            }

            public Map getInstallableUnitProperties(IInstallableUnit iu) {
                return null;
            }

            public String getInstallableUnitProperty(IInstallableUnit iu, String key) {
                return null;
            }

            public String getProfileId() {
                return null;
            }

            public Map getProperties() {
                return null;
            }

            public String getProperty(String key) {
                return null;
            }

            public IProvisioningAgent getProvisioningAgent() {
                return EngineTest.getAgent();
            }

            public long getTimestamp() {
                return 0L;
            }

            public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
                return new Collector();
            }
        };
        try {
            IProvisioningPlan plan = this.engine.createPlan(profile, null);
            plan.addInstallableUnit(this.createOSGiIU());
            this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        EngineTest.fail();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActionNPEPhase
    extends CountPhase {
        protected ActionNPEPhase(boolean forced) {
            super("ActionNPEPhase", forced);
        }

        protected ActionNPEPhase() {
            this(false);
        }

        @Override
        protected List<ProvisioningAction> getActions(Operand operand) {
            ProvisioningAction action = new ProvisioningAction(){

                public IStatus undo(Map parameters) {
                    throw new NullPointerException();
                }

                public IStatus execute(Map parameters) {
                    throw new NullPointerException();
                }
            };
            return Collections.singletonList(action);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CountPhase
    extends Phase {
        int operandCount = 0;
        int phaseCount = 0;

        protected CountPhase(String name, boolean forced) {
            super(name, 1, forced);
        }

        protected CountPhase(String name) {
            this(name, false);
        }

        protected IStatus completeOperand(IProfile profile, Operand operand, Map parameters, IProgressMonitor monitor) {
            --this.operandCount;
            return super.completeOperand(profile, operand, parameters, monitor);
        }

        protected IStatus completePhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
            --this.phaseCount;
            return super.completePhase(monitor, profile, parameters);
        }

        protected IStatus initializeOperand(IProfile profile, Operand operand, Map parameters, IProgressMonitor monitor) {
            ++this.operandCount;
            return super.initializeOperand(profile, operand, parameters, monitor);
        }

        protected IStatus initializePhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
            ++this.phaseCount;
            return super.initializePhase(monitor, profile, parameters);
        }

        protected List<ProvisioningAction> getActions(Operand operand) {
            return null;
        }

        public boolean isConsistent() {
            return this.operandCount == 0 && this.phaseCount == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NPEPhase
    extends CountPhase {
        protected NPEPhase() {
            super("NPE");
        }

        @Override
        protected IStatus completePhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
            super.completePhase(monitor, profile, parameters);
            throw new NullPointerException();
        }

        @Override
        protected List<ProvisioningAction> getActions(Operand operand) {
            return null;
        }
    }

    private static class TestPhaseSet
    extends PhaseSet {
        public TestPhaseSet(Phase phase) {
            super(new Phase[]{new Collect(100), new Unconfigure(10), new Uninstall(50), new Property(1), new CheckTrust(10), new Install(50), new Configure(10), phase});
        }

        public TestPhaseSet(boolean forced) {
            super(new Phase[]{new Collect(100), new Unconfigure(10, forced), new Uninstall(50, forced), new Property(1), new CheckTrust(10), new Install(50), new Configure(10)});
        }
    }
}

