/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.io.File;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.engine.ProfileMetadataRepository;
import org.eclipse.equinox.internal.p2.engine.ProfileMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class ProfileMetadataRepositoryTest
extends AbstractProvisioningTest {
    public ProfileMetadataRepositoryTest() {
        super("");
    }

    public ProfileMetadataRepositoryTest(String name) {
        super(name);
    }

    public void testCreate() {
        ProfileMetadataRepositoryFactory factory = new ProfileMetadataRepositoryFactory();
        factory.setAgent(ProfileMetadataRepositoryTest.getAgent());
        try {
            ProfileMetadataRepositoryTest.assertNull((String)"1.0", (Object)factory.create(this.getTempFolder().toURI(), "", "", null));
        }
        catch (ProvisionException e) {
            ProfileMetadataRepositoryTest.fail("1.99", e);
        }
    }

    public void testLoad() {
        File testData = ProfileMetadataRepositoryTest.getTestData("0.1", "testData/sdkpatchingtest");
        File profileFile = new File(new File(testData, "SDKPatchingTest.profile"), "1228337371455.profile.gz");
        ProfileMetadataRepositoryTest.assertTrue((String)"0.15", (boolean)profileFile.exists());
        File tempFolder = this.getTempFolder();
        ProfileMetadataRepositoryTest.copy("0.2", testData, tempFolder);
        SimpleProfileRegistry registry = new SimpleProfileRegistry(ProfileMetadataRepositoryTest.getAgent(), tempFolder, null, false);
        IProfile profile = registry.getProfile("SDKPatchingTest");
        ProfileMetadataRepositoryTest.assertNotNull((String)"0.3", (Object)profile);
        IQueryResult profileCollector = profile.query(QueryUtil.createIUAnyQuery(), this.getMonitor());
        ProfileMetadataRepositoryTest.assertFalse((String)"0.4", (boolean)profileCollector.isEmpty());
        File simpleProfileFolder = new File(tempFolder, "SDKPatchingTest.profile");
        ProfileMetadataRepositoryTest.assertTrue((String)"0.5", (boolean)simpleProfileFolder.exists());
        ProfileMetadataRepositoryFactory factory = new ProfileMetadataRepositoryFactory();
        factory.setAgent(ProfileMetadataRepositoryTest.getAgent());
        ProfileMetadataRepository repo = null;
        try {
            repo = (ProfileMetadataRepository)factory.load(simpleProfileFolder.toURI(), 0, this.getMonitor());
        }
        catch (ProvisionException e1) {
            ProfileMetadataRepositoryTest.fail("0.99", e1);
        }
        IQueryResult repoCollector = repo.query(QueryUtil.createIUAnyQuery(), this.getMonitor());
        ProfileMetadataRepositoryTest.assertFalse((String)"1.0", (boolean)repoCollector.isEmpty());
        ProfileMetadataRepositoryTest.assertContains("1.1", repoCollector, profileCollector);
    }

    public void testLoadTimestampedProfile() {
        File testData = ProfileMetadataRepositoryTest.getTestData("0.1", "testData/sdkpatchingtest");
        File tempFolder = this.getTempFolder();
        ProfileMetadataRepositoryTest.copy("0.2", testData, tempFolder);
        SimpleProfileRegistry registry = new SimpleProfileRegistry(ProfileMetadataRepositoryTest.getAgent(), tempFolder, null, false);
        IProfile profile = registry.getProfile("SDKPatchingTest");
        ProfileMetadataRepositoryTest.assertNotNull((String)"0.3", (Object)profile);
        IQueryResult profileCollector = profile.query(QueryUtil.createIUAnyQuery(), this.getMonitor());
        ProfileMetadataRepositoryTest.assertFalse((String)"0.4", (boolean)profileCollector.isEmpty());
        File simpleProfileFolder = new File(tempFolder, "SDKPatchingTest.profile");
        ProfileMetadataRepositoryTest.assertTrue((String)"0.5", (boolean)simpleProfileFolder.exists());
        File timeStampedProfile = new File(simpleProfileFolder, profile.getTimestamp() + ".profile.gz");
        ProfileMetadataRepositoryTest.assertTrue((String)"0.6", (boolean)timeStampedProfile.exists());
        ProfileMetadataRepositoryFactory factory = new ProfileMetadataRepositoryFactory();
        factory.setAgent(ProfileMetadataRepositoryTest.getAgent());
        ProfileMetadataRepository repo = null;
        try {
            repo = (ProfileMetadataRepository)factory.load(timeStampedProfile.toURI(), 0, this.getMonitor());
        }
        catch (ProvisionException e1) {
            ProfileMetadataRepositoryTest.fail("0.99", e1);
        }
        IQueryResult repoCollector = repo.query(QueryUtil.createIUAnyQuery(), this.getMonitor());
        ProfileMetadataRepositoryTest.assertFalse((String)"1.0", (boolean)repoCollector.isEmpty());
        ProfileMetadataRepositoryTest.assertContains("1.1", repoCollector, profileCollector);
    }

    public void DISABLED_testDefaultAgentRepoAndBundlePoolFromProfileRepo() throws InterruptedException {
        File testData = ProfileMetadataRepositoryTest.getTestData("0.1", "testData/sdkpatchingtest");
        File tempFolder = this.getTempFolder();
        ProfileMetadataRepositoryTest.copy("0.2", testData, tempFolder);
        SimpleArtifactRepositoryFactory simpleFactory = new SimpleArtifactRepositoryFactory();
        simpleFactory.setAgent(ProfileMetadataRepositoryTest.getAgent());
        simpleFactory.create(tempFolder.toURI(), "", "", null);
        File defaultAgenRepositoryDirectory = new File(tempFolder, "p2/org.eclipse.equinox.p2.core/cache");
        simpleFactory.create(defaultAgenRepositoryDirectory.toURI(), "", "", null);
        File profileRegistryFolder = new File(tempFolder, "p2/org.eclipse.equinox.p2.engine/profileRegistry");
        SimpleProfileRegistry registry = new SimpleProfileRegistry(ProfileMetadataRepositoryTest.getAgent(), profileRegistryFolder, null, false);
        IProfile profile = registry.getProfile("SDKPatchingTest");
        ProfileMetadataRepositoryTest.assertNotNull((String)"1.0", (Object)profile);
        IQueryResult profileCollector = profile.query(QueryUtil.createIUAnyQuery(), this.getMonitor());
        ProfileMetadataRepositoryTest.assertFalse((String)"1.1", (boolean)profileCollector.isEmpty());
        File simpleProfileFolder = new File(profileRegistryFolder, "SDKPatchingTest.profile");
        ProfileMetadataRepositoryTest.assertTrue((String)"1.2", (boolean)simpleProfileFolder.exists());
        File timeStampedProfile = new File(simpleProfileFolder, profile.getTimestamp() + ".profile");
        ProfileMetadataRepositoryTest.assertTrue((String)"1.3", (boolean)timeStampedProfile.exists());
        IArtifactRepositoryManager manager = ProfileMetadataRepositoryTest.getArtifactRepositoryManager();
        ProfileMetadataRepositoryTest.assertNotNull((String)"2.0", (Object)manager);
        ProfileMetadataRepositoryTest.assertFalse((String)"2.1", (boolean)manager.contains(tempFolder.toURI()));
        ProfileMetadataRepositoryFactory factory = new ProfileMetadataRepositoryFactory();
        factory.setAgent(ProfileMetadataRepositoryTest.getAgent());
        ProfileMetadataRepository repo = null;
        try {
            repo = (ProfileMetadataRepository)factory.load(timeStampedProfile.toURI(), 0, this.getMonitor());
        }
        catch (ProvisionException e1) {
            ProfileMetadataRepositoryTest.fail("2.99", e1);
        }
        IQueryResult repoCollector = repo.query(QueryUtil.createIUAnyQuery(), this.getMonitor());
        ProfileMetadataRepositoryTest.assertFalse((String)"3.0", (boolean)repoCollector.isEmpty());
        ProfileMetadataRepositoryTest.assertContains("3.1", repoCollector, profileCollector);
        int maxTries = 20;
        int current = 0;
        while (!manager.contains(tempFolder.toURI()) || !manager.contains(defaultAgenRepositoryDirectory.toURI())) {
            if (++current == maxTries) {
                ProfileMetadataRepositoryTest.fail((String)"profile artifact repos not added");
            }
            Thread.sleep(100L);
        }
    }
}

