/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;

public class ProfileRegistryTest
extends AbstractProvisioningTest {
    private static final String PROFILE_NAME = "ProfileRegistryTest.profile";
    private IProfileRegistry registry;

    public ProfileRegistryTest() {
        super("");
    }

    public ProfileRegistryTest(String name) {
        super(name);
    }

    protected void getServices() {
        this.registry = (IProfileRegistry)ProfileRegistryTest.getAgent().getService(IProfileRegistry.SERVICE_NAME);
    }

    private void ungetServices() {
        this.registry = null;
    }

    private static void saveProfile(IProfileRegistry iRegistry, Profile profile) {
        SimpleProfileRegistry registry = (SimpleProfileRegistry)iRegistry;
        profile.setChanged(false);
        registry.lockProfile(profile);
        try {
            profile.setChanged(true);
            registry.updateProfile(profile);
        }
        finally {
            registry.unlockProfile((IProfile)profile);
            profile.setChanged(false);
        }
    }

    private void restart() {
        try {
            this.ungetServices();
            this.getServices();
        }
        catch (Exception e) {
            ProfileRegistryTest.fail();
            e.printStackTrace();
        }
    }

    protected void setUp() throws Exception {
        this.getServices();
        this.registry.removeProfile(PROFILE_NAME);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.ungetServices();
    }

    public void testAddRemoveProfile() {
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(PROFILE_NAME));
        IProfile test = this.createProfile(PROFILE_NAME);
        ProfileRegistryTest.assertEquals((String)test.getProfileId(), (String)this.registry.getProfile(PROFILE_NAME).getProfileId());
        this.registry.removeProfile(PROFILE_NAME);
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(PROFILE_NAME));
    }

    public void testBasicPeristence() {
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(PROFILE_NAME));
        IProfile test = this.createProfile(PROFILE_NAME);
        ProfileRegistryTest.assertEquals((String)test.getProfileId(), (String)this.registry.getProfile(PROFILE_NAME).getProfileId());
        this.restart();
        test = this.registry.getProfile(PROFILE_NAME);
        ProfileRegistryTest.assertNotNull((Object)test);
        this.registry.removeProfile(PROFILE_NAME);
        this.restart();
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(PROFILE_NAME));
    }

    public void testPropertyPeristence() throws ProvisionException {
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(PROFILE_NAME));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("test", "test");
        Profile profile = (Profile)this.registry.addProfile(PROFILE_NAME, properties);
        ProfileRegistryTest.assertTrue((boolean)profile.getProperties().containsKey("test"));
        this.restart();
        profile = (Profile)this.registry.getProfile(PROFILE_NAME);
        ProfileRegistryTest.assertNotNull((Object)profile);
        ProfileRegistryTest.assertTrue((boolean)profile.getProperties().containsKey("test"));
        profile.removeProperty("test");
        ProfileRegistryTest.assertNull((Object)profile.getProperty("test"));
        ProfileRegistryTest.saveProfile(this.registry, profile);
        this.restart();
        profile = (Profile)this.registry.getProfile(PROFILE_NAME);
        ProfileRegistryTest.assertNull((Object)profile.getProperty("test"));
        this.registry.removeProfile(PROFILE_NAME);
        this.restart();
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(PROFILE_NAME));
    }

    public void testIUPeristence() throws ProvisionException {
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(PROFILE_NAME));
        Profile profile = (Profile)this.registry.addProfile(PROFILE_NAME);
        ProfileRegistryTest.assertTrue((boolean)profile.query(QueryUtil.createIUAnyQuery(), null).isEmpty());
        profile.addInstallableUnit(ProfileRegistryTest.createIU("test"));
        ProfileRegistryTest.assertEquals((int)1, (int)ProfileRegistryTest.queryResultSize(profile.query(QueryUtil.createIUAnyQuery(), null)));
        ProfileRegistryTest.saveProfile(this.registry, profile);
        this.restart();
        profile = (Profile)this.registry.getProfile(PROFILE_NAME);
        ProfileRegistryTest.assertEquals((int)1, (int)ProfileRegistryTest.queryResultSize(profile.query(QueryUtil.createIUAnyQuery(), null)));
        profile.removeInstallableUnit(ProfileRegistryTest.createIU("test"));
        ProfileRegistryTest.assertTrue((boolean)profile.query(QueryUtil.createIUAnyQuery(), null).isEmpty());
        ProfileRegistryTest.saveProfile(this.registry, profile);
        this.restart();
        profile = (Profile)this.registry.getProfile(PROFILE_NAME);
        ProfileRegistryTest.assertTrue((boolean)profile.query(QueryUtil.createIUAnyQuery(), null).isEmpty());
        this.registry.removeProfile(PROFILE_NAME);
        this.restart();
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(PROFILE_NAME));
    }

    public void testIUPropertyPeristence() throws ProvisionException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("test", "test");
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(PROFILE_NAME));
        Profile profile = (Profile)this.registry.addProfile(PROFILE_NAME);
        profile.addInstallableUnit(ProfileRegistryTest.createIU("test"));
        profile.addInstallableUnitProperties(ProfileRegistryTest.createIU("test"), properties);
        ProfileRegistryTest.assertEquals((String)"test", (String)profile.getInstallableUnitProperty(ProfileRegistryTest.createIU("test"), "test"));
        ProfileRegistryTest.saveProfile(this.registry, profile);
        this.restart();
        profile = (Profile)this.registry.getProfile(PROFILE_NAME);
        ProfileRegistryTest.assertEquals((String)"test", (String)profile.getInstallableUnitProperty(ProfileRegistryTest.createIU("test"), "test"));
        profile.removeInstallableUnitProperty(ProfileRegistryTest.createIU("test"), "test");
        ProfileRegistryTest.assertNull((Object)profile.getInstallableUnitProperty(ProfileRegistryTest.createIU("test"), "test"));
        ProfileRegistryTest.saveProfile(this.registry, profile);
        this.restart();
        profile = (Profile)this.registry.getProfile(PROFILE_NAME);
        ProfileRegistryTest.assertNull((Object)profile.getInstallableUnitProperty(ProfileRegistryTest.createIU("test"), "test"));
        this.registry.removeProfile(PROFILE_NAME);
        this.restart();
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(PROFILE_NAME));
    }

    public void testBogusRegistry() {
        File testData = ProfileRegistryTest.getTestData("0.1", "testData/engineTest/bogusRegistryContent");
        File tempFolder = this.getTempFolder();
        ProfileRegistryTest.copy("0.2", testData, tempFolder);
        this.createAndValidateProfileRegistry(tempFolder, "SDKProfile");
    }

    public void testTimestampedProfiles() throws ProvisionException {
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(PROFILE_NAME));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("test", "test");
        Profile profile = (Profile)this.registry.addProfile(PROFILE_NAME, properties);
        long oldtimestamp = profile.getTimestamp();
        ProfileRegistryTest.assertTrue((boolean)profile.getProperties().containsKey("test"));
        long[] timestamps = this.registry.listProfileTimestamps(PROFILE_NAME);
        ProfileRegistryTest.assertEquals((int)1, (int)timestamps.length);
        ProfileRegistryTest.assertTrue((boolean)profile.getProperties().containsKey("test"));
        profile.removeProperty("test");
        ProfileRegistryTest.assertNull((Object)profile.getProperty("test"));
        ProfileRegistryTest.saveProfile(this.registry, profile);
        timestamps = this.registry.listProfileTimestamps(PROFILE_NAME);
        ProfileRegistryTest.assertEquals((int)2, (int)timestamps.length);
        Profile oldProfile = (Profile)this.registry.getProfile(PROFILE_NAME, oldtimestamp);
        ProfileRegistryTest.assertTrue((boolean)oldProfile.getProperties().containsKey("test"));
        ProfileRegistryTest.assertFalse((profile.getTimestamp() == oldProfile.getTimestamp() ? 1 : 0) != 0);
        this.registry.removeProfile(PROFILE_NAME);
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(PROFILE_NAME, oldtimestamp));
        timestamps = this.registry.listProfileTimestamps(PROFILE_NAME);
        ProfileRegistryTest.assertEquals((int)0, (int)timestamps.length);
    }

    public void testIsCurrent() throws Exception {
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(PROFILE_NAME));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("test", "test");
        Profile profile = (Profile)this.registry.addProfile(PROFILE_NAME, properties);
        ProfileRegistryTest.assertTrue((boolean)this.registry.isCurrent((IProfile)profile));
        profile.setProperty("x", "1");
        ProfileRegistryTest.assertFalse((boolean)this.registry.isCurrent((IProfile)profile));
        profile = (Profile)this.registry.getProfile(PROFILE_NAME);
        ProfileRegistryTest.assertTrue((boolean)this.registry.isCurrent((IProfile)profile));
        SimpleProfileRegistry simpleRegistry = (SimpleProfileRegistry)this.registry;
        Profile profile2 = (Profile)this.registry.getProfile(PROFILE_NAME);
        simpleRegistry.lockProfile(profile2);
        try {
            profile2.setProperty("x", "1");
            simpleRegistry.updateProfile(profile2);
        }
        finally {
            simpleRegistry.unlockProfile((IProfile)profile2);
        }
        ProfileRegistryTest.assertFalse((boolean)this.registry.isCurrent((IProfile)profile));
        profile = (Profile)this.registry.getProfile(PROFILE_NAME);
        ProfileRegistryTest.assertTrue((boolean)this.registry.isCurrent((IProfile)profile));
        IAgentLocation agentLocation = ProfileRegistryTest.getAgentLocation();
        SimpleProfileRegistry simpleRegistry2 = new SimpleProfileRegistry(ProfileRegistryTest.getAgent(), SimpleProfileRegistry.getDefaultRegistryDirectory((IAgentLocation)agentLocation));
        profile2 = (Profile)simpleRegistry2.getProfile(PROFILE_NAME);
        simpleRegistry2.lockProfile(profile2);
        try {
            profile2.setProperty("x", "2");
            simpleRegistry2.updateProfile(profile2);
        }
        finally {
            simpleRegistry2.unlockProfile((IProfile)profile2);
        }
        ProfileRegistryTest.assertFalse((boolean)this.registry.isCurrent((IProfile)profile));
        profile = (Profile)this.registry.getProfile(PROFILE_NAME);
        ProfileRegistryTest.assertTrue((boolean)this.registry.isCurrent((IProfile)profile));
    }

    public void testProfileLockingNested() {
        File testData = ProfileRegistryTest.getTestData("0.1", "testData/engineTest/SimpleRegistry");
        File tempFolder = this.getTempFolder();
        ProfileRegistryTest.copy("0.2", testData, tempFolder);
        SimpleProfileRegistry simpleRgy = this.createAndValidateProfileRegistry(tempFolder, "Simple");
        Profile simpleProfile = (Profile)simpleRgy.getProfile("Simple");
        ProfileRegistryTest.assertNotNull((Object)simpleProfile);
        simpleRgy.lockProfile(simpleProfile);
        simpleRgy.unlockProfile((IProfile)simpleProfile);
        try {
            simpleRgy.unlockProfile((IProfile)simpleProfile);
            ProfileRegistryTest.fail((String)"Should not allow unlock() without calling lock() first");
        }
        catch (IllegalStateException illegalStateException) {}
        simpleRgy.lockProfile(simpleProfile);
        try {
            simpleRgy.lockProfile(simpleProfile);
            ProfileRegistryTest.fail((String)"Profile does not permit reentrant locking");
        }
        catch (IllegalStateException illegalStateException) {}
        simpleRgy.unlockProfile((IProfile)simpleProfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProfileLockingInProcessMultiThreads() {
        File testData = ProfileRegistryTest.getTestData("0.1", "testData/engineTest/SimpleRegistry");
        File tempFolder = this.getTempFolder();
        ProfileRegistryTest.copy("0.2", testData, tempFolder);
        final SimpleProfileRegistry simpleRgy = this.createAndValidateProfileRegistry(tempFolder, "Simple");
        final Profile simpleProfile = (Profile)simpleRgy.getProfile("Simple");
        ProfileRegistryTest.assertNotNull((Object)simpleProfile);
        simpleRgy.lockProfile(simpleProfile);
        final Object lock = new Object();
        Thread t1 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    simpleRgy.unlockProfile((IProfile)simpleProfile);
                    ProfileRegistryTest.fail((String)"This thread is not the owner and unlock should have failed!");
                }
                catch (IllegalStateException illegalStateException) {}
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            }
        };
        Object object = lock;
        synchronized (object) {
            t1.start();
            try {
                lock.wait(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Thread t2 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block8: {
                    try {
                        try {
                            simpleRgy.lockProfile(simpleProfile);
                        }
                        catch (IllegalStateException illegalStateException) {
                            ProfileRegistryTest.fail((String)"The profile should let the thread wait until it can be locked!");
                            simpleRgy.unlockProfile((IProfile)simpleProfile);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        simpleRgy.unlockProfile((IProfile)simpleProfile);
                        throw throwable;
                    }
                    simpleRgy.unlockProfile((IProfile)simpleProfile);
                }
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            }
        };
        Object object2 = lock;
        synchronized (object2) {
            t2.start();
            ProfileRegistryTest.yieldAndWait();
            simpleRgy.unlockProfile((IProfile)simpleProfile);
            try {
                lock.wait(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        simpleRgy.removeProfile(PROFILE_NAME);
    }

    private SimpleProfileRegistry createAndValidateProfileRegistry(File registryFolder, String id) {
        SimpleProfileRegistry simpleRegistry = new SimpleProfileRegistry(ProfileRegistryTest.getAgent(), registryFolder, null, false);
        IProfile[] profiles = simpleRegistry.getProfiles();
        ProfileRegistryTest.assertNotNull((Object)profiles);
        ProfileRegistryTest.assertEquals((int)1, (int)profiles.length);
        ProfileRegistryTest.assertEquals((String)id, (String)profiles[0].getProfileId());
        return simpleRegistry;
    }

    static File getResourceAsBundleRelFile(String bundleRelPathStr) throws IOException {
        return new File(FileLocator.resolve((URL)TestActivator.getContext().getBundle().getEntry(bundleRelPathStr)).getPath());
    }

    static void yieldAndWait() {
        Thread.yield();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e1) {
            ProfileRegistryTest.fail((String)e1.getMessage());
        }
    }

    public void testPersistenceFormatNotGzipped() {
        IInstallableUnit engineIU = ProfileRegistryTest.createEclipseIU("org.eclipse.equinox.p2.engine", Version.create((String)"1.0.100.v20090605"));
        File folder = this.getTempFolder();
        folder.mkdirs();
        SimpleProfileRegistry profileRegistry = new SimpleProfileRegistry(ProfileRegistryTest.getAgent(), folder, null, false);
        Profile profile = new Profile(ProfileRegistryTest.getAgent(), this.getName(), null, null);
        profile.addInstallableUnit(engineIU);
        try {
            Method saveMethod = this.registry.getClass().getDeclaredMethod("saveProfile", Profile.class);
            saveMethod.setAccessible(true);
            saveMethod.invoke((Object)profileRegistry, profile);
        }
        catch (SecurityException securityException) {
            ProfileRegistryTest.fail();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ProfileRegistryTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ProfileRegistryTest.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            ProfileRegistryTest.fail();
        }
        catch (InvocationTargetException invocationTargetException) {
            ProfileRegistryTest.fail();
        }
        File profileFolder = new File(folder, String.valueOf(this.getName()) + ".profile");
        File[] filesFound = profileFolder.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".profile");
            }
        });
        ProfileRegistryTest.assertEquals((int)1, (int)filesFound.length);
        filesFound = profileFolder.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".profile.gz");
            }
        });
        ProfileRegistryTest.assertEquals((int)0, (int)filesFound.length);
    }

    public void testPersistenceFormatOverride() {
        try {
            IInstallableUnit engineIU = ProfileRegistryTest.createEclipseIU("org.eclipse.equinox.p2.engine", Version.create((String)"55.2"));
            String[] stringArray = new String[4];
            stringArray[0] = "";
            stringArray[1] = "blort";
            stringArray[3] = "uncompressed";
            String[] values = stringArray;
            int i = 0;
            while (i < values.length) {
                final String currentValue = values[i];
                if (currentValue == null) {
                    System.getProperties().remove("eclipse.p2.profileFormat");
                } else {
                    System.getProperties().put("eclipse.p2.profileFormat", currentValue);
                }
                File folder = this.getTempFolder();
                folder.mkdirs();
                SimpleProfileRegistry profileRegistry = new SimpleProfileRegistry(ProfileRegistryTest.getAgent(), folder, null, false);
                Profile profile = new Profile(ProfileRegistryTest.getAgent(), this.getName(), null, null);
                profile.addInstallableUnit(engineIU);
                try {
                    Method saveMethod = this.registry.getClass().getDeclaredMethod("saveProfile", Profile.class);
                    saveMethod.setAccessible(true);
                    saveMethod.invoke((Object)profileRegistry, profile);
                }
                catch (SecurityException e) {
                    ProfileRegistryTest.fail("1.0", e);
                }
                catch (NoSuchMethodException e) {
                    ProfileRegistryTest.fail("1.1", e);
                }
                catch (IllegalArgumentException e) {
                    ProfileRegistryTest.fail("1.2", e);
                }
                catch (IllegalAccessException e) {
                    ProfileRegistryTest.fail("1.3", e);
                }
                catch (InvocationTargetException e) {
                    ProfileRegistryTest.fail("1.4", e);
                }
                File profileFolder = new File(folder, String.valueOf(this.getName()) + ".profile");
                profileFolder.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        if (pathname.getName().endsWith(".profile")) {
                            ProfileRegistryTest.assertEquals((String)("2.0." + currentValue), (String)"uncompressed", (String)currentValue);
                        } else if (pathname.getName().endsWith(".profile.gz")) {
                            ProfileRegistryTest.assertFalse((String)("2.1." + currentValue), (boolean)"uncompressed".equals(currentValue));
                        }
                        return false;
                    }
                });
                ++i;
            }
        }
        finally {
            System.getProperties().remove("eclipse.p2.profileFormat");
        }
    }

    public void testPersistenceFormatGzipped() {
        IInstallableUnit engineIU = ProfileRegistryTest.createEclipseIU("org.eclipse.equinox.p2.engine", Version.create((String)"1.0.101"));
        File folder = this.getTempFolder();
        folder.mkdirs();
        SimpleProfileRegistry profileRegistry = new SimpleProfileRegistry(ProfileRegistryTest.getAgent(), folder, null, false);
        Profile profile = new Profile(ProfileRegistryTest.getAgent(), this.getName(), null, null);
        profile.addInstallableUnit(engineIU);
        try {
            Method saveMethod = this.registry.getClass().getDeclaredMethod("saveProfile", Profile.class);
            saveMethod.setAccessible(true);
            saveMethod.invoke((Object)profileRegistry, profile);
        }
        catch (SecurityException securityException) {
            ProfileRegistryTest.fail();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ProfileRegistryTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ProfileRegistryTest.fail();
        }
        catch (IllegalAccessException illegalAccessException) {
            ProfileRegistryTest.fail();
        }
        catch (InvocationTargetException invocationTargetException) {
            ProfileRegistryTest.fail();
        }
        File profileFolder = new File(folder, String.valueOf(this.getName()) + ".profile");
        File[] filesFound = profileFolder.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".profile.gz");
            }
        });
        ProfileRegistryTest.assertEquals((int)1, (int)filesFound.length);
    }

    public void testRemoveProfileTimestamps() throws ProvisionException {
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(PROFILE_NAME));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("test", "test");
        Profile profile = (Profile)this.registry.addProfile(PROFILE_NAME, properties);
        ProfileRegistryTest.assertTrue((boolean)profile.getProperties().containsKey("test"));
        long[] timestamps = this.registry.listProfileTimestamps(PROFILE_NAME);
        ProfileRegistryTest.assertEquals((int)1, (int)timestamps.length);
        ProfileRegistryTest.assertTrue((boolean)profile.getProperties().containsKey("test"));
        profile.removeProperty("test");
        ProfileRegistryTest.assertNull((Object)profile.getProperty("test"));
        ProfileRegistryTest.saveProfile(this.registry, profile);
        timestamps = this.registry.listProfileTimestamps(PROFILE_NAME);
        ProfileRegistryTest.assertEquals((int)2, (int)timestamps.length);
        profile.setProperty("test2", "test2");
        ProfileRegistryTest.saveProfile(this.registry, profile);
        timestamps = this.registry.listProfileTimestamps(PROFILE_NAME);
        ProfileRegistryTest.assertEquals((int)3, (int)timestamps.length);
        int fail = 0;
        int i = 0;
        while (i < timestamps.length) {
            try {
                this.registry.removeProfile(PROFILE_NAME, timestamps[i]);
            }
            catch (ProvisionException provisionException) {
                ++fail;
            }
            ++i;
        }
        timestamps = this.registry.listProfileTimestamps(PROFILE_NAME);
        ProfileRegistryTest.assertEquals((int)1, (int)timestamps.length);
        ProfileRegistryTest.assertEquals((int)1, (int)fail);
    }

    public void testSetProfileStateProperties() throws ProvisionException {
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(PROFILE_NAME));
        Profile profile = (Profile)this.registry.addProfile(PROFILE_NAME);
        long[] states = this.registry.listProfileTimestamps(profile.getProfileId());
        long goodTimestamp = states[0];
        long badTimestamp = goodTimestamp + 1L;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("foo", "bar");
        try {
            this.registry.setProfileStateProperties(null, goodTimestamp, properties);
            ProfileRegistryTest.fail((String)"Expected a NullPointerException.");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            this.registry.setProfileStateProperties(profile.getProfileId(), goodTimestamp, null);
            ProfileRegistryTest.fail((String)"Expected a NullPointerException.");
        }
        catch (NullPointerException nullPointerException) {}
        ProfileRegistryTest.assertNotOK(this.registry.setProfileStateProperties(profile.getProfileId(), badTimestamp, properties));
        ProfileRegistryTest.assertOK(this.registry.setProfileStateProperties(profile.getProfileId(), goodTimestamp, properties));
        Map result = this.registry.getProfileStateProperties(profile.getProfileId(), goodTimestamp);
        ProfileRegistryTest.assertEquals((int)1, (int)result.size());
        ProfileRegistryTest.assertEquals((String)"bar", (String)((String)result.get("foo")));
        properties.put("foo", "newBar");
        properties.put("two", "three");
        ProfileRegistryTest.assertOK(this.registry.setProfileStateProperties(profile.getProfileId(), goodTimestamp, properties));
        result = this.registry.getProfileStateProperties(profile.getProfileId(), goodTimestamp);
        ProfileRegistryTest.assertEquals((int)2, (int)result.size());
        ProfileRegistryTest.assertEquals((String)"newBar", (String)((String)result.get("foo")));
        ProfileRegistryTest.assertEquals((String)"three", (String)((String)result.get("two")));
    }

    public void testSetProfileStateProperty() throws ProvisionException {
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(PROFILE_NAME));
        Profile profile = (Profile)this.registry.addProfile(PROFILE_NAME);
        long[] states = this.registry.listProfileTimestamps(profile.getProfileId());
        long goodTimestamp = states[0];
        long badTimestamp = goodTimestamp + 1L;
        try {
            this.registry.setProfileStateProperty(null, goodTimestamp, "foo", "bar");
            ProfileRegistryTest.fail((String)"Expected a NullPointerException.");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            this.registry.setProfileStateProperty(profile.getProfileId(), goodTimestamp, null, "bar");
            ProfileRegistryTest.fail((String)"Expected a NullPointerException.");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            this.registry.setProfileStateProperty(profile.getProfileId(), goodTimestamp, "foo", null);
            ProfileRegistryTest.fail((String)"Expected a NullPointerException.");
        }
        catch (NullPointerException nullPointerException) {}
        ProfileRegistryTest.assertNotOK(this.registry.setProfileStateProperty(profile.getProfileId(), badTimestamp, "foo", "bar"));
        ProfileRegistryTest.assertOK(this.registry.setProfileStateProperty(profile.getProfileId(), goodTimestamp, "foo", "bar"));
        Map result = this.registry.getProfileStateProperties(profile.getProfileId(), goodTimestamp);
        ProfileRegistryTest.assertEquals((int)1, (int)result.size());
        ProfileRegistryTest.assertEquals((String)"bar", (String)((String)result.get("foo")));
        ProfileRegistryTest.assertOK(this.registry.setProfileStateProperty(profile.getProfileId(), goodTimestamp, "foo", "newBar"));
        ProfileRegistryTest.assertOK(this.registry.setProfileStateProperty(profile.getProfileId(), goodTimestamp, "two", "three"));
        result = this.registry.getProfileStateProperties(profile.getProfileId(), goodTimestamp);
        ProfileRegistryTest.assertEquals((int)2, (int)result.size());
        ProfileRegistryTest.assertEquals((String)"newBar", (String)((String)result.get("foo")));
        ProfileRegistryTest.assertEquals((String)"three", (String)((String)result.get("two")));
    }

    public void testPruneProfileStateProperties() throws ProvisionException {
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(PROFILE_NAME));
        Profile profile = (Profile)this.registry.addProfile(PROFILE_NAME);
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        profileProperties.put("profileFoo", "profileBar");
        profile.addProperties(profileProperties);
        ProfileRegistryTest.saveProfile(this.registry, profile);
        long[] states = this.registry.listProfileTimestamps(profile.getProfileId());
        ProfileRegistryTest.assertEquals((int)2, (int)this.registry.listProfileTimestamps(profile.getProfileId()).length);
        HashMap<String, String> stateProperties1 = new HashMap<String, String>();
        HashMap<String, String> stateProperties2 = new HashMap<String, String>();
        stateProperties1.put("one", "two");
        stateProperties1.put("a", "b");
        stateProperties1.put("z", "y");
        stateProperties2.put("one", "three");
        stateProperties2.put("a", "c");
        stateProperties2.put("zz", "yy");
        ProfileRegistryTest.assertOK(this.registry.setProfileStateProperties(profile.getProfileId(), states[0], stateProperties1));
        ProfileRegistryTest.assertOK(this.registry.setProfileStateProperties(profile.getProfileId(), states[1], stateProperties2));
        Map result = this.registry.getProfileStateProperties(profile.getProfileId(), states[0]);
        ProfileRegistryTest.assertEquals((int)3, (int)result.size());
        ProfileRegistryTest.assertEquals((String)"two", (String)((String)result.get("one")));
        ProfileRegistryTest.assertEquals((String)"b", (String)((String)result.get("a")));
        ProfileRegistryTest.assertEquals((String)"y", (String)((String)result.get("z")));
        result = this.registry.getProfileStateProperties(profile.getProfileId(), states[1]);
        ProfileRegistryTest.assertEquals((int)3, (int)result.size());
        ProfileRegistryTest.assertEquals((String)"three", (String)((String)result.get("one")));
        ProfileRegistryTest.assertEquals((String)"c", (String)((String)result.get("a")));
        ProfileRegistryTest.assertEquals((String)"yy", (String)((String)result.get("zz")));
        result = this.registry.getProfileStateProperties(profile.getProfileId(), states[1] + 1L);
        ProfileRegistryTest.assertEquals((int)0, (int)result.size());
        this.registry.removeProfile(PROFILE_NAME, states[0]);
        ProfileRegistryTest.assertEquals((int)1, (int)this.registry.listProfileTimestamps(profile.getProfileId()).length);
        ProfileRegistryTest.assertTrue((boolean)this.registry.getProfileStateProperties(profile.getProfileId(), states[0]).isEmpty());
        result = this.registry.getProfileStateProperties(profile.getProfileId(), states[1]);
        ProfileRegistryTest.assertEquals((int)3, (int)result.size());
        ProfileRegistryTest.assertEquals((String)"three", (String)((String)result.get("one")));
        ProfileRegistryTest.assertEquals((String)"c", (String)((String)result.get("a")));
        ProfileRegistryTest.assertEquals((String)"yy", (String)((String)result.get("zz")));
        result = this.registry.getProfileStateProperties(profile.getProfileId(), states[1] + 1L);
        ProfileRegistryTest.assertEquals((int)0, (int)result.size());
        HashMap<String, String> stateProperties3 = new HashMap<String, String>();
        stateProperties3.put("AmIPruned", "yes");
        this.registry.setProfileStateProperties(profile.getProfileId(), states[1], stateProperties3);
        result = this.registry.getProfileStateProperties(profile.getProfileId(), states[0]);
        ProfileRegistryTest.assertEquals((int)0, (int)result.size());
        result = this.registry.getProfileStateProperties(profile.getProfileId(), states[1]);
        ProfileRegistryTest.assertEquals((int)4, (int)result.size());
        ProfileRegistryTest.assertEquals((String)"three", (String)((String)result.get("one")));
        ProfileRegistryTest.assertEquals((String)"c", (String)((String)result.get("a")));
        ProfileRegistryTest.assertEquals((String)"yy", (String)((String)result.get("zz")));
        ProfileRegistryTest.assertEquals((String)"yes", (String)((String)result.get("AmIPruned")));
        result = this.registry.getProfileStateProperties(profile.getProfileId(), states[1] + 1L);
        ProfileRegistryTest.assertEquals((int)0, (int)result.size());
    }

    public void testGetProfileStateProperties() throws ProvisionException {
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(PROFILE_NAME));
        Profile profile = (Profile)this.registry.addProfile(PROFILE_NAME);
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        profileProperties.put("profileFoo", "profileBar");
        profile.addProperties(profileProperties);
        ProfileRegistryTest.saveProfile(this.registry, profile);
        long[] states = this.registry.listProfileTimestamps(profile.getProfileId());
        HashMap<String, String> stateProperties1 = new HashMap<String, String>();
        HashMap<String, String> stateProperties2 = new HashMap<String, String>();
        stateProperties1.put("one", "two");
        stateProperties1.put("a", "b");
        stateProperties1.put("z", "y");
        stateProperties2.put("one", "three");
        stateProperties2.put("a", "c");
        stateProperties2.put("zz", "yy");
        try {
            this.registry.getProfileStateProperties(null, states[0]);
            ProfileRegistryTest.fail((String)"Expected a NullPointerException.");
        }
        catch (NullPointerException nullPointerException) {}
        Map result = this.registry.getProfileStateProperties(profile.getProfileId(), states[0]);
        ProfileRegistryTest.assertEquals((int)0, (int)result.size());
        ProfileRegistryTest.assertOK(this.registry.setProfileStateProperties(profile.getProfileId(), states[0], stateProperties1));
        ProfileRegistryTest.assertOK(this.registry.setProfileStateProperties(profile.getProfileId(), states[1], stateProperties2));
        result = this.registry.getProfileStateProperties(profile.getProfileId(), states[0]);
        ProfileRegistryTest.assertEquals((int)3, (int)result.size());
        ProfileRegistryTest.assertEquals((String)"two", (String)((String)result.get("one")));
        ProfileRegistryTest.assertEquals((String)"b", (String)((String)result.get("a")));
        ProfileRegistryTest.assertEquals((String)"y", (String)((String)result.get("z")));
        result = this.registry.getProfileStateProperties(profile.getProfileId(), states[1]);
        ProfileRegistryTest.assertEquals((int)3, (int)result.size());
        ProfileRegistryTest.assertEquals((String)"three", (String)((String)result.get("one")));
        ProfileRegistryTest.assertEquals((String)"c", (String)((String)result.get("a")));
        ProfileRegistryTest.assertEquals((String)"yy", (String)((String)result.get("zz")));
        result = this.registry.getProfileStateProperties(profile.getProfileId(), states[1] + 1L);
        ProfileRegistryTest.assertEquals((int)0, (int)result.size());
    }

    public void testGetProfileStateProperties2() throws ProvisionException {
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(this.getName()));
        Profile profile = (Profile)this.registry.addProfile(this.getName());
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        profileProperties.put("profileFoo", "profileBar");
        profile.addProperties(profileProperties);
        ProfileRegistryTest.saveProfile(this.registry, profile);
        long[] states = this.registry.listProfileTimestamps(profile.getProfileId());
        HashMap<String, String> stateProperties1 = new HashMap<String, String>();
        HashMap<String, String> stateProperties2 = new HashMap<String, String>();
        stateProperties1.put("one", "two");
        stateProperties1.put("a", "b");
        stateProperties1.put("z", "y");
        stateProperties2.put("one", "three");
        stateProperties2.put("a", "c");
        stateProperties2.put("zz", "yy");
        try {
            this.registry.getProfileStateProperties(null, "foo");
            ProfileRegistryTest.fail((String)"Expected a NullPointerException.");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            this.registry.getProfileStateProperties(profile.getProfileId(), null);
            ProfileRegistryTest.fail((String)"Expected a NullPointerException.");
        }
        catch (NullPointerException nullPointerException) {}
        Map result = this.registry.getProfileStateProperties(profile.getProfileId(), "one");
        ProfileRegistryTest.assertEquals((int)0, (int)result.size());
        ProfileRegistryTest.assertOK(this.registry.setProfileStateProperties(profile.getProfileId(), states[0], stateProperties1));
        ProfileRegistryTest.assertOK(this.registry.setProfileStateProperties(profile.getProfileId(), states[1], stateProperties2));
        result = this.registry.getProfileStateProperties(profile.getProfileId(), "one");
        ProfileRegistryTest.assertEquals((int)2, (int)result.size());
        ProfileRegistryTest.assertEquals((String)"two", (String)((String)result.get(String.valueOf(states[0]))));
        ProfileRegistryTest.assertEquals((String)"three", (String)((String)result.get(String.valueOf(states[1]))));
        result = this.registry.getProfileStateProperties(profile.getProfileId(), "a");
        ProfileRegistryTest.assertEquals((int)2, (int)result.size());
        ProfileRegistryTest.assertEquals((String)"b", (String)((String)result.get(String.valueOf(states[0]))));
        ProfileRegistryTest.assertEquals((String)"c", (String)((String)result.get(String.valueOf(states[1]))));
        result = this.registry.getProfileStateProperties(profile.getProfileId(), "z");
        ProfileRegistryTest.assertEquals((int)1, (int)result.size());
        ProfileRegistryTest.assertEquals((String)"y", (String)((String)result.get(String.valueOf(states[0]))));
        result = this.registry.getProfileStateProperties(profile.getProfileId(), "zz");
        ProfileRegistryTest.assertEquals((int)1, (int)result.size());
        ProfileRegistryTest.assertEquals((String)"yy", (String)((String)result.get(String.valueOf(states[1]))));
        result = this.registry.getProfileStateProperties(profile.getProfileId(), "none");
        ProfileRegistryTest.assertEquals((int)0, (int)result.size());
    }

    public void testRemoveProfileStateProperties() throws ProvisionException {
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(this.getName()));
        Profile profile = (Profile)this.registry.addProfile(this.getName());
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        profileProperties.put("profileFoo", "profileBar");
        profile.addProperties(profileProperties);
        ProfileRegistryTest.saveProfile(this.registry, profile);
        long[] states = this.registry.listProfileTimestamps(profile.getProfileId());
        HashMap<String, String> stateProperties1 = new HashMap<String, String>();
        HashMap<String, String> stateProperties2 = new HashMap<String, String>();
        stateProperties1.put("one", "two");
        stateProperties1.put("a", "b");
        stateProperties1.put("z", "y");
        stateProperties2.put("one", "three");
        stateProperties2.put("a", "c");
        stateProperties2.put("zz", "yy");
        List<String> keys = Arrays.asList("one", "a", "none");
        ProfileRegistryTest.assertOK(this.registry.removeProfileStateProperties(profile.getProfileId(), 1L, keys));
        ProfileRegistryTest.assertOK(this.registry.setProfileStateProperties(profile.getProfileId(), states[0], stateProperties1));
        ProfileRegistryTest.assertOK(this.registry.setProfileStateProperties(profile.getProfileId(), states[1], stateProperties2));
        try {
            this.registry.removeProfileStateProperties(null, states[0], keys);
            ProfileRegistryTest.fail((String)"Expected a NullPointerException.");
        }
        catch (NullPointerException nullPointerException) {}
        ProfileRegistryTest.assertOK(this.registry.removeProfileStateProperties(profile.getProfileId(), states[0], keys));
        Map result = this.registry.getProfileStateProperties(profile.getProfileId(), states[0]);
        ProfileRegistryTest.assertEquals((int)1, (int)result.size());
        ProfileRegistryTest.assertEquals((String)"y", (String)((String)result.get("z")));
        result = this.registry.getProfileStateProperties(profile.getProfileId(), states[1]);
        ProfileRegistryTest.assertEquals((int)3, (int)result.size());
        ProfileRegistryTest.assertEquals((String)"three", (String)((String)result.get("one")));
        ProfileRegistryTest.assertEquals((String)"c", (String)((String)result.get("a")));
        ProfileRegistryTest.assertEquals((String)"yy", (String)((String)result.get("zz")));
    }

    public void testRemoveProfileStateProperties2() throws ProvisionException {
        ProfileRegistryTest.assertNull((Object)this.registry.getProfile(this.getName()));
        Profile profile = (Profile)this.registry.addProfile(this.getName());
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        profileProperties.put("profileFoo", "profileBar");
        profile.addProperties(profileProperties);
        ProfileRegistryTest.saveProfile(this.registry, profile);
        long[] states = this.registry.listProfileTimestamps(profile.getProfileId());
        HashMap<String, String> stateProperties1 = new HashMap<String, String>();
        HashMap<String, String> stateProperties2 = new HashMap<String, String>();
        stateProperties1.put("one", "two");
        stateProperties1.put("a", "b");
        stateProperties1.put("z", "y");
        stateProperties2.put("one", "three");
        stateProperties2.put("a", "c");
        stateProperties2.put("zz", "yy");
        ProfileRegistryTest.assertOK(this.registry.removeProfileStateProperties(profile.getProfileId(), 1L, null));
        ProfileRegistryTest.assertOK(this.registry.setProfileStateProperties(profile.getProfileId(), states[0], stateProperties1));
        ProfileRegistryTest.assertOK(this.registry.setProfileStateProperties(profile.getProfileId(), states[1], stateProperties2));
        Map result = this.registry.getProfileStateProperties(profile.getProfileId(), states[0]);
        ProfileRegistryTest.assertEquals((int)3, (int)result.size());
        result = this.registry.getProfileStateProperties(profile.getProfileId(), states[1]);
        ProfileRegistryTest.assertEquals((int)3, (int)result.size());
        try {
            this.registry.removeProfileStateProperties(null, states[0], null);
            ProfileRegistryTest.fail((String)"Expected a NullPointerException.");
        }
        catch (NullPointerException nullPointerException) {}
        ProfileRegistryTest.assertOK(this.registry.removeProfileStateProperties(profile.getProfileId(), states[0], null));
        result = this.registry.getProfileStateProperties(profile.getProfileId(), states[0]);
        ProfileRegistryTest.assertEquals((int)0, (int)result.size());
        result = this.registry.getProfileStateProperties(profile.getProfileId(), states[1]);
        ProfileRegistryTest.assertEquals((int)3, (int)result.size());
        ProfileRegistryTest.assertEquals((String)"three", (String)((String)result.get("one")));
        ProfileRegistryTest.assertEquals((String)"c", (String)((String)result.get("a")));
        ProfileRegistryTest.assertEquals((String)"yy", (String)((String)result.get("zz")));
    }
}

