/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.spi.Touchpoint;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.engine.PhaseTest;

public class TouchpointTest
extends AbstractProvisioningTest {
    static volatile TestTouchpoint testTouchpoint;
    private IEngine engine;

    public TouchpointTest(String name) {
        super(name);
    }

    public TouchpointTest() {
        super("");
    }

    protected void setUp() throws Exception {
        this.engine = this.getEngine();
    }

    protected void tearDown() throws Exception {
        this.engine = null;
    }

    public void testInitCompleteOperand() {
        if (testTouchpoint != null) {
            testTouchpoint.resetCounters();
        }
        PhaseTest.TestPhaseSet phaseSet = new PhaseTest.TestPhaseSet();
        IProfile profile = this.createProfile("testProfile");
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        plan.addInstallableUnit(this.createTestIU("operandTest"));
        this.engine.perform(plan, (IPhaseSet)phaseSet, (IProgressMonitor)new NullProgressMonitor());
        TouchpointTest.assertEquals((int)1, (int)TouchpointTest.testTouchpoint.initializeOperand);
        TouchpointTest.assertEquals((int)1, (int)TouchpointTest.testTouchpoint.completeOperand);
    }

    public void testInitCompletePhase() {
        if (testTouchpoint != null) {
            testTouchpoint.resetCounters();
        }
        PhaseTest.TestPhaseSet phaseSet = new PhaseTest.TestPhaseSet();
        IProfile profile = this.createProfile("testProfile");
        IProvisioningPlan plan = this.engine.createPlan(profile, null);
        plan.addInstallableUnit(this.createTestIU("phaseTest"));
        this.engine.perform(plan, (IPhaseSet)phaseSet, (IProgressMonitor)new NullProgressMonitor());
        TouchpointTest.assertEquals((int)1, (int)TouchpointTest.testTouchpoint.initializePhase);
        TouchpointTest.assertEquals((int)1, (int)TouchpointTest.testTouchpoint.completePhase);
    }

    private IInstallableUnit createTestIU(String touchpointName) {
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        description.setId("org.eclipse.test");
        description.setVersion(Version.create((String)"1.0.0"));
        description.setTouchpointType(MetadataFactory.createTouchpointType((String)touchpointName, (Version)Version.create((String)"1.0.0")));
        IInstallableUnit unit = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
        return this.createResolvedIU(unit);
    }

    public static class OperandTestTouchpoint
    extends TestTouchpoint {
        public IStatus completeOperand(IProfile profile, Map parameters) {
            TouchpointTest.assertEquals((int)1, (int)this.initializeOperand);
            TouchpointTest.assertEquals((int)0, (int)this.completeOperand);
            super.completeOperand(profile, parameters);
            TouchpointTest.assertEquals((int)1, (int)this.initializeOperand);
            TouchpointTest.assertEquals((int)1, (int)this.completeOperand);
            return null;
        }

        public IStatus initializeOperand(IProfile profile, Map parameters) {
            TouchpointTest.assertEquals((int)0, (int)this.initializeOperand);
            TouchpointTest.assertEquals((int)0, (int)this.completeOperand);
            TouchpointTest.assertTrue((boolean)parameters.containsKey("TestPhase.initializeOperand"));
            super.initializeOperand(profile, parameters);
            TouchpointTest.assertEquals((int)1, (int)this.initializeOperand);
            TouchpointTest.assertEquals((int)0, (int)this.completeOperand);
            return null;
        }

        public String qualifyAction(String actionId) {
            return "operandtest." + actionId;
        }
    }

    public static class PhaseTestTouchpoint
    extends TestTouchpoint {
        public IStatus completePhase(IProgressMonitor monitor, IProfile profile, String phaseId, Map parameters) {
            TouchpointTest.assertEquals((int)1, (int)this.initializePhase);
            TouchpointTest.assertEquals((int)0, (int)this.completePhase);
            super.completePhase(monitor, profile, phaseId, parameters);
            TouchpointTest.assertEquals((int)1, (int)this.initializePhase);
            TouchpointTest.assertEquals((int)1, (int)this.completePhase);
            return null;
        }

        public IStatus initializePhase(IProgressMonitor monitor, IProfile profile, String phaseId, Map parameters) {
            TouchpointTest.assertEquals((int)0, (int)this.initializePhase);
            TouchpointTest.assertEquals((int)0, (int)this.completePhase);
            TouchpointTest.assertTrue((boolean)parameters.containsKey("TestPhase.initializePhase"));
            super.initializePhase(monitor, profile, phaseId, parameters);
            TouchpointTest.assertEquals((int)1, (int)this.initializePhase);
            TouchpointTest.assertEquals((int)0, (int)this.completePhase);
            return null;
        }

        public String qualifyAction(String actionId) {
            return "phasetest." + actionId;
        }
    }

    static abstract class TestTouchpoint
    extends Touchpoint {
        int completeOperand;
        int completePhase;
        int initializeOperand;
        int initializePhase;

        public TestTouchpoint() {
            testTouchpoint = this;
        }

        public IStatus completeOperand(IProfile profile, Map parameters) {
            ++this.completeOperand;
            return super.completeOperand(profile, parameters);
        }

        public IStatus completePhase(IProgressMonitor monitor, IProfile profile, String phaseId, Map touchpointParameters) {
            ++this.completePhase;
            return super.completePhase(monitor, profile, phaseId, touchpointParameters);
        }

        public IStatus initializeOperand(IProfile profile, Map parameters) {
            ++this.initializeOperand;
            return super.initializeOperand(profile, parameters);
        }

        public IStatus initializePhase(IProgressMonitor monitor, IProfile profile, String phaseId, Map touchpointParameters) {
            ++this.initializePhase;
            return super.initializePhase(monitor, profile, phaseId, touchpointParameters);
        }

        public void resetCounters() {
            this.completeOperand = 0;
            this.completePhase = 0;
            this.initializeOperand = 0;
            this.initializePhase = 0;
        }
    }
}

