/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.engine.spi.Value;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class VariableTest
extends AbstractProvisioningTest {
    private IInstallableUnit createIUWithVariable() {
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        description.setId("artifactWithZip");
        description.setVersion(Version.create((String)"1.0.0"));
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("install", "test.actionForVariableTesting( arg1: expectedValue ); test.actionForVariableTesting ( arg1: ${lastResult} ); test.actionForVariableTesting ( arg1: ${lastResult} )");
        description.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
    }

    public void testVariable() {
        Action.reinitForNextTest();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.installFolder", this.getTempFolder().getAbsolutePath());
        IProfile profile = this.createProfile("testVariable1", properties);
        Iterator ius = VariableTest.getInstallableUnits(profile);
        VariableTest.assertFalse((boolean)ius.hasNext());
        IProvisioningPlan plan = this.getEngine().createPlan(profile, null);
        plan.addInstallableUnit(this.createIUWithVariable());
        IStatus result = this.getEngine().perform(plan, PhaseSetFactory.createPhaseSetIncluding((String[])new String[]{PhaseSetFactory.PHASE_INSTALL}), (IProgressMonitor)new NullProgressMonitor());
        VariableTest.assertOK(result);
        VariableTest.assertEquals((String)"expectedValueaaa", (String)Action.result);
    }

    public void testUndo() {
        Action.reinitForNextTest();
        Action.failMode = true;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.installFolder", this.getTempFolder().getAbsolutePath());
        IProfile profile = this.createProfile("testVariable2", properties);
        Iterator ius = VariableTest.getInstallableUnits(profile);
        VariableTest.assertFalse((boolean)ius.hasNext());
        IProvisioningPlan plan = this.getEngine().createPlan(profile, null);
        plan.addInstallableUnit(this.createIUWithVariable());
        IStatus result = this.getEngine().perform(plan, PhaseSetFactory.createPhaseSetIncluding((String[])new String[]{PhaseSetFactory.PHASE_INSTALL}), (IProgressMonitor)new NullProgressMonitor());
        VariableTest.assertNotOK(result);
        VariableTest.assertEquals((int)3, (int)Action.inputValues.size());
        VariableTest.assertEquals((int)3, (int)Action.undoValues.size());
        VariableTest.assertEquals((String)Action.inputValues.get(0), (String)Action.undoValues.get(2));
        VariableTest.assertEquals((String)Action.inputValues.get(1), (String)Action.undoValues.get(1));
        VariableTest.assertEquals((String)Action.inputValues.get(2), (String)Action.undoValues.get(0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Action
    extends ProvisioningAction {
        public static String result;
        public static boolean failMode;
        private static int count;
        private static final int failAt = 3;
        public static ArrayList<String> inputValues;
        public static ArrayList<String> undoValues;

        static {
            count = 0;
            inputValues = new ArrayList();
            undoValues = new ArrayList();
        }

        public static void reinitForNextTest() {
            inputValues = new ArrayList();
            undoValues = new ArrayList();
            failMode = false;
            count = 0;
        }

        public IStatus execute(Map<String, Object> parameters) {
            inputValues.add((String)parameters.get("arg1"));
            System.out.println(((Object)((Object)this)).hashCode());
            System.out.println((String)parameters.get("arg1"));
            if (failMode && ++count == 3) {
                throw new RuntimeException("GENERATED Exception");
            }
            result = String.valueOf((String)parameters.get("arg1")) + "a";
            return Status.OK_STATUS;
        }

        public IStatus undo(Map<String, Object> parameters) {
            undoValues.add((String)parameters.get("arg1"));
            System.out.println("undo arg --> " + (String)parameters.get("arg1"));
            return Status.OK_STATUS;
        }

        public Value<String> getResult() {
            return new Value((Object)result);
        }
    }
}

