/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.engine.spi.Value;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class VariableTest2
extends AbstractProvisioningTest {
    private IInstallableUnit createIUWithVariable() {
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        description.setId("artifactWithZip");
        description.setVersion(Version.create((String)"1.0.0"));
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("install", "test.actionForVariableTesting2( arg1: expectedValue ); test.actionForVariableTesting2( arg1: ${lastResult} );");
        description.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
    }

    public void testNonStringValue() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.installFolder", this.getTempFolder().getAbsolutePath());
        IProfile profile = this.createProfile(this.getName(), properties);
        Iterator ius = VariableTest2.getInstallableUnits(profile);
        VariableTest2.assertFalse((boolean)ius.hasNext());
        IProvisioningPlan plan = this.getEngine().createPlan(profile, null);
        plan.addInstallableUnit(this.createIUWithVariable());
        IStatus result = this.getEngine().perform(plan, PhaseSetFactory.createPhaseSetIncluding((String[])new String[]{PhaseSetFactory.PHASE_INSTALL}), (IProgressMonitor)new NullProgressMonitor());
        VariableTest2.assertOK(result);
        VariableTest2.assertEquals((int)2, (int)Action.inputValues.size());
        VariableTest2.assertEquals(String.class, Action.inputValues.get(0).getClass());
        VariableTest2.assertEquals(Object.class, Action.inputValues.get(1).getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Action
    extends ProvisioningAction {
        public static Object result;
        public static ArrayList<Object> inputValues;

        static {
            inputValues = new ArrayList();
        }

        public IStatus execute(Map<String, Object> parameters) {
            inputValues.add(parameters.get("arg1"));
            result = new Object();
            return Status.OK_STATUS;
        }

        public Value<Object> getResult() {
            return new Value(result);
        }

        public IStatus undo(Map<String, Object> parameters) {
            return null;
        }
    }
}

