/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.full;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.tests.full.AbstractEnd2EndTest;

public class End2EndTest36
extends AbstractEnd2EndTest {
    protected void validateInstallContent(File installFolder) {
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(new File(installFolder, "configuration"));
        launcherData.setLauncher(new File(installFolder, End2EndTest36.getLauncherName("eclipse", Platform.getOS())));
        try {
            manipulator.load();
        }
        catch (IllegalStateException e) {
            End2EndTest36.fail("Error loading the configuration", e);
        }
        catch (FrameworkAdminRuntimeException e) {
            End2EndTest36.fail("Error loading the configuration", e);
        }
        catch (IOException e) {
            End2EndTest36.fail("Error loading the configuration", e);
        }
        this.assertContains("Can't find VM arg", manipulator.getLauncherData().getJvmArgs(), "-Xms40m");
        this.assertContains("Can't find VM arg", manipulator.getLauncherData().getJvmArgs(), "-Xmx384m");
        String[] programArgs = manipulator.getLauncherData().getProgramArgs();
        this.assertContains("Can't find program arg", programArgs, "-startup");
        this.assertContains("Can't find program arg", programArgs, "-showsplash");
        this.assertContains("Can't find program arg", programArgs, "org.eclipse.platform");
        End2EndTest36.assertTrue((manipulator.getConfigData().getBundles().length > 50 ? 1 : 0) != 0);
        End2EndTest36.assertTrue((boolean)new File(installFolder, "plugins").exists());
        End2EndTest36.assertTrue((boolean)new File(installFolder, "features").exists());
    }

    protected URI getRepositoryLocation() {
        return URI.create("http://download.eclipse.org/eclipse/updates/3.6");
    }

    protected VersionedId getPlatform() {
        return new VersionedId("org.eclipse.platform.ide", "3.6.2.M20110210-1200");
    }

    protected VersionedId getPlatformSource() {
        return new VersionedId("org.eclipse.platform.source.feature.group", "3.6.2.r362_v20110210-9gF78Gs1FrIGnHDHWkEcopoN8AmxeZflGDGKQi");
    }
}

