/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.full;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.tests.full.AbstractEnd2EndTest;

public class End2EndTest37
extends AbstractEnd2EndTest {
    protected void validateInstallContent(File installFolder) {
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(new File(installFolder, "configuration"));
        launcherData.setLauncher(new File(installFolder, End2EndTest37.getLauncherName("eclipse", Platform.getOS())));
        try {
            manipulator.load();
        }
        catch (IllegalStateException e) {
            End2EndTest37.fail("Error loading the configuration", e);
        }
        catch (FrameworkAdminRuntimeException e) {
            End2EndTest37.fail("Error loading the configuration", e);
        }
        catch (IOException e) {
            End2EndTest37.fail("Error loading the configuration", e);
        }
        this.assertContains("Can't find VM arg", manipulator.getLauncherData().getJvmArgs(), "-Xms40m");
        this.assertContains("Can't find VM arg", manipulator.getLauncherData().getJvmArgs(), "-Xmx384m");
        String[] programArgs = manipulator.getLauncherData().getProgramArgs();
        this.assertContains("Can't find program arg", programArgs, "-startup");
        this.assertContains("Can't find program arg", programArgs, "-showsplash");
        this.assertContains("Can't find program arg", programArgs, "org.eclipse.platform");
        End2EndTest37.assertTrue((manipulator.getConfigData().getBundles().length > 50 ? 1 : 0) != 0);
        End2EndTest37.assertTrue((boolean)new File(installFolder, "plugins").exists());
        End2EndTest37.assertTrue((boolean)new File(installFolder, "features").exists());
    }

    protected URI getRepositoryLocation() {
        return URI.create("http://download.eclipse.org/eclipse/updates/3.7");
    }

    protected VersionedId getPlatform() {
        return new VersionedId("org.eclipse.platform.ide", "3.7.0.I20110613-1736");
    }

    protected VersionedId getPlatformSource() {
        return new VersionedId("org.eclipse.platform.source.feature.group", "3.7.0.v20110530-9gF7UHNFFt4cwE-pkZDJ7oz-mj4OSEIlu9SEv0f");
    }
}

