/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.full;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.full.AbstractEnd2EndTest;

public class End2EndTestCurrent
extends AbstractEnd2EndTest {
    URI repositoryLocation;
    VersionedId platform;
    VersionedId platformSource;

    protected void validateInstallContent(File installFolder) {
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(new File(installFolder, "configuration"));
        launcherData.setLauncher(new File(installFolder, End2EndTestCurrent.getLauncherName("eclipse", Platform.getOS())));
        try {
            manipulator.load();
        }
        catch (IllegalStateException e) {
            End2EndTestCurrent.fail("Error loading the configuration", e);
        }
        catch (FrameworkAdminRuntimeException e) {
            End2EndTestCurrent.fail("Error loading the configuration", e);
        }
        catch (IOException e) {
            End2EndTestCurrent.fail("Error loading the configuration", e);
        }
        this.assertContains("Can't find VM arg", manipulator.getLauncherData().getJvmArgs(), "-Xms40m");
        this.assertContains("Can't find VM arg", manipulator.getLauncherData().getJvmArgs(), "-Xmx384m");
        String[] programArgs = manipulator.getLauncherData().getProgramArgs();
        this.assertContains("Can't find program arg", programArgs, "-startup");
        this.assertContains("Can't find program arg", programArgs, "-showsplash");
        this.assertContains("Can't find program arg", programArgs, "org.eclipse.platform");
        End2EndTestCurrent.assertTrue((manipulator.getConfigData().getBundles().length > 50 ? 1 : 0) != 0);
        End2EndTestCurrent.assertTrue((boolean)new File(installFolder, "plugins").exists());
        End2EndTestCurrent.assertTrue((boolean)new File(installFolder, "features").exists());
    }

    protected URI getRepositoryLocation() {
        if (this.repositoryLocation == null) {
            String repository = TestActivator.getContext().getProperty("org.eclipse.equinox.p2.tests.current.build.repo");
            End2EndTestCurrent.assertNotNull((String)"Need set the 'org.eclipse.equinox.p2.tests.current.build.repo' property.", (Object)repository);
            this.repositoryLocation = URI.create(repository);
        }
        return this.repositoryLocation;
    }

    private IInstallableUnit getIU(String id) {
        IMetadataRepository repo = null;
        try {
            repo = this.loadMetadataRepository(this.getRepositoryLocation());
        }
        catch (ProvisionException e) {
            End2EndTestCurrent.fail("Problem loading repository: " + this.getRepositoryLocation(), e);
        }
        IQueryResult result = repo.query(QueryUtil.createIUQuery((String)id), this.getMonitor());
        if (result.isEmpty()) {
            End2EndTestCurrent.fail((String)("Unable to load iu: '" + id + "' from repository: " + this.getRepositoryLocation()));
        }
        return (IInstallableUnit)result.iterator().next();
    }

    protected VersionedId getPlatform() {
        if (this.platform == null) {
            IInstallableUnit iu = this.getIU("org.eclipse.platform.ide");
            this.platform = new VersionedId(iu.getId(), iu.getVersion());
        }
        return this.platform;
    }

    protected VersionedId getPlatformSource() {
        if (this.platformSource == null) {
            IInstallableUnit iu = this.getIU("org.eclipse.platform.source.feature.group");
            this.platformSource = new VersionedId(iu.getId(), iu.getVersion());
        }
        return this.platformSource;
    }
}

