/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata;

import junit.framework.TestCase;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;

public class ArtifactKeyParsingTest
extends TestCase {
    public void testSerialize() {
        ArtifactKey key = new ArtifactKey("classifier", "identifier", Version.create((String)"1.0"));
        ArtifactKeyParsingTest.assertEquals((String)"classifier,identifier,1.0.0", (String)key.toExternalForm());
    }

    public void testSerializeEmptyClassifier() {
        ArtifactKey key = new ArtifactKey("", "identifier", Version.create((String)"1.0"));
        ArtifactKeyParsingTest.assertEquals((String)",identifier,1.0.0", (String)key.toExternalForm());
    }

    public void testDeserialize() {
        IArtifactKey key = ArtifactKey.parse((String)"classifier,identifier,1.0.0");
        ArtifactKeyParsingTest.assertNotNull((Object)key);
        ArtifactKeyParsingTest.assertEquals((String)"classifier", (String)key.getClassifier());
        ArtifactKeyParsingTest.assertEquals((String)"identifier", (String)key.getId());
        ArtifactKeyParsingTest.assertEquals((Object)Version.create((String)"1.0"), (Object)key.getVersion());
    }

    public void testDeserializeEmptyClassifier() {
        IArtifactKey key = ArtifactKey.parse((String)",identifier,1.0.0");
        ArtifactKeyParsingTest.assertNotNull((Object)key);
        ArtifactKeyParsingTest.assertEquals((String)"", (String)key.getClassifier());
        ArtifactKeyParsingTest.assertEquals((String)"identifier", (String)key.getId());
        ArtifactKeyParsingTest.assertEquals((Object)Version.create((String)"1.0"), (Object)key.getVersion());
    }

    public void testDeserializeEmptyIdentifier() {
        IArtifactKey key = ArtifactKey.parse((String)"classifier,,1.0.0");
        ArtifactKeyParsingTest.assertNotNull((Object)key);
        ArtifactKeyParsingTest.assertEquals((String)"classifier", (String)key.getClassifier());
        ArtifactKeyParsingTest.assertEquals((String)"", (String)key.getId());
        ArtifactKeyParsingTest.assertEquals((Object)Version.create((String)"1.0"), (Object)key.getVersion());
    }

    public void testDeserializeEmptyVersion() {
        IArtifactKey key = ArtifactKey.parse((String)"classifier,identifier,");
        ArtifactKeyParsingTest.assertNotNull((Object)key);
        ArtifactKeyParsingTest.assertEquals((String)"classifier", (String)key.getClassifier());
        ArtifactKeyParsingTest.assertEquals((String)"identifier", (String)key.getId());
        ArtifactKeyParsingTest.assertEquals((Object)Version.create((String)"0.0"), (Object)key.getVersion());
    }

    public void testDeserializeEmptyEverything() {
        IArtifactKey key = ArtifactKey.parse((String)",,");
        ArtifactKeyParsingTest.assertNotNull((Object)key);
        ArtifactKeyParsingTest.assertEquals((String)"", (String)key.getClassifier());
        ArtifactKeyParsingTest.assertEquals((String)"", (String)key.getId());
        ArtifactKeyParsingTest.assertEquals((Object)Version.create((String)"0.0"), (Object)key.getVersion());
    }

    public void testDeserializeTooFewPartsI() {
        try {
            ArtifactKey.parse((String)"");
            ArtifactKeyParsingTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ArtifactKeyParsingTest.assertTrue((boolean)true);
        }
    }

    public void testDeserializeTooManyPartsI() {
        try {
            ArtifactKey.parse((String)",,,,");
            ArtifactKeyParsingTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ArtifactKeyParsingTest.assertTrue((boolean)true);
        }
    }

    public void testDeserializeTooFewPartsII() {
        try {
            ArtifactKey.parse((String)"classifier");
            ArtifactKeyParsingTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ArtifactKeyParsingTest.assertTrue((boolean)true);
        }
    }
}

