/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata;

import java.util.Collection;
import java.util.HashSet;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.metadata.FragmentTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentMethodTest
extends TestCase {
    private static final String PROP_FRAG = "propFrag";
    private static final String PROP_IU = "propIU";
    private static final String TEST_REQUIRED = "testRequired";
    IInstallableUnit iu1;
    IInstallableUnit iu3;
    Collection<IProvidedCapability> iu1Caps;
    Collection<IProvidedCapability> iu3Caps;

    protected void setUp() throws Exception {
        super.setUp();
        this.iu1 = this.createIU("iu.test1");
        this.iu3 = this.createIUFragment("iu.fragment");
        this.iu1Caps = this.iu1.getProvidedCapabilities();
        this.iu3Caps = this.iu3.getProvidedCapabilities();
        HashSet<IInstallableUnit> hash = new HashSet<IInstallableUnit>();
        hash.add(this.iu1);
        hash.add(this.iu3);
        for (IInstallableUnit iu : hash) {
            if (iu.getId().equals(this.iu1.getId())) {
                this.iu1 = iu;
            }
            if (!iu.getId().equals(this.iu3.getId())) continue;
            this.iu3 = iu;
        }
    }

    protected void tearDown() throws Exception {
        this.iu1 = null;
        this.iu3 = null;
        this.iu1Caps = null;
        this.iu3Caps = null;
        super.tearDown();
    }

    public void testCapabilities() {
        Collection mergedCapabilities = this.iu1.getProvidedCapabilities();
        for (IProvidedCapability capability : mergedCapabilities) {
            FragmentTest.assertContainsWithEquals(mergedCapabilities, capability);
        }
        FragmentMethodTest.assertNull((Object)this.iu1.getProperty("org.eclipse.equinox.p2.type.fragment"));
        Collection<IProvidedCapability> initialFragmentCapabilities = this.iu3Caps;
        for (IProvidedCapability capability : initialFragmentCapabilities) {
            if (!capability.getNamespace().equals("org.eclipse.equinox.p2.iu")) continue;
            FragmentMethodTest.assertDoesNotContain(mergedCapabilities, capability);
            break;
        }
        this.assertEquals("The fragment capabilities should not change", initialFragmentCapabilities, this.iu3.getProvidedCapabilities());
    }

    protected void assertEquals(String message, Object[] expected, Object[] actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            FragmentMethodTest.fail((String)message);
        }
        if (expected.length != actual.length) {
            FragmentMethodTest.fail((String)message);
        }
        int i = 0;
        while (i < expected.length) {
            FragmentMethodTest.assertEquals((String)message, (Object)expected[i], (Object)actual[i]);
            ++i;
        }
    }

    protected void assertEquals(String message, Collection<? extends Object> expected, Collection<? extends Object> actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == actual) {
            return;
        }
        if (expected == null || actual == null) {
            FragmentMethodTest.assertTrue((String)(String.valueOf(message) + ".1"), (boolean)false);
        }
        if (expected.size() != actual.size()) {
            FragmentMethodTest.assertTrue((String)(String.valueOf(message) + ".2"), (boolean)false);
        }
        if (!expected.containsAll(actual)) {
            FragmentMethodTest.fail((String)(String.valueOf(message) + ".3"));
        }
    }

    public static void assertDoesNotContain(Collection<? extends Object> objects, Object searched) {
        if (objects.contains(searched)) {
            throw new AssertionFailedError("The array should not contain the searched element");
        }
    }

    public void testProperties() {
        FragmentMethodTest.assertNotNull((String)"The property is missing", (Object)this.iu3.getProperty(PROP_FRAG));
        FragmentMethodTest.assertNotNull((String)"The property is missing", (Object)this.iu1.getProperty(PROP_IU));
        FragmentMethodTest.assertNull((String)"The property should not be available", (Object)this.iu1.getProperty("doesnotexist"));
    }

    public IInstallableUnit createIUFragment(String name) {
        MetadataFactory.InstallableUnitFragmentDescription iu = new MetadataFactory.InstallableUnitFragmentDescription();
        iu.setId(name);
        iu.setVersion(Version.createOSGi((int)1, (int)0, (int)0));
        iu.setTouchpointType(AbstractProvisioningTest.TOUCHPOINT_OSGI);
        iu.setProperty(PROP_FRAG, "value");
        IRequirement[] reqs = new IRequirement[]{MetadataFactory.createRequirement((String)"eclipse.touchpoint", (String)"bundle", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)TEST_REQUIRED, (String)TEST_REQUIRED, (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)false)};
        iu.setHost(reqs);
        IProvidedCapability[] cap = new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"testCapabilityInFragment", (String)"testCapabilityInFragment", (Version)Version.createOSGi((int)1, (int)0, (int)0))};
        iu.setCapabilities(cap);
        return MetadataFactory.createInstallableUnitFragment((MetadataFactory.InstallableUnitFragmentDescription)iu);
    }

    public IInstallableUnit createIU(String name) {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId(name);
        iu.setVersion(Version.createOSGi((int)1, (int)0, (int)0));
        iu.setTouchpointType(AbstractProvisioningTest.TOUCHPOINT_OSGI);
        iu.setProperty(PROP_IU, "valueIU");
        IProvidedCapability[] cap = new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"eclipse.touchpoint", (String)"bundle", (Version)Version.createOSGi((int)1, (int)0, (int)0)), MetadataFactory.createProvidedCapability((String)"testCapability", (String)"testCapability", (Version)Version.createOSGi((int)1, (int)0, (int)0))};
        iu.setCapabilities(cap);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
    }
}

