/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.AssertionFailedError;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentTest
extends AbstractProvisioningTest {
    public void disabledtestAssociation2Fragments() {
        String ID1 = "iu.1";
        String IDF1 = "iu.fragment.1";
        String IDF2 = "iu.fragment.2";
        IInstallableUnit iu1 = FragmentTest.createEclipseIU(ID1);
        IInstallableUnitFragment iuf1 = FragmentTest.createBundleFragment(IDF1);
        IInstallableUnitFragment iuf2 = FragmentTest.createBundleFragment(IDF2);
        ProfileChangeRequest req = new ProfileChangeRequest(this.createProfile(this.getName()));
        req.addInstallableUnits(new IInstallableUnit[]{iu1, iuf1, iuf2});
        this.createTestMetdataRepository(new IInstallableUnit[]{iu1, iuf1});
        IQueryable additions = FragmentTest.createPlanner().getProvisioningPlan((IProfileChangeRequest)req, null, null).getAdditions();
        Iterator iterator = additions.query(QueryUtil.createIUQuery((String)ID1), null).iterator();
        FragmentTest.assertTrue((String)("Solution contains IU " + ID1), (boolean)iterator.hasNext());
        IInstallableUnit iu = (IInstallableUnit)iterator.next();
        FragmentTest.assertEquals((String)("Number of attached fragments to IU " + ID1), (int)2, (int)iu.getFragments().size());
    }

    public void testAssociation() {
        String ID1 = "iu.1";
        String IDF1 = "iu.fragment.1";
        IInstallableUnit iu1 = FragmentTest.createEclipseIU(ID1);
        IInstallableUnitFragment iuf1 = FragmentTest.createBundleFragment(IDF1);
        ProfileChangeRequest req = new ProfileChangeRequest(this.createProfile(this.getName()));
        req.addInstallableUnits(new IInstallableUnit[]{iu1, iuf1});
        this.createTestMetdataRepository(new IInstallableUnit[]{iu1, iuf1});
        IQueryable additions = FragmentTest.createPlanner().getProvisioningPlan((IProfileChangeRequest)req, null, null).getAdditions();
        Iterator iterator = additions.query(QueryUtil.createIUQuery((String)ID1), null).iterator();
        FragmentTest.assertTrue((String)("Solution contains IU " + ID1), (boolean)iterator.hasNext());
        IInstallableUnit iu = (IInstallableUnit)iterator.next();
        FragmentTest.assertEquals((String)("Number of attached fragments to IU " + ID1), (int)1, (int)iu.getFragments().size());
        FragmentTest.assertEquals((String)("Attached fragment to IU " + ID1), (String)IDF1, (String)((IInstallableUnitFragment)iu.getFragments().iterator().next()).getId());
        iterator = additions.query(QueryUtil.createIUQuery((String)IDF1), null).iterator();
        FragmentTest.assertTrue((String)("Solution contains IU " + IDF1), (boolean)iterator.hasNext());
        iu = (IInstallableUnit)iterator.next();
        FragmentTest.assertEquals((String)("Number of attached fragments to IU " + IDF1), (int)0, (int)iu.getFragments().size());
    }

    public void testAssociation2() {
        String ID1 = "iu.1";
        String ID2 = "iu.2";
        String IDF1 = "iu.fragment.1";
        IInstallableUnit iu1 = FragmentTest.createEclipseIU(ID1);
        IInstallableUnit iu2 = FragmentTest.createEclipseIU(ID2);
        IInstallableUnitFragment iuf1 = FragmentTest.createBundleFragment(IDF1);
        ProfileChangeRequest req = new ProfileChangeRequest(this.createProfile(this.getName()));
        req.addInstallableUnits(new IInstallableUnit[]{iu1, iuf1, iu2});
        this.createTestMetdataRepository(new IInstallableUnit[]{iu1, iuf1, iu2});
        IQueryable additions = FragmentTest.createPlanner().getProvisioningPlan((IProfileChangeRequest)req, null, null).getAdditions();
        Iterator iterator = additions.query(QueryUtil.createIUQuery((String)ID1), null).iterator();
        FragmentTest.assertTrue((String)("Solution contains IU " + ID1), (boolean)iterator.hasNext());
        IInstallableUnit iu = (IInstallableUnit)iterator.next();
        FragmentTest.assertEquals((String)("Number of attached fragments to IU " + ID1), (int)1, (int)iu.getFragments().size());
        FragmentTest.assertEquals((String)("Attached fragment to IU " + ID1), (String)IDF1, (String)((IInstallableUnitFragment)iu.getFragments().iterator().next()).getId());
        iterator = additions.query(QueryUtil.createIUQuery((String)ID2), null).iterator();
        FragmentTest.assertTrue((String)("Solution contains IU " + ID2), (boolean)iterator.hasNext());
        iu = (IInstallableUnit)iterator.next();
        FragmentTest.assertEquals((String)("Number of attached fragments to IU " + ID2), (int)1, (int)iu.getFragments().size());
        FragmentTest.assertEquals((String)("Attached fragment to IU " + ID2), (String)IDF1, (String)((IInstallableUnitFragment)iu.getFragments().iterator().next()).getId());
        iterator = additions.query(QueryUtil.createIUQuery((String)IDF1), null).iterator();
        FragmentTest.assertTrue((String)("Solution contains IU " + IDF1), (boolean)iterator.hasNext());
        iu = (IInstallableUnit)iterator.next();
        FragmentTest.assertEquals((String)("Number of attached fragments to IU " + IDF1), (int)0, (int)iu.getFragments().size());
    }

    public void testTouchpointData() {
        String IDF1 = "iu.fragment.1";
        IInstallableUnit iu1 = this.createIUWithTouchpointData();
        IInstallableUnitFragment iuf1 = FragmentTest.createBundleFragment(IDF1);
        String ID1 = iu1.getId();
        FragmentTest.assertEquals((String)("Number of touchpoint instructions of IU " + ID1), (int)1, (int)iu1.getTouchpointData().size());
        FragmentTest.assertEquals((String)("Number of touchpoint instructions of IU " + IDF1), (int)1, (int)iuf1.getTouchpointData().size());
        ProfileChangeRequest req = new ProfileChangeRequest(this.createProfile(this.getName()));
        req.addInstallableUnits(new IInstallableUnit[]{iu1, iuf1});
        this.createTestMetdataRepository(new IInstallableUnit[]{iu1, iuf1});
        IQueryable additions = FragmentTest.createPlanner().getProvisioningPlan((IProfileChangeRequest)req, null, null).getAdditions();
        Iterator iterator = additions.query(QueryUtil.createIUQuery((String)ID1), null).iterator();
        FragmentTest.assertTrue((String)("Solution contains IU " + ID1), (boolean)iterator.hasNext());
        IInstallableUnit iu = (IInstallableUnit)iterator.next();
        FragmentTest.assertEquals((String)("Number of attached fragments to IU " + ID1), (int)1, (int)iu.getFragments().size());
        FragmentTest.assertEquals((String)("Attached fragment to IU " + ID1), (String)IDF1, (String)((IInstallableUnitFragment)iu.getFragments().iterator().next()).getId());
        FragmentTest.assertEquals((String)("Number of touchpoint instructions of IU " + ID1), (int)2, (int)iu.getTouchpointData().size());
        iterator = additions.query(QueryUtil.createIUQuery((String)IDF1), null).iterator();
        FragmentTest.assertTrue((String)("Solution contains IU " + IDF1), (boolean)iterator.hasNext());
        iu = (IInstallableUnit)iterator.next();
        FragmentTest.assertEquals((String)("Number of attached fragments to IU " + IDF1), (int)0, (int)iu.getFragments().size());
    }

    public void testFragmentCapability() {
        IInstallableUnitFragment iuf1 = FragmentTest.createBundleFragment("iu.fragment.1");
        FragmentTest.assertTrue((boolean)QueryUtil.isFragment((IInstallableUnit)iuf1));
    }

    public void testDefaultIUCapability() {
        IInstallableUnit iu1 = FragmentTest.createEclipseIU("iu.1");
        Collection capabilities = iu1.getProvidedCapabilities();
        for (IProvidedCapability c : capabilities) {
            if (!c.getNamespace().equals("org.eclipse.equinox.p2.iu")) continue;
            FragmentTest.assertEquals((String)c.getNamespace(), (String)"org.eclipse.equinox.p2.iu");
            FragmentTest.assertEquals((String)c.getName(), (String)iu1.getId());
            return;
        }
        throw new AssertionFailedError("No capability for the iu id");
    }

    public static void assertContains(Object[] objects, Object searched) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] == searched) {
                return;
            }
            ++i;
        }
        throw new AssertionFailedError("The array does not contain the searched element");
    }

    public static void assertContainsWithEquals(Collection<? extends Object> objects, Object searched) {
        if (objects.contains(searched)) {
            return;
        }
        throw new AssertionFailedError("The array does not contain the searched element");
    }

    private IInstallableUnit createIUWithTouchpointData() {
        ITouchpointData data = MetadataFactory.createTouchpointData(new HashMap());
        return FragmentTest.createEclipseIU("iu.1", DEFAULT_VERSION, (IRequirement[])NO_REQUIRES, data);
    }
}

