/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.repository;

import java.lang.reflect.Field;
import java.net.URI;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.text.ParseException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.internal.p2.repository.Messages;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.metadata.repository.AllServerTests;
import org.eclipse.equinox.p2.tests.metadata.repository.ServerBasedTestCase;

public class HttpStatusTest
extends ServerBasedTestCase {
    private IMetadataRepositoryManager mgr;
    private URI repoLoc;
    protected String authTestFailMessage;

    public void setUp() throws Exception {
        super.setUp();
        this.mgr = (IMetadataRepositoryManager)HttpStatusTest.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (this.mgr == null) {
            throw new RuntimeException("Repository manager could not be loaded");
        }
    }

    private void setUpRepo(String repo) throws Exception {
        this.repoLoc = new URI(repo);
        this.mgr.removeRepository(this.repoLoc);
        if (this.mgr.contains(this.repoLoc)) {
            throw new RuntimeException("Error - An earlier test did not leave a clean state - could not remove repo");
        }
    }

    public void tearDown() throws Exception {
        AllServerTests.setServiceUI(null);
        super.tearDown();
        if (this.repoLoc != null) {
            this.mgr.removeRepository(this.repoLoc);
        }
    }

    public void testStatusCodes() throws ProvisionException, Exception {
        AllServerTests.setServiceUI(new AladdinNotSavedService());
        this.runSequence(400, 418);
        this.runSequence(422, 426);
        this.runSequence(449, 450);
        this.runSequence(500, 508);
        this.runSequence(510, 510);
    }

    public void testUnknownStatusCodes() throws ProvisionException, Exception {
        AllServerTests.setServiceUI(new AladdinNotSavedService());
        this.runSequence(419, 421);
        this.runSequence(427, 448);
        this.runSequence(511, 601);
    }

    public void testMultipleChoiceCode() throws ProvisionException, Exception {
        AllServerTests.setServiceUI(new AladdinNotSavedService());
        this.runSequence(300, 300);
    }

    private void runSequence(int from, int to) throws Exception {
        int i = from;
        while (i <= to) {
            this.setUpRepo(String.valueOf(super.getBaseURL()) + "/status/" + Integer.valueOf(i).toString());
            try {
                this.mgr.loadRepository(this.repoLoc, null);
            }
            catch (OperationCanceledException operationCanceledException) {
                HttpStatusTest.fail((String)"The repository load was canceled - the UI auth service is probably not running");
            }
            catch (ProvisionException e) {
                IStatus status = e.getStatus();
                String msg = e.getMessage();
                System.out.print(String.format("HTTP %d => %s e-message: [%s]\n", i, HttpStatusTest.provisionCodeToText(status.getCode()), msg));
                switch (i) {
                    case 401: {
                        HttpStatusTest.assertEquals((String)("Expected Provision Exception code for: " + Integer.valueOf(i)), (int)1007, (int)status.getCode());
                        break;
                    }
                    case 300: 
                    case 403: 
                    case 404: {
                        HttpStatusTest.assertEquals((String)("Expected Provision Exception code for: " + Integer.valueOf(i)), (int)1000, (int)status.getCode());
                        break;
                    }
                    default: {
                        try {
                            MessageFormat msgFormat = new MessageFormat(HttpStatusTest.getMessageForCode(i));
                            msgFormat.parse(msg);
                        }
                        catch (ParseException parseException) {
                            HttpStatusTest.fail((String)("The expected message was not returned for the code:" + Integer.valueOf(i)));
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            HttpStatusTest.fail((String)("The expected message was not returned for the code:" + Integer.valueOf(i)));
                        }
                        HttpStatusTest.assertEquals((String)("Expected Provision Exception code for: " + Integer.valueOf(i)), (int)1002, (int)status.getCode());
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HttpStatusTest.assertFalse((String)"Repository should not have been added", (boolean)this.mgr.contains(this.repoLoc));
            ++i;
        }
    }

    private static String getMessageForCode(int code) throws Exception {
        Class<Messages> c = Messages.class;
        try {
            Field field = c.getDeclaredField("TransportErrorTranslator_" + Integer.valueOf(code).toString());
            return (String)field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Field field = c.getDeclaredField("TransportErrorTranslator_UnknownErrorCode");
            return (String)field.get(null);
        }
    }

    private static String provisionCodeToText(int code) {
        String msg = "REPOSITORY_";
        switch (code) {
            case 1001: {
                return String.valueOf(msg) + "EXISTS";
            }
            case 1007: {
                return String.valueOf(msg) + "FAILED_AUTHENTICATION";
            }
            case 1002: {
                return String.valueOf(msg) + "FAILED_READ";
            }
            case 1003: {
                return String.valueOf(msg) + "FAILED_WRITE";
            }
            case 1006: {
                return String.valueOf(msg) + "INVALID_LOCATION";
            }
            case 1000: {
                return String.valueOf(msg) + "NOT_FOUND";
            }
            case 1004: {
                return String.valueOf(msg) + "READ_ONLY";
            }
            case 1005: {
                return String.valueOf(msg) + "UNKNOWN_TYPE";
            }
        }
        return String.valueOf(msg) + String.format("<unrecognized error code: %d >", code);
    }

    public class AladdinNotSavedService
    extends UIServices {
        public int counter = 0;

        public UIServices.AuthenticationInfo getUsernamePassword(String location) {
            ++this.counter;
            return new UIServices.AuthenticationInfo("Aladdin", "open sesame", false);
        }

        public UIServices.AuthenticationInfo getUsernamePassword(String location, UIServices.AuthenticationInfo previousInfo) {
            ++this.counter;
            HttpStatusTest.assertEquals((String)"Aladdin", (String)previousInfo.getUserName());
            HttpStatusTest.assertEquals((String)"open sesame", (String)previousInfo.getPassword());
            HttpStatusTest.assertEquals((boolean)false, (boolean)previousInfo.saveResult());
            return previousInfo;
        }

        public UIServices.TrustInfo getTrustInfo(Certificate[][] untrustedChain, String[] unsignedDetail) {
            return new UIServices.TrustInfo(null, false, true);
        }
    }
}

