/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.repository;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.SynchronousProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class LocalMetadataRepositoryTest
extends AbstractProvisioningTest {
    private static final String TEST_KEY = "TestKey";
    private static final String TEST_VALUE = "TestValue";
    protected File repoLocation;

    protected void setUp() throws Exception {
        super.setUp();
        String tempDir = System.getProperty("java.io.tmpdir");
        this.repoLocation = new File(tempDir, "LocalMetadataRepositoryTest");
        AbstractProvisioningTest.delete(this.repoLocation);
        this.repoLocation.mkdir();
    }

    protected void tearDown() throws Exception {
        LocalMetadataRepositoryTest.getMetadataRepositoryManager().removeRepository(this.repoLocation.toURI());
        LocalMetadataRepositoryTest.delete(this.repoLocation);
        super.tearDown();
    }

    public void testCompressedRepository() throws ProvisionException {
        IMetadataRepositoryManager manager = LocalMetadataRepositoryTest.getMetadataRepositoryManager();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", "true");
        IMetadataRepository repo = manager.createRepository(this.repoLocation.toURI(), "TestRepo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
        MetadataFactory.InstallableUnitDescription descriptor = new MetadataFactory.InstallableUnitDescription();
        descriptor.setId("testIuId");
        descriptor.setVersion(Version.create((String)"3.2.1"));
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)descriptor);
        repo.addInstallableUnits(Arrays.asList(iu));
        File[] files = this.repoLocation.listFiles();
        boolean jarFilePresent = false;
        boolean xmlFilePresent = false;
        int i = 0;
        while (i < files.length) {
            if ("content.jar".equalsIgnoreCase(files[i].getName())) {
                jarFilePresent = true;
            }
            if ("content.xml".equalsIgnoreCase(files[i].getName())) {
                xmlFilePresent = true;
            }
            ++i;
        }
        if (!jarFilePresent) {
            LocalMetadataRepositoryTest.fail((String)"Repository did not create JAR for content.xml");
        }
        if (xmlFilePresent) {
            LocalMetadataRepositoryTest.fail((String)"Repository should not create content.xml");
        }
    }

    public void testGetProperties() throws ProvisionException {
        IMetadataRepositoryManager manager = LocalMetadataRepositoryTest.getMetadataRepositoryManager();
        IMetadataRepository repo = manager.createRepository(this.repoLocation.toURI(), "TestRepo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
        Map properties = repo.getProperties();
        try {
            properties.put(TEST_KEY, TEST_VALUE);
            LocalMetadataRepositoryTest.fail((String)"Should not allow setting property");
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testSetProperty() throws ProvisionException {
        IMetadataRepositoryManager manager = LocalMetadataRepositoryTest.getMetadataRepositoryManager();
        IMetadataRepository repo = manager.createRepository(this.repoLocation.toURI(), "TestRepo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
        Map properties = repo.getProperties();
        LocalMetadataRepositoryTest.assertTrue((String)"1.0", (!properties.containsKey(TEST_KEY) ? 1 : 0) != 0);
        repo.setProperty(TEST_KEY, TEST_VALUE);
        LocalMetadataRepositoryTest.assertTrue((String)"1.1", (!properties.containsKey(TEST_KEY) ? 1 : 0) != 0);
        properties = repo.getProperties();
        LocalMetadataRepositoryTest.assertTrue((String)"1.2", (boolean)properties.containsKey(TEST_KEY));
        repo = manager.loadRepository(this.repoLocation.toURI(), null);
        properties = repo.getProperties();
        LocalMetadataRepositoryTest.assertTrue((String)"1.3", (boolean)properties.containsKey(TEST_KEY));
        repo.setProperty(TEST_KEY, null);
        properties = repo.getProperties();
        LocalMetadataRepositoryTest.assertTrue((String)"1.4", (!properties.containsKey(TEST_KEY) ? 1 : 0) != 0);
    }

    public void testAddRemoveIUs() throws ProvisionException {
        IMetadataRepositoryManager manager = LocalMetadataRepositoryTest.getMetadataRepositoryManager();
        IMetadataRepository repo = manager.createRepository(this.repoLocation.toURI(), "TestRepo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
        IInstallableUnit iu = LocalMetadataRepositoryTest.createIU("foo");
        repo.addInstallableUnits(Arrays.asList(iu));
        IQueryResult result = repo.query(QueryUtil.createIUQuery(null), this.getMonitor());
        LocalMetadataRepositoryTest.assertEquals((String)"1.0", (int)1, (int)LocalMetadataRepositoryTest.queryResultSize(result));
        repo.removeAll();
        result = repo.query(QueryUtil.createIUQuery(null), this.getMonitor());
        LocalMetadataRepositoryTest.assertTrue((String)"1.1", (boolean)result.isEmpty());
    }

    public void testRemoveByQuery() throws ProvisionException {
        IMetadataRepositoryManager manager = LocalMetadataRepositoryTest.getMetadataRepositoryManager();
        IMetadataRepository repo = manager.createRepository(this.repoLocation.toURI(), "TestRepo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
        IInstallableUnit iu = LocalMetadataRepositoryTest.createIU("foo");
        IInstallableUnit iu2 = LocalMetadataRepositoryTest.createIU("bar");
        repo.addInstallableUnits(Arrays.asList(iu, iu2));
        IQueryResult result = repo.query(QueryUtil.createIUQuery(null), this.getMonitor());
        LocalMetadataRepositoryTest.assertEquals((String)"1.0", (int)2, (int)LocalMetadataRepositoryTest.queryResultSize(result));
        repo.removeInstallableUnits(Arrays.asList(iu));
        result = repo.query(QueryUtil.createIUQuery(null), this.getMonitor());
        LocalMetadataRepositoryTest.assertEquals((String)"1.1", (int)1, (int)LocalMetadataRepositoryTest.queryResultSize(result));
        repo.removeInstallableUnits(Arrays.asList(iu2));
        result = repo.query(QueryUtil.createIUQuery(null), this.getMonitor());
        LocalMetadataRepositoryTest.assertTrue((String)"1.2", (boolean)result.isEmpty());
    }

    public void testUncompressedRepository() throws ProvisionException {
        IMetadataRepositoryManager manager = LocalMetadataRepositoryTest.getMetadataRepositoryManager();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", "false");
        IMetadataRepository repo = manager.createRepository(this.repoLocation.toURI(), "TestRepo", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
        MetadataFactory.InstallableUnitDescription descriptor = new MetadataFactory.InstallableUnitDescription();
        descriptor.setId("testIuId");
        descriptor.setVersion(Version.create((String)"3.2.1"));
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)descriptor);
        repo.addInstallableUnits(Arrays.asList(iu));
        File[] files = this.repoLocation.listFiles();
        boolean jarFilePresent = false;
        int i = 0;
        while (i < files.length) {
            if ("content.jar".equalsIgnoreCase(files[i].getName())) {
                jarFilePresent = true;
            }
            ++i;
        }
        if (jarFilePresent) {
            LocalMetadataRepositoryTest.fail((String)"Repository should not create JAR for content.xml");
        }
    }

    public void testLoadSelfReference() throws ProvisionException {
        IMetadataRepositoryManager manager = LocalMetadataRepositoryTest.getMetadataRepositoryManager();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", "false");
        final URI repoURI = this.repoLocation.toURI();
        IMetadataRepository repo = manager.createRepository(repoURI, "testLoadSelfReference", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
        repo.addReferences(Collections.singletonList(new RepositoryReference(repoURI, "testNick", 0, 0)));
        final int[] callCount = new int[1];
        final boolean[] wasEnabled = new boolean[1];
        SynchronousProvisioningListener listener = new SynchronousProvisioningListener(){

            public void notify(EventObject o) {
                if (!(o instanceof RepositoryEvent)) {
                    return;
                }
                RepositoryEvent event = (RepositoryEvent)o;
                if (event.getKind() != 0) {
                    return;
                }
                if (!event.getRepositoryLocation().equals(repoURI)) {
                    return;
                }
                wasEnabled[0] = event.isRepositoryEnabled();
                callCount[0] = callCount[0] + 1;
            }
        };
        IProvisioningEventBus eventBus = this.getEventBus();
        eventBus.addListener((ProvisioningListener)listener);
        try {
            manager.removeRepository(repoURI);
            repo = manager.loadRepository(repoURI, null);
            LocalMetadataRepositoryTest.assertTrue((String)"1.0", (boolean)manager.isEnabled(repoURI));
            LocalMetadataRepositoryTest.assertTrue((String)"1.1", (boolean)wasEnabled[0]);
            LocalMetadataRepositoryTest.assertEquals((String)"1.2", (int)1, (int)callCount[0]);
        }
        finally {
            eventBus.removeListener((ProvisioningListener)listener);
        }
    }

    public void testRefreshSelfReference() throws ProvisionException {
        IMetadataRepositoryManager manager = LocalMetadataRepositoryTest.getMetadataRepositoryManager();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p2.compressed", "false");
        final URI repoURL = this.repoLocation.toURI();
        IMetadataRepository repo = manager.createRepository(repoURL, "testRefreshSelfReference", "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
        repo.addReferences(Collections.singletonList(new RepositoryReference(repoURL, "testNick", 0, 0)));
        if (!manager.isEnabled(repoURL)) {
            manager.setEnabled(repoURL, true);
        }
        final int[] callCount = new int[1];
        final boolean[] wasEnabled = new boolean[1];
        SynchronousProvisioningListener listener = new SynchronousProvisioningListener(){

            public void notify(EventObject o) {
                if (!(o instanceof RepositoryEvent)) {
                    return;
                }
                RepositoryEvent event = (RepositoryEvent)o;
                if (event.getKind() != 0) {
                    return;
                }
                if (!event.getRepositoryLocation().equals(repoURL)) {
                    return;
                }
                wasEnabled[0] = event.isRepositoryEnabled();
                callCount[0] = callCount[0] + 1;
            }
        };
        this.getEventBus().addListener((ProvisioningListener)listener);
        try {
            manager.refreshRepository(repoURL, null);
            LocalMetadataRepositoryTest.assertTrue((String)"1.0", (boolean)manager.isEnabled(repoURL));
            LocalMetadataRepositoryTest.assertTrue((String)"1.1", (boolean)wasEnabled[0]);
            LocalMetadataRepositoryTest.assertEquals((String)"1.2", (int)1, (int)callCount[0]);
        }
        finally {
            this.getEventBus().removeListener((ProvisioningListener)listener);
        }
    }
}

