/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.repository;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ecf.filetransfer.IFileRangeSpecification;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.equinox.internal.p2.transport.ecf.FileReader;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class ResumeDownloadTest
extends AbstractProvisioningTest {
    private static String UPDATE_SITE = "http://download.eclipse.org/eclipse/updates/3.4";
    private IMetadataRepositoryManager mgr;
    private URI repoLoc;
    private String originalResumeProp;
    protected long bytesReceived = 0L;
    protected long entireLength = 0L;
    protected long resumeStart = 0L;
    protected long remainingLength = 0L;
    protected long resumedReceived = 0L;

    protected void setUp() throws Exception {
        super.setUp();
        this.repoLoc = new URI(UPDATE_SITE);
        this.originalResumeProp = System.getProperty("org.eclipse.equinox.p2.metadata.repository.resumable", "true");
        this.mgr = (IMetadataRepositoryManager)ResumeDownloadTest.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (this.mgr == null) {
            throw new RuntimeException("Repository manager could not be loaded");
        }
        this.mgr.removeRepository(this.repoLoc);
        if (this.mgr.contains(this.repoLoc)) {
            throw new RuntimeException("Error - An earlier test did not leave a clean state - could not remove repo");
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        FileReader.setTestProbe(null);
        System.setProperty("org.eclipse.equinox.p2.metadata.repository.resumable", this.originalResumeProp);
        this.mgr.removeRepository(this.repoLoc);
    }

    public void testResume() throws ProvisionException {
        boolean caught = false;
        try {
            FileReader.setTestProbe((FileReader.IFileReaderProbe)new CancelSimulator());
            this.mgr.loadRepository(this.repoLoc, null);
        }
        catch (OperationCanceledException operationCanceledException) {
            caught = true;
        }
        ResumeDownloadTest.assertTrue((String)"Cancel should have been caught (1)", (boolean)caught);
        caught = false;
        FileReader.setTestProbe(null);
        FileReader.setTestProbe((FileReader.IFileReaderProbe)new ResumeCheck());
        this.mgr.loadRepository(this.repoLoc, null);
        ResumeDownloadTest.assertTrue((String)"Cancelation was made before entire file was downloaded", (this.bytesReceived < this.entireLength ? 1 : 0) != 0);
        ResumeDownloadTest.assertEquals((String)"First+remaining size equals entire size", (long)(this.bytesReceived + this.remainingLength), (long)this.entireLength);
        ResumeDownloadTest.assertTrue((String)"Remaining length smaller than entire length", (this.entireLength > this.remainingLength ? 1 : 0) != 0);
    }

    public void testResumeTwice() throws ProvisionException {
        boolean caught = false;
        try {
            FileReader.setTestProbe((FileReader.IFileReaderProbe)new CancelSimulator());
            this.mgr.loadRepository(this.repoLoc, null);
        }
        catch (OperationCanceledException operationCanceledException) {
            caught = true;
        }
        ResumeDownloadTest.assertTrue((String)"Cancel should have been caught (1)", (boolean)caught);
        caught = false;
        try {
            FileReader.setTestProbe((FileReader.IFileReaderProbe)new CancelSimulator());
            this.mgr.loadRepository(this.repoLoc, null);
        }
        catch (OperationCanceledException operationCanceledException) {
            caught = true;
        }
        ResumeDownloadTest.assertTrue((String)"Cancel should have been caught (2)", (boolean)caught);
        caught = false;
        FileReader.setTestProbe(null);
        FileReader.setTestProbe((FileReader.IFileReaderProbe)new ResumeCheck());
        this.mgr.loadRepository(this.repoLoc, null);
        ResumeDownloadTest.assertTrue((String)"Cancelation was made before entire file was downloaded", (this.bytesReceived < this.entireLength ? 1 : 0) != 0);
        ResumeDownloadTest.assertEquals((String)"First+remaining size equals entire size", (long)(this.bytesReceived + this.remainingLength), (long)this.entireLength);
        ResumeDownloadTest.assertTrue((String)"Remaining length smaller than entire length", (this.entireLength > this.remainingLength ? 1 : 0) != 0);
    }

    public void testBlockedResume() throws ProvisionException {
        System.setProperty("org.eclipse.equinox.p2.metadata.repository.resumable", "false");
        boolean caught = false;
        try {
            FileReader.setTestProbe((FileReader.IFileReaderProbe)new CancelSimulator());
            this.mgr.loadRepository(this.repoLoc, null);
        }
        catch (OperationCanceledException operationCanceledException) {
            caught = true;
        }
        ResumeDownloadTest.assertTrue((String)"Cancel should have been caught (1)", (boolean)caught);
        caught = false;
        FileReader.setTestProbe(null);
        FileReader.setTestProbe((FileReader.IFileReaderProbe)new ResumeCheck());
        this.mgr.loadRepository(this.repoLoc, null);
        ResumeDownloadTest.assertTrue((String)"Cancelation was made before entire file was downloaded", (this.bytesReceived < this.entireLength ? 1 : 0) != 0);
        ResumeDownloadTest.assertEquals((String)"Resume starts at 0", (long)0L, (long)this.resumeStart);
        ResumeDownloadTest.assertEquals((String)"Remaining length == original length", (long)this.entireLength, (long)this.remainingLength);
    }

    private class CancelSimulator
    implements FileReader.IFileReaderProbe {
        public void onData(FileReader reader, IIncomingFileTransfer source, IProgressMonitor monitor) {
            ResumeDownloadTest.this.bytesReceived = source.getBytesReceived();
            if (ResumeDownloadTest.this.bytesReceived > 1000L) {
                monitor.setCanceled(true);
            }
        }

        public void onDone(FileReader reader, IIncomingFileTransfer source, IProgressMonitor monitor) {
            ResumeDownloadTest.this.bytesReceived = source.getBytesReceived();
        }

        public void onStart(FileReader reader, IIncomingFileTransfer source, IProgressMonitor monitor) {
            ResumeDownloadTest.this.entireLength = source.getFileLength();
        }
    }

    private class ResumeCheck
    implements FileReader.IFileReaderProbe {
        public void onData(FileReader reader, IIncomingFileTransfer source, IProgressMonitor monitor) {
            ResumeDownloadTest.this.resumedReceived = source.getBytesReceived();
        }

        public void onDone(FileReader reader, IIncomingFileTransfer source, IProgressMonitor monitor) {
        }

        public void onStart(FileReader reader, IIncomingFileTransfer source, IProgressMonitor monitor) {
            IFileRangeSpecification spec = source.getFileRangeSpecification();
            ResumeDownloadTest.this.resumeStart = spec == null ? 0L : spec.getStartPosition();
            ResumeDownloadTest.this.remainingLength = source.getFileLength();
        }
    }
}

