/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.metadata.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.LocalMetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.repository.helpers.LocationProperties;
import org.eclipse.equinox.internal.p2.updatesite.metadata.UpdateSiteMetadataRepository;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.StringBufferStream;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.TestData;
import org.osgi.framework.BundleContext;

public class SiteIndexFileTest
extends AbstractProvisioningTest {
    private void assertArrayOrder(String[] expected, String[] actual) {
        SiteIndexFileTest.assertEquals((int)expected.length, (int)actual.length);
        int i = 0;
        while (i < expected.length) {
            SiteIndexFileTest.assertEquals((String)expected[i], (String)actual[i]);
            ++i;
        }
    }

    public void testSortOrderSimple() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        String[] suffixes = new String[]{"first", "second", "third"};
        suffixes = repositoryManager.sortSuffixes(suffixes, new URI("http://foo"), null);
        this.assertArrayOrder(new String[]{"first", "second", "third"}, suffixes);
    }

    public void testSortOrderSimple2() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        String[] suffixes = new String[]{"first", "second", "third"};
        suffixes = repositoryManager.sortSuffixes(suffixes, new URI("http://foo"), new String[]{"first", "second", "third"});
        this.assertArrayOrder(new String[]{"first", "second", "third"}, suffixes);
    }

    public void testSortOrderSimple3() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        String[] suffixes = new String[]{"first"};
        suffixes = repositoryManager.sortSuffixes(suffixes, new URI("http://foo"), new String[]{"first", "second", "third"});
        this.assertArrayOrder(new String[]{"first"}, suffixes);
    }

    public void testSortOrderSimple4() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        String[] suffixes = new String[]{"first", "second", "third"};
        suffixes = repositoryManager.sortSuffixes(suffixes, new URI("http://foo"), new String[]{"first"});
        this.assertArrayOrder(new String[]{"first", "second", "third"}, suffixes);
    }

    public void testSortOrderSimple5() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        String[] suffixes = new String[]{"first", "second", "third"};
        suffixes = repositoryManager.sortSuffixes(suffixes, new URI("http://foo"), new String[]{"foo", "bar"});
        this.assertArrayOrder(new String[]{"first", "second", "third"}, suffixes);
    }

    public void testSortOrderReverse() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        String[] suffixes = new String[]{"first", "second", "third"};
        suffixes = repositoryManager.sortSuffixes(suffixes, new URI("http://foo"), new String[]{"third", "second", "first"});
        this.assertArrayOrder(new String[]{"third", "second", "first"}, suffixes);
    }

    public void testSortOrderReverse2() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        String[] suffixes = new String[]{"first", "second", "third"};
        suffixes = repositoryManager.sortSuffixes(suffixes, new URI("http://foo"), new String[]{"third"});
        this.assertArrayOrder(new String[]{"third", "first", "second"}, suffixes);
    }

    public void testSortOrderComplex() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        String[] suffixes = new String[]{"a", "b", "c", "d", "e", "f"};
        suffixes = repositoryManager.sortSuffixes(suffixes, new URI("http://foo"), new String[]{"b", "e", "f"});
        this.assertArrayOrder(new String[]{"b", "e", "f", "a", "c", "d"}, suffixes);
    }

    public void testSortOrderAdditional() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        String[] suffixes = new String[]{"a", "b", "c", "d", "e", "f"};
        suffixes = repositoryManager.sortSuffixes(suffixes, new URI("http://foo"), new String[]{"first", "b", "second", "e", "third", "f"});
        this.assertArrayOrder(new String[]{"b", "e", "f", "a", "c", "d"}, suffixes);
    }

    public void testSortOrderDuplicate() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        String[] suffixes = new String[]{"a", "b", "c", "d", "e", "f"};
        suffixes = repositoryManager.sortSuffixes(suffixes, new URI("http://foo"), new String[]{"a", "b", "a"});
        this.assertArrayOrder(new String[]{"a", "b", "c", "d", "e", "f"}, suffixes);
    }

    public void testSortOrderStop() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        String[] suffixes = new String[]{"a", "b", "c", "d", "e", "f"};
        suffixes = repositoryManager.sortSuffixes(suffixes, new URI("http://foo"), new String[]{"a", "!"});
        this.assertArrayOrder(new String[]{"a"}, suffixes);
    }

    public void testSortOrderStopEmpty() throws URISyntaxException {
        VisibleMetadataRepositoryManager repositoryManager = new VisibleMetadataRepositoryManager();
        String[] suffixes = new String[]{"a", "b", "c", "d", "e", "f"};
        suffixes = repositoryManager.sortSuffixes(suffixes, new URI("http://foo"), new String[]{"!"});
        this.assertArrayOrder(new String[0], suffixes);
    }

    public void testNoIndex() throws Exception {
        LocationProperties locationProperties = LocationProperties.create(null);
        SiteIndexFileTest.assertNotNull((Object)locationProperties);
        SiteIndexFileTest.assertFalse((boolean)locationProperties.exists());
    }

    public void testBadIndex1() throws Exception {
        File indexFile = TestData.getFile("metadataRepo/indexfiles", "badIndex.p2");
        FileInputStream inputStream = new FileInputStream(indexFile);
        PrintStream out = System.out;
        LocationProperties locationProperties = null;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            locationProperties = LocationProperties.create((InputStream)inputStream);
        }
        finally {
            System.setOut(out);
        }
        SiteIndexFileTest.assertNotNull((Object)locationProperties);
        SiteIndexFileTest.assertFalse((boolean)locationProperties.exists());
    }

    public void testBadIndex2() throws Exception {
        File indexFile = TestData.getFile("metadataRepo/indexfiles", "badIndex2.p2");
        FileInputStream inputStream = new FileInputStream(indexFile);
        LocationProperties locationProperties = LocationProperties.create((InputStream)inputStream);
        SiteIndexFileTest.assertNotNull((Object)locationProperties);
        SiteIndexFileTest.assertFalse((boolean)locationProperties.exists());
    }

    public void testSimpleIndexV1() throws Exception {
        File indexFile = TestData.getFile("metadataRepo/indexfiles", "simpleIndexV1.p2");
        FileInputStream inputStream = new FileInputStream(indexFile);
        LocationProperties locationProperties = LocationProperties.create((InputStream)inputStream);
        SiteIndexFileTest.assertNotNull((String)"1.0", (Object)locationProperties);
        SiteIndexFileTest.assertEquals((String)"1.1", (Object)Version.createOSGi((int)1, (int)0, (int)0), (Object)locationProperties.getVersion());
        SiteIndexFileTest.assertEquals((String)"1.2", (int)0, (int)locationProperties.getMetadataFactorySearchOrder().length);
    }

    public void testSimpleIndex2V1() throws Exception {
        File indexFile = TestData.getFile("metadataRepo/indexfiles", "simpleIndex2_V1.p2");
        FileInputStream inputStream = new FileInputStream(indexFile);
        LocationProperties locationProperties = LocationProperties.create((InputStream)inputStream);
        SiteIndexFileTest.assertNotNull((String)"1.0", (Object)locationProperties);
        SiteIndexFileTest.assertEquals((String)"1.1", (Object)Version.createOSGi((int)1, (int)0, (int)0), (Object)locationProperties.getVersion());
        SiteIndexFileTest.assertEquals((String)"1.2", (int)0, (int)locationProperties.getMetadataFactorySearchOrder().length);
    }

    public void testSimpleIndex3V1() throws Exception {
        File indexFile = TestData.getFile("metadataRepo/indexfiles", "simpleIndex3_V1.p2");
        FileInputStream inputStream = new FileInputStream(indexFile);
        LocationProperties locationProperties = LocationProperties.create((InputStream)inputStream);
        SiteIndexFileTest.assertNotNull((String)"1.0", (Object)locationProperties);
        SiteIndexFileTest.assertEquals((String)"1.1", (Object)Version.createOSGi((int)1, (int)0, (int)0), (Object)locationProperties.getVersion());
        SiteIndexFileTest.assertEquals((String)"1.2", (int)3, (int)locationProperties.getMetadataFactorySearchOrder().length);
        SiteIndexFileTest.assertEquals((String)"1.4", (int)3, (int)locationProperties.getArtifactFactorySearchOrder().length);
        this.assertArrayOrder(new String[]{"bar", "foo", "!"}, locationProperties.getMetadataFactorySearchOrder());
        this.assertArrayOrder(new String[]{"foo", "bar", "!"}, locationProperties.getArtifactFactorySearchOrder());
    }

    public void testSingleRepository1() throws Exception {
        URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "test1").toURI();
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            IMetadataRepository repository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((boolean)(repository instanceof UpdateSiteMetadataRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testSingleRepositoryWithQueryParams() throws Exception {
        URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "test1").toURI();
        URI repositoryLocationWithParams = new URI(String.valueOf(repositoryLocation.toString()) + "?parameter=foo");
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            IMetadataRepository repository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocationWithParams, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((boolean)(repository instanceof UpdateSiteMetadataRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testSingleRepository2() throws Exception {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "test2").toURI();
            IMetadataRepository repository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((boolean)(repository instanceof LocalMetadataRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testBadIndexFileInRepository() throws Exception {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "badtest1").toURI();
            IMetadataRepository repository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((repository instanceof LocalMetadataRepository || repository instanceof UpdateSiteMetadataRepository ? 1 : 0) != 0);
        }
        finally {
            System.setOut(out);
        }
    }

    public void testMultiRepository1() throws Exception {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "test3").toURI();
            IMetadataRepository repository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((boolean)(repository instanceof UpdateSiteMetadataRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testMultiRepository2() throws Exception {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "test4").toURI();
            IMetadataRepository repository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((boolean)(repository instanceof UpdateSiteMetadataRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testDuplicateEntries() throws Exception {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "test5").toURI();
            IMetadataRepository repository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((boolean)(repository instanceof UpdateSiteMetadataRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testStop1() throws Exception {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "stop1").toURI();
            IMetadataRepository repository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((boolean)(repository instanceof UpdateSiteMetadataRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testStop2() throws Exception {
        URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "stop2").toURI();
        try {
            SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException provisionException) {
            return;
        }
        SiteIndexFileTest.fail((String)"We should have not been able to load the repository.");
    }

    public void testCompositeRepo() throws Exception {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "compositeRepo").toURI();
            IMetadataRepository repository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((String)"1.0", (boolean)(repository instanceof CompositeMetadataRepository));
            CompositeMetadataRepository compositeMetadataRepository = (CompositeMetadataRepository)repository;
            SiteIndexFileTest.assertEquals((String)"1.1", (int)2, (int)compositeMetadataRepository.getChildren().size());
            IMetadataRepository child1 = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository((URI)compositeMetadataRepository.getChildren().get(0), (IProgressMonitor)new NullProgressMonitor());
            IMetadataRepository child2 = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository((URI)compositeMetadataRepository.getChildren().get(1), (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((String)"1.2", (boolean)(child1 instanceof UpdateSiteMetadataRepository));
            SiteIndexFileTest.assertTrue((String)"1.2", (boolean)(child2 instanceof LocalMetadataRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testSimpleArtifact() throws Exception {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "artifactTest1").toURI();
            IArtifactRepository repository = SiteIndexFileTest.getArtifactRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((boolean)(repository instanceof SimpleArtifactRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    public void testSimpleArtifact2() throws Exception {
        URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "artifactTest2").toURI();
        try {
            SiteIndexFileTest.getArtifactRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException provisionException) {
            return;
        }
        SiteIndexFileTest.fail((String)"We should have not been able to load the repository.");
    }

    public void testFullRepository() throws Exception {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            URI repositoryLocation = TestData.getFile("metadataRepo/multipleRepos", "fullRepository").toURI();
            IMetadataRepository metadataRepository = SiteIndexFileTest.getMetadataRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            IArtifactRepository artifactRepository = SiteIndexFileTest.getArtifactRepositoryManager().loadRepository(repositoryLocation, (IProgressMonitor)new NullProgressMonitor());
            SiteIndexFileTest.assertTrue((boolean)(metadataRepository instanceof UpdateSiteMetadataRepository));
            SiteIndexFileTest.assertTrue((boolean)(artifactRepository instanceof SimpleArtifactRepository));
        }
        finally {
            System.setOut(out);
        }
    }

    class VisibleMetadataRepositoryManager
    extends MetadataRepositoryManager {
        public VisibleMetadataRepositoryManager() {
            super((IProvisioningAgent)ServiceHelper.getService((BundleContext)TestActivator.getContext(), (String)IProvisioningAgent.SERVICE_NAME));
        }

        public String[] sortSuffixes(String[] suffixes, URI location, String[] preferredOrder) {
            return super.sortSuffixes(suffixes, location, preferredOrder);
        }
    }
}

