/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.mirror;

import java.io.File;
import java.io.PrintStream;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.MirrorApplication;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.StringBufferStream;

public class MetadataRepositoryCleanupTest
extends AbstractProvisioningTest {
    protected File destRepoLocation;
    protected File sourceRepoLocation;
    protected File bystanderRepoLocation;

    protected void setUp() throws Exception {
        super.setUp();
        this.sourceRepoLocation = MetadataRepositoryCleanupTest.getTestData("1.0", "/testData/mirror/mirrorSourceRepo1 with space");
        this.bystanderRepoLocation = MetadataRepositoryCleanupTest.getTestData("2.0", "/testData/mirror/mirrorSourceRepo2");
        String tempDir = System.getProperty("java.io.tmpdir");
        this.destRepoLocation = new File(tempDir, "BasicMirrorApplicationTest");
        AbstractProvisioningTest.delete(this.destRepoLocation);
    }

    protected void tearDown() throws Exception {
        MetadataRepositoryCleanupTest.getMetadataRepositoryManager().removeRepository(this.destRepoLocation.toURI());
        MetadataRepositoryCleanupTest.getMetadataRepositoryManager().removeRepository(this.sourceRepoLocation.toURI());
        MetadataRepositoryCleanupTest.getMetadataRepositoryManager().removeRepository(this.bystanderRepoLocation.toURI());
        MetadataRepositoryCleanupTest.delete(this.destRepoLocation);
        super.tearDown();
    }

    private void runMirrorApplication(File source, File destination, boolean append) throws Exception {
        MirrorApplication application = new MirrorApplication();
        String[] args = new String[]{"-source", source.toURL().toExternalForm(), "-destination", destination.toURL().toExternalForm(), append ? "-append" : ""};
        application.initializeFromArguments(args);
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            application.run(null);
        }
        finally {
            System.setOut(out);
        }
    }

    public void testMetadataMirrorRemovesRepos() {
        try {
            this.runMirrorApplication(this.sourceRepoLocation, this.destRepoLocation, true);
        }
        catch (Exception e) {
            MetadataRepositoryCleanupTest.fail("1.0", e);
        }
        MetadataRepositoryCleanupTest.assertFalse((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.sourceRepoLocation.toURI()));
        MetadataRepositoryCleanupTest.assertFalse((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.destRepoLocation.toURI()));
    }

    public void testMetadataMirrorRemovesReposWithSourceLoaded() {
        try {
            MetadataRepositoryCleanupTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            MetadataRepositoryCleanupTest.fail("2.0", e);
        }
        try {
            this.runMirrorApplication(this.sourceRepoLocation, this.destRepoLocation, true);
        }
        catch (Exception e) {
            MetadataRepositoryCleanupTest.fail("2.2", e);
        }
        MetadataRepositoryCleanupTest.assertTrue((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.sourceRepoLocation.toURI()));
        MetadataRepositoryCleanupTest.assertFalse((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.destRepoLocation.toURI()));
    }

    public void testMetadataMirrorRemovesReposWithDestinationLoaded() {
        try {
            String repositoryName = this.destRepoLocation.toURI() + " - metadata";
            MetadataRepositoryCleanupTest.getMetadataRepositoryManager().createRepository(this.destRepoLocation.toURI(), repositoryName, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
        }
        catch (ProvisionException e) {
            MetadataRepositoryCleanupTest.fail("3.0", e);
        }
        try {
            this.runMirrorApplication(this.sourceRepoLocation, this.destRepoLocation, true);
        }
        catch (Exception e) {
            MetadataRepositoryCleanupTest.fail("3.2", e);
        }
        MetadataRepositoryCleanupTest.assertTrue((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.destRepoLocation.toURI()));
        MetadataRepositoryCleanupTest.assertFalse((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.sourceRepoLocation.toURI()));
    }

    public void testMetadataMirrorRemovesReposWithBothLoaded() {
        try {
            String repositoryName = this.destRepoLocation.toURI() + " - metadata";
            MetadataRepositoryCleanupTest.getMetadataRepositoryManager().createRepository(this.destRepoLocation.toURI(), repositoryName, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
            MetadataRepositoryCleanupTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            MetadataRepositoryCleanupTest.fail("4.0", e);
        }
        try {
            this.runMirrorApplication(this.sourceRepoLocation, this.destRepoLocation, true);
        }
        catch (Exception e) {
            MetadataRepositoryCleanupTest.fail("4.2", e);
        }
        MetadataRepositoryCleanupTest.assertTrue((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.destRepoLocation.toURI()));
        MetadataRepositoryCleanupTest.assertTrue((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.sourceRepoLocation.toURI()));
    }

    public void testMetadataMirrorRemovesReposWithBystanderLoaded() {
        try {
            MetadataRepositoryCleanupTest.getMetadataRepositoryManager().loadRepository(this.bystanderRepoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            MetadataRepositoryCleanupTest.fail("5.0", e);
        }
        try {
            this.runMirrorApplication(this.sourceRepoLocation, this.destRepoLocation, true);
        }
        catch (Exception e) {
            MetadataRepositoryCleanupTest.fail("5.2", e);
        }
        MetadataRepositoryCleanupTest.assertFalse((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.sourceRepoLocation.toURI()));
        MetadataRepositoryCleanupTest.assertFalse((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.destRepoLocation.toURI()));
        MetadataRepositoryCleanupTest.assertTrue((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.bystanderRepoLocation.toURI()));
    }

    public void testMetadataMirrorRemovesReposWithSourceAndBystanderLoaded() {
        try {
            MetadataRepositoryCleanupTest.getMetadataRepositoryManager().loadRepository(this.bystanderRepoLocation.toURI(), null);
            MetadataRepositoryCleanupTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            MetadataRepositoryCleanupTest.fail("6.0", e);
        }
        try {
            this.runMirrorApplication(this.sourceRepoLocation, this.destRepoLocation, true);
        }
        catch (Exception e) {
            MetadataRepositoryCleanupTest.fail("6.2", e);
        }
        MetadataRepositoryCleanupTest.assertTrue((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.sourceRepoLocation.toURI()));
        MetadataRepositoryCleanupTest.assertFalse((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.destRepoLocation.toURI()));
        MetadataRepositoryCleanupTest.assertTrue((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.bystanderRepoLocation.toURI()));
    }

    public void testMetadataMirrorRemovesReposWithDestinationAndBystanderLoaded() {
        try {
            MetadataRepositoryCleanupTest.getMetadataRepositoryManager().loadRepository(this.bystanderRepoLocation.toURI(), null);
            String repositoryName = this.destRepoLocation.toURI() + " - metadata";
            MetadataRepositoryCleanupTest.getMetadataRepositoryManager().createRepository(this.destRepoLocation.toURI(), repositoryName, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
        }
        catch (ProvisionException e) {
            MetadataRepositoryCleanupTest.fail("7.0", e);
        }
        try {
            this.runMirrorApplication(this.sourceRepoLocation, this.destRepoLocation, true);
        }
        catch (Exception e) {
            MetadataRepositoryCleanupTest.fail("7.2", e);
        }
        MetadataRepositoryCleanupTest.assertTrue((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.destRepoLocation.toURI()));
        MetadataRepositoryCleanupTest.assertFalse((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.sourceRepoLocation.toURI()));
        MetadataRepositoryCleanupTest.assertTrue((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.bystanderRepoLocation.toURI()));
    }

    public void testMetadataMirrorRemovesReposWithBothAndBystanderLoaded() {
        try {
            MetadataRepositoryCleanupTest.getMetadataRepositoryManager().loadRepository(this.bystanderRepoLocation.toURI(), null);
            String repositoryName = this.destRepoLocation.toURI() + " - metadata";
            MetadataRepositoryCleanupTest.getMetadataRepositoryManager().createRepository(this.destRepoLocation.toURI(), repositoryName, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
            MetadataRepositoryCleanupTest.getMetadataRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            MetadataRepositoryCleanupTest.fail("8.0", e);
        }
        try {
            this.runMirrorApplication(this.sourceRepoLocation, this.destRepoLocation, true);
        }
        catch (Exception e) {
            MetadataRepositoryCleanupTest.fail("8.2", e);
        }
        MetadataRepositoryCleanupTest.assertTrue((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.destRepoLocation.toURI()));
        MetadataRepositoryCleanupTest.assertTrue((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.sourceRepoLocation.toURI()));
        MetadataRepositoryCleanupTest.assertTrue((boolean)MetadataRepositoryCleanupTest.getMetadataRepositoryManager().contains(this.bystanderRepoLocation.toURI()));
    }
}

