/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.mirror;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.processors.md5.Messages;
import org.eclipse.equinox.internal.p2.artifact.repository.Activator;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRepositoryManager;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.MirrorApplication;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.ArtifactDescriptorQuery;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.StringBufferStream;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class NewMirrorApplicationArtifactTest
extends AbstractProvisioningTest {
    private static final String MISSING_ARTIFACT = "canonical: osgi.bundle,javax.wsdl,1.4.0.v200803061811.";
    protected File destRepoLocation;
    protected File sourceRepoLocation;
    protected File sourceRepo2Location;
    protected File sourceRepo3Location;
    protected File sourceRepo4Location;

    protected void setUp() throws Exception {
        super.setUp();
        this.sourceRepoLocation = NewMirrorApplicationArtifactTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo1 with space");
        this.sourceRepo2Location = NewMirrorApplicationArtifactTest.getTestData("0.1", "/testData/mirror/mirrorSourceRepo2");
        this.sourceRepo3Location = NewMirrorApplicationArtifactTest.getTestData("0.2", "/testData/mirror/mirrorSourceRepo3");
        this.sourceRepo4Location = NewMirrorApplicationArtifactTest.getTestData("0.3", "/testData/mirror/mirrorSourceRepo4");
        this.destRepoLocation = new File(this.getTempFolder(), "BasicMirrorApplicationTest");
        NewMirrorApplicationArtifactTest.delete(this.destRepoLocation);
    }

    protected void tearDown() throws Exception {
        NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().removeRepository(this.destRepoLocation.toURI());
        NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().removeRepository(this.sourceRepoLocation.toURI());
        NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().removeRepository(this.sourceRepo2Location.toURI());
        NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().removeRepository(this.sourceRepo3Location.toURI());
        NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().removeRepository(this.sourceRepo4Location.toURI());
        NewMirrorApplicationArtifactTest.delete(this.destRepoLocation);
        super.tearDown();
    }

    private StringBuffer basicRunMirrorApplication(String message, URI source, URI destination, Boolean append, Boolean formatDestination, String destName) throws Exception {
        MirrorApplication app = new MirrorApplication();
        if (destination != null) {
            RepositoryDescriptor dest = null;
            dest = formatDestination != null && formatDestination != false ? this.createRepositoryDescriptor(destination, append, source, destName) : this.createRepositoryDescriptor(destination, append, null, destName);
            app.addDestination(dest);
        }
        if (source != null) {
            RepositoryDescriptor src = this.createRepositoryDescriptor(source, null, null, null);
            app.addSource(src);
        }
        StringBuffer buffer = new StringBuffer();
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream(buffer)));
            app.run(null);
        }
        finally {
            System.setOut(out);
        }
        return buffer;
    }

    private StringBuffer basicRunMirrorApplication(String message, URI source, URI destination, Boolean append, Boolean formatDestination) throws Exception {
        return this.basicRunMirrorApplication(message, source, destination, append, formatDestination, null);
    }

    private StringBuffer basicRunMirrorApplication(String message, URI source, URI destination) throws Exception {
        return this.basicRunMirrorApplication(message, source, destination, null, null, null);
    }

    private RepositoryDescriptor createRepositoryDescriptor(URI location, Boolean append, URI format, String name) {
        RepositoryDescriptor descriptor = new RepositoryDescriptor();
        descriptor.setLocation(location);
        descriptor.setKind("artifact");
        if (append != null) {
            descriptor.setAppend(append.booleanValue());
        }
        if (format != null) {
            descriptor.setFormat(format);
        }
        if (name != null) {
            descriptor.setName(name);
        }
        return descriptor;
    }

    private void runMirrorApplication(String message, File source, File destination, boolean append) {
        try {
            this.basicRunMirrorApplication(message, source.toURI(), destination.toURI(), append, false);
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail(message, e);
        }
    }

    private void artifactMirrorToEmpty(String message, boolean append, boolean format) {
        try {
            this.basicRunMirrorApplication(message, this.sourceRepoLocation.toURI(), this.destRepoLocation.toURI(), append, format);
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail(message, e);
        }
    }

    private void artifactMirrorToPopulated(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepo2Location, this.destRepoLocation, false);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals(String.valueOf(message) + ".1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepoLocation, this.destRepoLocation, append);
    }

    private void artifactMirrorToFullDuplicate(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepoLocation, this.destRepoLocation, false);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals(String.valueOf(message) + ".1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepoLocation, this.destRepoLocation, append);
    }

    private void artifactMirrorToPartialDuplicate(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepoLocation, this.destRepoLocation, false);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals(String.valueOf(message) + ".1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepo3Location, this.destRepoLocation, append);
    }

    private void artifactMirrorToPopulatedWithFullDuplicate(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepo3Location, this.destRepoLocation, false);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals(String.valueOf(message) + ".1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepoLocation, this.destRepoLocation, append);
    }

    private void artifactMirrorToPopulatedWithPartialDuplicate(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepo2Location, this.destRepoLocation, false);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals(String.valueOf(message) + ".1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail(String.valueOf(message) + ".2", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".4", this.sourceRepoLocation, this.destRepoLocation, true);
        try {
            NewMirrorApplicationArtifactTest.assertContains(String.valueOf(message) + ".5", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationArtifactTest.assertContains(String.valueOf(message) + ".6", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail(String.valueOf(message) + ".7", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".9", this.sourceRepo3Location, this.destRepoLocation, append);
    }

    private File artifactMirrorEmpty(String message, boolean append) {
        File emptyRepository = new File(this.getTempFolder(), NewMirrorApplicationArtifactTest.getUniqueString());
        NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().removeRepository(emptyRepository.toURI());
        NewMirrorApplicationArtifactTest.delete(emptyRepository);
        try {
            NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().createRepository(emptyRepository.toURI(), "Empty Repository", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail(String.valueOf(message) + ".1", e);
        }
        this.runMirrorApplication(String.valueOf(message) + ".0", emptyRepository, this.destRepoLocation, append);
        return emptyRepository;
    }

    private File artifactMirrorEmptyToPopulated(String message, boolean append) {
        this.runMirrorApplication(String.valueOf(message) + ".0", this.sourceRepoLocation, this.destRepoLocation, false);
        return this.artifactMirrorEmpty(String.valueOf(message) + ".1", append);
    }

    private void mirrorWithError(boolean verbose) {
        File errorSourceLocation = NewMirrorApplicationArtifactTest.getTestData("loading error data", "testData/artifactRepo/missingSingleArtifact");
        File validSourceLocation = NewMirrorApplicationArtifactTest.getTestData("loading error data", "testData/artifactRepo/simple");
        PrintStream out = System.out;
        try {
            try {
                System.setOut(new PrintStream(new StringBufferStream()));
                MirrorApplication app = new MirrorApplication();
                app.addSource(this.createRepositoryDescriptor(errorSourceLocation.toURI(), null, null, null));
                app.addSource(this.createRepositoryDescriptor(validSourceLocation.toURI(), null, null, null));
                app.addDestination(this.createRepositoryDescriptor(this.destRepoLocation.toURI(), null, null, null));
                app.setVerbose(verbose);
                app.setIgnoreErrors(true);
                app.run(null);
            }
            catch (Exception e) {
                NewMirrorApplicationArtifactTest.fail("Running mirror application with errored source failed", e);
                System.setOut(out);
            }
        }
        finally {
            System.setOut(out);
        }
    }

    public void testArtifactMirrorToEmpty() {
        this.artifactMirrorToEmpty("1.0", true, false);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals("1.1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("1.2", e);
        }
    }

    public void testArtifactMirrorToEmptyWithClean() {
        this.artifactMirrorToEmpty("2.0", false, false);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals("2.1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("2.2", e);
        }
    }

    public void testArtifactMirrorToFullDuplicate() {
        this.artifactMirrorToFullDuplicate("3.0", true);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals("3.1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("3.2", e);
        }
    }

    public void testArtifactMirrorToFullDuplicateWithClean() {
        this.artifactMirrorToFullDuplicate("4.0", false);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals("4.1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("4.2", e);
        }
    }

    public void testArtifactMirrorToPopulated() {
        this.artifactMirrorToPopulated("5.0", true);
        try {
            NewMirrorApplicationArtifactTest.assertContains("5.1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationArtifactTest.assertContains("5.2", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationArtifactTest.assertEquals((String)"5.3", (int)(this.getArtifactKeyCount(this.sourceRepoLocation.toURI()) + this.getArtifactKeyCount(this.sourceRepo2Location.toURI())), (int)this.getArtifactKeyCount(this.destRepoLocation.toURI()));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("5.4", e);
        }
    }

    public void testArtifactMirrorToPopulatedWithClean() {
        this.artifactMirrorToPopulated("6.0", false);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals("6.1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("6.2", e);
        }
    }

    public void testArtifactMirrorToPartialDuplicate() {
        this.artifactMirrorToPartialDuplicate("7.0", true);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals("7.1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("7.2", e);
        }
    }

    public void testArtifactMirrorToPartialDuplicateWithClean() {
        this.artifactMirrorToPartialDuplicate("8.0", false);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals("8.1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("8.2", e);
        }
    }

    public void testArtifactMirrorToPopulatedWithFullDuplicate() {
        this.artifactMirrorToPopulatedWithFullDuplicate("9.0", true);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals("9.1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("9.2", e);
        }
    }

    public void testArtifactMirrorToPopulatedWithFullDuplicateWithClean() {
        this.artifactMirrorToPopulatedWithFullDuplicate("10.0", false);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals("10.1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("10.2", e);
        }
    }

    public void testArtifactMirrorToPopulatedWithPartialDuplicate() {
        this.artifactMirrorToPopulatedWithPartialDuplicate("11.0", true);
        try {
            NewMirrorApplicationArtifactTest.assertContains("11.1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationArtifactTest.assertContains("11.2", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationArtifactTest.assertEquals((String)"11.3", (int)(this.getArtifactKeyCount(this.sourceRepo2Location.toURI()) + this.getArtifactKeyCount(this.sourceRepo3Location.toURI())), (int)this.getArtifactKeyCount(this.destRepoLocation.toURI()));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("11.4", e);
        }
    }

    public void testArtifactMirrorToPopulatedWithPartialDuplicateWithClean() {
        this.artifactMirrorToPopulatedWithPartialDuplicate("12.0", false);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals("12.1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo3Location.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("12.2", e);
        }
    }

    public void testArtifactMirrorFromInvalid() {
        File invalidRepository = new File(this.getTempFolder(), NewMirrorApplicationArtifactTest.getUniqueString());
        NewMirrorApplicationArtifactTest.delete(invalidRepository);
        try {
            this.basicRunMirrorApplication("13.1", invalidRepository.toURI(), this.destRepoLocation.toURI(), true, false);
            NewMirrorApplicationArtifactTest.fail((String)"13.0 ProvisionExpection not thrown");
        }
        catch (ProvisionException provisionException) {
            return;
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail("13.2", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testArtifactMirrorToInvalid() {
        URI invalidDestRepository = null;
        try {
            try {
                invalidDestRepository = new URI("http://eclipse.org/equinox/foobar/abcdefg");
                this.basicRunMirrorApplication("14.1", this.sourceRepoLocation.toURI(), invalidDestRepository, true, false);
                NewMirrorApplicationArtifactTest.fail((String)"14.0 UnsupportedOperationException not thrown");
                return;
            }
            catch (ProvisionException e) {
                NewMirrorApplicationArtifactTest.assertEquals((String)"Unexpected error message", (String)NLS.bind((String)org.eclipse.equinox.p2.internal.repository.tools.Messages.exception_invalidDestination, (Object)URIUtil.toUnencodedString((URI)invalidDestRepository)), (String)e.getMessage());
                if (invalidDestRepository == null) return;
                NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().removeRepository(invalidDestRepository);
                return;
            }
            catch (Exception e) {
                NewMirrorApplicationArtifactTest.fail("14.2", e);
                if (invalidDestRepository == null) return;
                NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().removeRepository(invalidDestRepository);
                return;
            }
        }
        finally {
            if (invalidDestRepository != null) {
                NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().removeRepository(invalidDestRepository);
            }
        }
    }

    public void testArtifactMirrorBothInvalid() {
        File invalidRepository = new File(this.getTempFolder(), NewMirrorApplicationArtifactTest.getUniqueString());
        NewMirrorApplicationArtifactTest.delete(invalidRepository);
        try {
            URI invalidDestRepository = new URI("http://eclipse.org/equinox/foobar/abcdefg");
            this.basicRunMirrorApplication("15.1", invalidRepository.toURI(), invalidDestRepository, true, false);
            NewMirrorApplicationArtifactTest.fail((String)"15.0 ProvisionException not thrown");
        }
        catch (ProvisionException provisionException) {
            return;
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail("15.2", e);
        }
    }

    public void testArtifactMirrorEmptyToEmpty() {
        File emptyRepository = this.artifactMirrorEmpty("16.0", true);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals("16.1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(emptyRepository.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("16.2", e);
        }
        NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().removeRepository(emptyRepository.toURI());
        NewMirrorApplicationArtifactTest.delete(emptyRepository);
    }

    public void testArtifactMirrorEmptyToPopulated() {
        File emptyRepository = this.artifactMirrorEmptyToPopulated("17.0", true);
        try {
            NewMirrorApplicationArtifactTest.assertContains("17.1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(emptyRepository.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationArtifactTest.assertContentEquals("17.2", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("17.3", e);
        }
        NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().removeRepository(emptyRepository.toURI());
        NewMirrorApplicationArtifactTest.delete(emptyRepository);
    }

    public void testArtifactMirrorEmptyToPopulatedWithClean() {
        File emptyRepository = this.artifactMirrorEmptyToPopulated("18.0", false);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals("18.1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(emptyRepository.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("18.2", e);
        }
        NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().removeRepository(emptyRepository.toURI());
        NewMirrorApplicationArtifactTest.delete(emptyRepository);
    }

    public void testArtifactMirrorSourceIsDestination() {
        this.runMirrorApplication("19.0", this.sourceRepoLocation, this.destRepoLocation, false);
        this.runMirrorApplication("19.1", this.destRepoLocation, this.destRepoLocation, true);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals("19.2", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("19.3", e);
        }
    }

    public void testArtifactMirrorDifferentVersions() {
        this.runMirrorApplication("20.0", this.sourceRepoLocation, this.destRepoLocation, false);
        this.runMirrorApplication("20.1", this.sourceRepo4Location, this.destRepoLocation, true);
        try {
            NewMirrorApplicationArtifactTest.assertContains("20.2", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationArtifactTest.assertContains("20.3", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo4Location.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationArtifactTest.assertEquals((String)"20.4", (int)(this.getArtifactKeyCount(this.sourceRepoLocation.toURI()) + this.getArtifactKeyCount(this.sourceRepo4Location.toURI())), (int)this.getArtifactKeyCount(this.destRepoLocation.toURI()));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("20.5", e);
        }
    }

    public void testArtifactMirrorNullSource() {
        try {
            this.basicRunMirrorApplication("21.1", null, this.destRepoLocation.toURI());
            NewMirrorApplicationArtifactTest.fail((String)"21.3 ProvisionException not thrown");
        }
        catch (ProvisionException provisionException) {
            return;
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail("21.2", e);
        }
    }

    public void testArtifactMirrorNullDestination() {
        try {
            this.basicRunMirrorApplication("22.1", this.sourceRepoLocation.toURI(), null);
            NewMirrorApplicationArtifactTest.fail((String)"22.3 ProvisionException not thrown");
        }
        catch (ProvisionException provisionException) {
            return;
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail("22.2", e);
        }
    }

    public void testArtifactMirrorNullBoth() {
        try {
            this.basicRunMirrorApplication("23.0", null, null);
            NewMirrorApplicationArtifactTest.fail((String)"23.2 ProvisionException not thrown");
        }
        catch (ProvisionException provisionException) {
            return;
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail("23.1", e);
        }
    }

    public void testNewArtifactRepoProperties() {
        this.artifactMirrorToEmpty("24.0", true, true);
        try {
            IArtifactRepository sourceRepository = NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null);
            IArtifactRepository destinationRepository = NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null);
            NewMirrorApplicationArtifactTest.assertEquals((String)"24.1", (String)sourceRepository.getName(), (String)destinationRepository.getName());
            NewMirrorApplicationArtifactTest.assertRepositoryProperties("24.2", sourceRepository.getProperties(), destinationRepository.getProperties());
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("24.3", e);
        }
    }

    public void testExistingArtifactRepoProperties() {
        String name = "Destination Name";
        Map properties = null;
        try {
            properties = NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().createRepository(this.destRepoLocation.toURI(), name, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties).getProperties();
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("25.0", e);
        }
        this.artifactMirrorToEmpty("25.2", true, false);
        try {
            IArtifactRepository repository = NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null);
            NewMirrorApplicationArtifactTest.assertEquals((String)"25.3", (String)name, (String)repository.getName());
            NewMirrorApplicationArtifactTest.assertRepositoryProperties("25.4", properties, repository.getProperties());
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("25.5", e);
        }
    }

    public void testNewArtifactRepoWithNewName() {
        String name = "Bug 256909 test - new";
        try {
            this.basicRunMirrorApplication("Bug 256909 Test", this.sourceRepoLocation.toURI(), this.destRepoLocation.toURI(), true, false, name);
        }
        catch (MalformedURLException e) {
            NewMirrorApplicationArtifactTest.fail("Error creating URLs for Source/Detination", e);
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail("Error running mirror application", e);
        }
        try {
            NewMirrorApplicationArtifactTest.assertEquals((String)"Assert name was set correct", (String)name, (String)NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null).getName());
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("Cannot obtain destination", e);
        }
    }

    public void testExistingArtifactRepoWithNewName() {
        String newName;
        block9: {
            String oldName = "The original naem for Bug 256909 test - existing";
            newName = "Bug 256909 test - existing";
            IArtifactRepository destinationRepo = null;
            try {
                destinationRepo = NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().createRepository(this.destRepoLocation.toURI(), oldName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            }
            catch (ProvisionException e) {
                NewMirrorApplicationArtifactTest.fail("Error creating repo at destination", e);
            }
            NewMirrorApplicationArtifactTest.assertEquals((String)"Assert name is set correctly before mirror", (String)oldName, (String)destinationRepo.getName());
            StringBuffer buffer = new StringBuffer();
            PrintStream out = System.out;
            try {
                try {
                    System.setOut(new PrintStream(new StringBufferStream(buffer)));
                    MirrorApplication app = new MirrorApplication();
                    app.addSource(this.createRepositoryDescriptor(this.sourceRepoLocation.toURI(), null, null, null));
                    app.addDestination(this.createRepositoryDescriptor(this.destRepoLocation.toURI(), null, null, newName));
                    app.run(null);
                }
                catch (Exception e) {
                    NewMirrorApplicationArtifactTest.fail("Error running mirror application", e);
                    System.setOut(out);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                System.setOut(out);
                throw throwable;
            }
            System.setOut(out);
        }
        try {
            NewMirrorApplicationArtifactTest.assertEquals((String)"Assert name is set correctly after mirror", (String)newName, (String)NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null).getName());
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("Error loading destination", e);
        }
    }

    public void testArtifactFileCopying() {
        File packedRepoLocation = NewMirrorApplicationArtifactTest.getTestData("26.0", "/testData/mirror/mirrorPackedRepo");
        try {
            this.basicRunMirrorApplication("26.1", packedRepoLocation.toURI(), this.destRepoLocation.toURI(), false, false);
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail("26.3", e);
        }
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals("26.4", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(packedRepoLocation.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            this.assertEqualArtifacts("26.5", (SimpleArtifactRepository)NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(packedRepoLocation.toURI(), null), (SimpleArtifactRepository)NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("26.6", e);
        }
    }

    public void testArtifactProcessingSteps() {
        File packedRepoLocation = NewMirrorApplicationArtifactTest.getTestData("27.0", "/testData/mirror/mirrorPackedRepo");
        IArtifactRepository packedRepo = null;
        IArtifactRepository destinationRepo = null;
        try {
            packedRepo = NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(packedRepoLocation.toURI(), null);
            destinationRepo = NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().createRepository(this.destRepoLocation.toURI(), "Test Repo", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
        }
        catch (ProvisionException provisionException) {
            NewMirrorApplicationArtifactTest.fail((String)"");
        }
        IQueryResult keys = packedRepo.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
        for (IArtifactKey key : keys) {
            IArtifactDescriptor[] srcDescriptors = packedRepo.getArtifactDescriptors(key);
            int j = 0;
            while (j < srcDescriptors.length) {
                if (srcDescriptors[j].getProperty("format") != null && srcDescriptors[j].getProperty("format").equals("packed")) {
                    ArtifactDescriptor newDescriptor = new ArtifactDescriptor(key);
                    OrderedProperties properties = new OrderedProperties();
                    properties.putAll(srcDescriptors[j].getProperties());
                    properties.remove("format");
                    newDescriptor.addProperties((Map)properties);
                    try {
                        OutputStream repositoryStream = null;
                        try {
                            repositoryStream = destinationRepo.getOutputStream((IArtifactDescriptor)newDescriptor);
                            if (repositoryStream == null) {
                                return;
                            }
                            packedRepo.getArtifact(srcDescriptors[j], repositoryStream, (IProgressMonitor)new NullProgressMonitor());
                        }
                        finally {
                            if (repositoryStream != null) {
                                repositoryStream.close();
                            }
                        }
                    }
                    catch (ProvisionException e) {
                        NewMirrorApplicationArtifactTest.fail("27.1", e);
                    }
                    catch (IOException e) {
                        NewMirrorApplicationArtifactTest.fail("27.2", e);
                    }
                    IArtifactDescriptor[] destDescriptors = destinationRepo.getArtifactDescriptors(key);
                    boolean canonicalFound = false;
                    int l = 0;
                    while (!canonicalFound && l < destDescriptors.length) {
                        if (destDescriptors[l].getProcessingSteps().length == 0) {
                            canonicalFound = true;
                        }
                        ++l;
                    }
                    if (!canonicalFound) {
                        NewMirrorApplicationArtifactTest.fail((String)("27.3 no canonical found for " + key.toString()));
                    }
                    this.assertEqualArtifacts("27.3", (SimpleArtifactRepository)destinationRepo, (SimpleArtifactRepository)packedRepo);
                }
                ++j;
            }
        }
    }

    public void testMirrorCompressedSource() {
        File compressedSource = NewMirrorApplicationArtifactTest.getTestData("0", "/testData/mirror/mirrorCompressedRepo");
        File compressedArtifactsXML = new File(compressedSource.getAbsoluteFile() + "/artifacts.jar");
        NewMirrorApplicationArtifactTest.assertTrue((String)"1", (boolean)compressedArtifactsXML.exists());
        try {
            this.basicRunMirrorApplication("2", compressedSource.toURI(), this.destRepoLocation.toURI(), false, false);
        }
        catch (MalformedURLException e) {
            NewMirrorApplicationArtifactTest.fail("3", e);
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail("4", e);
        }
        File destArtifactsXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/artifacts.jar");
        NewMirrorApplicationArtifactTest.assertTrue((String)"5", (boolean)destArtifactsXML.exists());
    }

    public void testMirrorCompressedSourcetoUncompressedDestination() {
        File compressedSource = NewMirrorApplicationArtifactTest.getTestData("0", "/testData/mirror/mirrorCompressedRepo");
        File compressedArtifactsXML = new File(compressedSource.getAbsoluteFile() + "/artifacts.jar");
        NewMirrorApplicationArtifactTest.assertTrue((String)"1", (boolean)compressedArtifactsXML.exists());
        try {
            String name = "Destination Name " + this.destRepoLocation;
            NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().createRepository(this.destRepoLocation.toURI(), name, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("2", e);
        }
        NewMirrorApplicationArtifactTest.assertTrue((String)"2.1", (boolean)new File(this.destRepoLocation, "artifacts.xml").exists());
        try {
            this.basicRunMirrorApplication("3", compressedSource.toURI(), this.destRepoLocation.toURI(), false, false);
        }
        catch (MalformedURLException e) {
            NewMirrorApplicationArtifactTest.fail("4", e);
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail("5", e);
        }
        File destArtifactsXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/artifacts.jar");
        NewMirrorApplicationArtifactTest.assertFalse((String)"6", (boolean)destArtifactsXML.exists());
        destArtifactsXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/artifacts.xml");
        NewMirrorApplicationArtifactTest.assertTrue((String)"7", (boolean)destArtifactsXML.exists());
    }

    public void testMirrorUncompressedSourceToCompressedDestination() {
        File uncompressedSource = NewMirrorApplicationArtifactTest.getTestData("0", "/testData/mirror/mirrorPackedRepo");
        File artifactsXML = new File(uncompressedSource.getAbsoluteFile() + "/artifacts.xml");
        NewMirrorApplicationArtifactTest.assertTrue((String)"1", (boolean)artifactsXML.exists());
        try {
            String name = "Destination Name " + this.destRepoLocation;
            HashMap<String, String> property = new HashMap<String, String>();
            property.put("p2.compressed", "true");
            NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().createRepository(this.destRepoLocation.toURI(), name, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", property);
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("2", e);
        }
        NewMirrorApplicationArtifactTest.assertTrue((String)"2.1", (boolean)new File(this.destRepoLocation, "artifacts.jar").exists());
        try {
            this.basicRunMirrorApplication("3", uncompressedSource.toURI(), this.destRepoLocation.toURI(), false, false);
        }
        catch (MalformedURLException e) {
            NewMirrorApplicationArtifactTest.fail("4", e);
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail("5", e);
        }
        File destArtifactsXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/artifacts.jar");
        NewMirrorApplicationArtifactTest.assertTrue((String)"6", (boolean)destArtifactsXML.exists());
        destArtifactsXML = new File(String.valueOf(this.destRepoLocation.getAbsolutePath()) + "/artifacts.xml");
        NewMirrorApplicationArtifactTest.assertFalse((String)"7", (boolean)destArtifactsXML.exists());
    }

    public void testMirrorApplicationWithCompositeSource() {
        File repoLocation = new File(this.getTempFolder(), "CompositeArtifactMirrorTest");
        AbstractProvisioningTest.delete(repoLocation);
        IArtifactRepository repo = null;
        try {
            repo = NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().createRepository(repoLocation.toURI(), "artifact name", "org.eclipse.equinox.p2.artifact.repository.compositeRepository", null);
        }
        catch (ProvisionException provisionException) {
            NewMirrorApplicationArtifactTest.fail((String)"Could not create repository");
        }
        if (!(repo instanceof CompositeArtifactRepository)) {
            NewMirrorApplicationArtifactTest.fail((String)"Repository is not a CompositeArtifactRepository");
        }
        File child1 = NewMirrorApplicationArtifactTest.getTestData("1", "/testData/mirror/mirrorSourceRepo1 with space");
        File child2 = NewMirrorApplicationArtifactTest.getTestData("2", "/testData/mirror/mirrorSourceRepo2");
        ((CompositeArtifactRepository)repo).addChild(child1.toURI());
        ((CompositeArtifactRepository)repo).addChild(child2.toURI());
        this.runMirrorApplication("Mirroring from Composite Source", repoLocation, this.destRepoLocation, false);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals("Verifying contents", repo, NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationArtifactTest.assertContains("3", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationArtifactTest.assertContains("4", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepo2Location.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
            NewMirrorApplicationArtifactTest.assertEquals((String)"5", (int)(this.getArtifactKeyCount(this.sourceRepoLocation.toURI()) + this.getArtifactKeyCount(this.sourceRepo2Location.toURI())), (int)this.getArtifactKeyCount(this.destRepoLocation.toURI()));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("Could not load destination", e);
        }
    }

    public void testIgnoreErrorsArgument() {
        PrintStream oldErr = System.err;
        PrintStream newErr = null;
        try {
            try {
                this.destRepoLocation.mkdir();
                newErr = new PrintStream(new FileOutputStream(new File(this.destRepoLocation, "sys.err")));
            }
            catch (FileNotFoundException e) {
                NewMirrorApplicationArtifactTest.fail("Error redirecting outputs", e);
            }
            System.setErr(newErr);
            this.mirrorWithError(false);
        }
        finally {
            System.setErr(oldErr);
            if (newErr != null) {
                newErr.close();
            }
        }
        NewMirrorApplicationArtifactTest.assertEquals((String)"Verifying correct number of Keys", (int)2, (int)this.getArtifactKeyCount(this.destRepoLocation.toURI()));
    }

    public void testCompareUsingMD5Comparator() {
        ArtifactKey dupKey = PublisherHelper.createBinaryArtifactKey((String)"testKeyId", (Version)Version.create((String)"1.2.3"));
        File artifact1 = NewMirrorApplicationArtifactTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo1 with space/artifacts.xml");
        File artifact2 = NewMirrorApplicationArtifactTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo2/artifacts.xml");
        IArtifactDescriptor descriptor1 = PublisherHelper.createArtifactDescriptor((IArtifactKey)dupKey, (File)artifact1);
        IArtifactDescriptor descriptor2 = PublisherHelper.createArtifactDescriptor((IArtifactKey)dupKey, (File)artifact2);
        NewMirrorApplicationArtifactTest.assertEquals((String)"Ensuring Descriptors are the same", (Object)descriptor1, (Object)descriptor2);
        NewMirrorApplicationArtifactTest.assertNotSame((String)"Ensuring MD5 values are different", (Object)descriptor1.getProperty("download.md5"), (Object)descriptor2.getProperty("download.md5"));
        File repo1Location = this.getTestFolder(NewMirrorApplicationArtifactTest.getUniqueString());
        File repo2Location = this.getTestFolder(NewMirrorApplicationArtifactTest.getUniqueString());
        IArtifactRepository repo1 = null;
        IArtifactRepository repo2 = null;
        try {
            repo1 = NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().createRepository(repo1Location.toURI(), "Repo 1", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            repo1.addDescriptor(descriptor1);
            repo2 = NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().createRepository(repo2Location.toURI(), "Repo 2", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            repo2.addDescriptor(descriptor2);
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("Error creating repositories", e);
        }
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            MirrorApplication app = null;
            try {
                app = new MirrorApplication();
                app.addSource(this.createRepositoryDescriptor(repo1Location.toURI(), null, null, null));
                app.addDestination(this.createRepositoryDescriptor(repo2Location.toURI(), null, null, null));
                app.setVerbose(true);
                app.setCompare(true);
                app.run(null);
            }
            catch (Exception e) {
                NewMirrorApplicationArtifactTest.fail("Running mirror application with duplicate descriptors with different md5 values failed", e);
            }
        }
        finally {
            System.setOut(out);
        }
        IArtifactDescriptor[] destDescriptors = repo2.getArtifactDescriptors(descriptor2.getArtifactKey());
        NewMirrorApplicationArtifactTest.assertEquals((String)"Ensuring destination has correct number of descriptors", (int)1, (int)destDescriptors.length);
        NewMirrorApplicationArtifactTest.assertEquals((String)"Ensuring proper descriptor exists in destination", (String)descriptor2.getProperty("download.md5"), (String)destDescriptors[0].getProperty("download.md5"));
        String msg = NLS.bind((String)Messages.warning_differentMD5, (Object[])new Object[]{URIUtil.toUnencodedString((URI)repo1.getLocation()), URIUtil.toUnencodedString((URI)repo2.getLocation()), descriptor1});
        try {
            NewMirrorApplicationArtifactTest.assertLogContainsLine(TestActivator.getLogFile(), msg);
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail("error verifying output", e);
        }
    }

    public void testBaselineCompareUsingMD5Comparator() {
        IArtifactRepository baseline;
        IArtifactRepository repo;
        IArtifactDescriptor descriptor2;
        IArtifactDescriptor descriptor1;
        block11: {
            ArtifactKey dupKey = PublisherHelper.createBinaryArtifactKey((String)"testKeyId", (Version)Version.create((String)"1.2.3"));
            File artifact1 = NewMirrorApplicationArtifactTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo1 with space/content.xml");
            File artifact2 = NewMirrorApplicationArtifactTest.getTestData("0.0", "/testData/mirror/mirrorSourceRepo2/content.xml");
            File repoLocation = this.getTestFolder(NewMirrorApplicationArtifactTest.getUniqueString());
            File baselineLocation = this.getTestFolder(NewMirrorApplicationArtifactTest.getUniqueString());
            File baselineBinaryDirectory = new File(baselineLocation, "binary");
            baselineBinaryDirectory.mkdir();
            File baselineContentLocation = new File(baselineBinaryDirectory, "testKeyId_1.2.3");
            AbstractProvisioningTest.copy("Copying File to baseline", artifact2, baselineContentLocation);
            descriptor1 = PublisherHelper.createArtifactDescriptor((IArtifactKey)dupKey, (File)artifact1);
            descriptor2 = PublisherHelper.createArtifactDescriptor((IArtifactKey)dupKey, (File)baselineContentLocation);
            NewMirrorApplicationArtifactTest.assertEquals((String)"Ensuring Descriptors are the same", (Object)descriptor1, (Object)descriptor2);
            NewMirrorApplicationArtifactTest.assertNotSame((String)"Ensuring MD5 values are different", (Object)descriptor1.getProperty("download.md5"), (Object)descriptor2.getProperty("download.md5"));
            repo = null;
            baseline = null;
            try {
                repo = NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().createRepository(repoLocation.toURI(), "Repo 1", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
                repo.addDescriptor(descriptor1);
                baseline = NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().createRepository(baselineLocation.toURI(), "Repo 2", "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
                baseline.addDescriptor(descriptor2);
            }
            catch (ProvisionException e) {
                NewMirrorApplicationArtifactTest.fail("Error creating repositories", e);
            }
            MirrorApplication app = null;
            PrintStream out = System.out;
            try {
                try {
                    System.setOut(new PrintStream(new StringBufferStream()));
                    app = new MirrorApplication();
                    app.addSource(this.createRepositoryDescriptor(repoLocation.toURI(), null, null, null));
                    app.addDestination(this.createRepositoryDescriptor(this.destRepoLocation.toURI(), null, null, null));
                    app.setBaseline(baselineLocation.toURI());
                    app.setVerbose(true);
                    app.setCompare(true);
                    app.run(null);
                }
                catch (Exception e) {
                    NewMirrorApplicationArtifactTest.fail("Running mirror application with baseline compare", e);
                    System.setOut(out);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                System.setOut(out);
                throw throwable;
            }
            System.setOut(out);
        }
        IArtifactRepository destination = null;
        try {
            destination = NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("Error loading destination", e);
        }
        IArtifactDescriptor[] destDescriptors = destination.getArtifactDescriptors(descriptor2.getArtifactKey());
        NewMirrorApplicationArtifactTest.assertEquals((String)"Ensuring destination has correct number of descriptors", (int)1, (int)destDescriptors.length);
        NewMirrorApplicationArtifactTest.assertEquals((String)"Ensuring destination contains the descriptor from the baseline", (String)descriptor2.getProperty("download.md5"), (String)destDescriptors[0].getProperty("download.md5"));
        String msg = NLS.bind((String)Messages.warning_differentMD5, (Object[])new Object[]{URIUtil.toUnencodedString((URI)baseline.getLocation()), URIUtil.toUnencodedString((URI)repo.getLocation()), descriptor1});
        try {
            NewMirrorApplicationArtifactTest.assertLogContainsLine(TestActivator.getLogFile(), msg);
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail("error verifying output", e);
        }
    }

    public void testDownloadRetry() {
        File retryRepoLoaction = new File(this.getTempFolder(), "259111 Repo");
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TestRetryArtifactRepository
        extends SimpleArtifactRepository {
            public boolean firstAttempt;
            IArtifactRepository source;

            public TestRetryArtifactRepository(String repositoryName, URI location, URI srcLocation, Map properties, IArtifactRepositoryManager manager) {
                super(NewMirrorApplicationArtifactTest.getAgent(), repositoryName, location, properties);
                this.firstAttempt = true;
                try {
                    this.source = manager.loadRepository(srcLocation, null);
                }
                catch (ProvisionException e) {
                    NewMirrorApplicationArtifactTest.fail("Unable to load source for wrapping", e);
                }
                manager.removeRepository(srcLocation);
            }

            public synchronized Iterator<IArtifactKey> everything() {
                return ((SimpleArtifactRepository)this.source).everything();
            }

            public synchronized IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
                return this.source.getArtifactDescriptors(key);
            }

            public IStatus getRawArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
                if (this.firstAttempt) {
                    this.firstAttempt = false;
                    return new Status(4, "org.eclipse.equinox.p2.artifact.repository", 13, "Forcing Retry", (Throwable)new ProvisionException("Forcing retry"));
                }
                return this.source.getRawArtifact(descriptor, destination, monitor);
            }

            public synchronized boolean contains(IArtifactDescriptor descriptor) {
                return this.source.contains(descriptor);
            }

            public synchronized IQueryResult query(IQuery query, IProgressMonitor monitor) {
                return this.source.query(query, monitor);
            }
        }
        TestRetryArtifactRepository retryRepo = new TestRetryArtifactRepository("Test Repo", retryRepoLoaction.toURI(), this.sourceRepoLocation.toURI(), null, NewMirrorApplicationArtifactTest.getArtifactRepositoryManager());
        ((ArtifactRepositoryManager)NewMirrorApplicationArtifactTest.getArtifactRepositoryManager()).addRepository((IArtifactRepository)retryRepo);
        try {
            this.basicRunMirrorApplication("Forcing Retry", retryRepo.getLocation(), this.destRepoLocation.toURI());
        }
        catch (MalformedURLException e) {
            NewMirrorApplicationArtifactTest.fail("Error creating arguments", e);
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail("Error while running Mirror Application and forcing retry", e);
        }
        NewMirrorApplicationArtifactTest.assertFalse((boolean)retryRepo.firstAttempt);
        try {
            NewMirrorApplicationArtifactTest.assertContentEquals("Verifying content", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("Failure while verifying destination", e);
        }
    }

    public void testErrorLoggingNoVerbose() {
        FrameworkLog log = (FrameworkLog)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)FrameworkLog.class.getName());
        NewMirrorApplicationArtifactTest.assertNotNull((String)"Assert log file is not null", (Object)log);
        NewMirrorApplicationArtifactTest.assertTrue((String)"Clearing log file", (boolean)log.getFile().delete());
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            this.mirrorWithError(false);
        }
        finally {
            System.setOut(out);
        }
        try {
            String[] parts = new String[]{"Artifact not found:", MISSING_ARTIFACT};
            NewMirrorApplicationArtifactTest.assertLogContainsLine(log.getFile(), parts);
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail("error verifying output", e);
        }
        this.artifactMirrorToFullDuplicate("Generating INFO entries", true);
        IArtifactRepository sourceRepository = null;
        try {
            sourceRepository = NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("Error loading source repository for verification", e);
        }
        try {
            IQueryResult descriptors = sourceRepository.descriptorQueryable().query((IQuery)ArtifactDescriptorQuery.ALL_DESCRIPTORS, null);
            IArtifactDescriptor descriptor = (IArtifactDescriptor)descriptors.iterator().next();
            String message = NLS.bind((String)org.eclipse.equinox.internal.p2.artifact.repository.Messages.mirror_alreadyExists, (Object)descriptor, (Object)this.destRepoLocation.toURI());
            NewMirrorApplicationArtifactTest.assertLogDoesNotContainLine(log.getFile(), message);
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail("Error verifying log", e);
        }
    }

    public void testErrorLoggingWithVerbose() {
        FrameworkLog log = (FrameworkLog)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)FrameworkLog.class.getName());
        NewMirrorApplicationArtifactTest.assertNotNull((String)"Assert log file is not null", (Object)log);
        NewMirrorApplicationArtifactTest.assertTrue((String)"Clearing log file", (log.getFile().exists() && log.getFile().delete() ? 1 : 0) != 0);
        PrintStream oldOut = System.out;
        PrintStream newOut = null;
        PrintStream oldErr = System.err;
        PrintStream newErr = null;
        try {
            try {
                this.destRepoLocation.mkdir();
                newOut = new PrintStream(new FileOutputStream(new File(this.destRepoLocation, "sys.out")));
                newErr = new PrintStream(new FileOutputStream(new File(this.destRepoLocation, "sys.err")));
            }
            catch (FileNotFoundException e) {
                NewMirrorApplicationArtifactTest.fail("Error redirecting output", e);
            }
            System.setOut(newOut);
            System.setErr(newErr);
            this.mirrorWithError(true);
            try {
                String[] parts = new String[]{"Artifact not found:", MISSING_ARTIFACT};
                NewMirrorApplicationArtifactTest.assertLogContainsLine(log.getFile(), parts);
            }
            catch (Exception e) {
                NewMirrorApplicationArtifactTest.fail("error verifying output", e);
            }
            this.runMirrorApplication("Initializing Destiantion", this.sourceRepoLocation, this.destRepoLocation, false);
            try {
                MirrorApplication app = new MirrorApplication();
                app.addSource(this.createRepositoryDescriptor(this.sourceRepoLocation.toURI(), null, null, null));
                app.addDestination(this.createRepositoryDescriptor(this.destRepoLocation.toURI(), null, null, null));
                app.setVerbose(true);
                app.run(null);
            }
            catch (Exception e) {
                NewMirrorApplicationArtifactTest.fail("Error running mirror application to generate INFO items", e);
            }
        }
        finally {
            System.setOut(oldOut);
            if (newOut != null) {
                newOut.close();
            }
            System.setErr(oldErr);
            if (newErr != null) {
                newErr.close();
            }
        }
        IArtifactRepository sourceRepository = null;
        try {
            sourceRepository = NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null);
        }
        catch (ProvisionException e) {
            NewMirrorApplicationArtifactTest.fail("Error loading source repository for verification", e);
        }
        try {
            IQueryResult descriptors = sourceRepository.descriptorQueryable().query((IQuery)ArtifactDescriptorQuery.ALL_DESCRIPTORS, null);
            IArtifactDescriptor descriptor = (IArtifactDescriptor)descriptors.iterator().next();
            String message = NLS.bind((String)org.eclipse.equinox.internal.p2.artifact.repository.Messages.mirror_alreadyExists, (Object)descriptor, (Object)this.destRepoLocation.toURI());
            NewMirrorApplicationArtifactTest.assertLogContainsLine(log.getFile(), message);
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail("Error verifying log", e);
        }
    }

    public void testArtifactMirrorNonURIDest() {
        try {
            this.basicRunMirrorApplication("Mirroring", this.sourceRepoLocation.toURI(), this.destRepoLocation.toURI());
            NewMirrorApplicationArtifactTest.assertContentEquals("2.1", NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.sourceRepoLocation.toURI(), null), NewMirrorApplicationArtifactTest.getArtifactRepositoryManager().loadRepository(this.destRepoLocation.toURI(), null));
        }
        catch (Exception e) {
            NewMirrorApplicationArtifactTest.fail("Error mirroring", e);
        }
    }
}

