/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import junit.framework.TestCase;
import org.eclipse.equinox.p2.metadata.Version;

public class FormatArrayTest
extends TestCase {
    public void testEmptyArray() {
        try {
            Version.parseVersion((String)"format(<>q):''");
            FormatArrayTest.fail((String)"Uncaught error: empty array group is not allowed:");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatArrayTest.assertTrue((boolean)true);
        }
    }

    public void testEmptyArrayBecauseContentIsOptional() {
        try {
            Version.parseVersion((String)"format(<n?>q):''");
            FormatArrayTest.fail((String)"Uncaught error: produces an empty vector");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatArrayTest.assertTrue((boolean)true);
        }
    }

    public void testOptionalArray() {
        Version v = Version.parseVersion((String)"format(<n>?S):abc");
        FormatArrayTest.assertNotNull((Object)v);
        FormatArrayTest.assertEquals((Object)Version.parseVersion((String)"raw:'abc'"), (Object)v);
        v = Version.parseVersion((String)"format(<n>?S):1abc");
        FormatArrayTest.assertNotNull((Object)v);
        FormatArrayTest.assertEquals((Object)Version.parseVersion((String)"raw:<1>.'abc'"), (Object)v);
    }

    public void testNumericArray() {
        Version v = Version.parseVersion((String)"format(<(n.?)+>):1.2.3.4.5.6.7.8.9");
        FormatArrayTest.assertNotNull((Object)v);
        FormatArrayTest.assertEquals((Object)Version.parseVersion((String)"raw:<1.2.3.4.5.6.7.8.9>"), (Object)v);
    }

    public void testStringArray() {
        Version v = Version.parseVersion((String)"format(<(S=[^.];d?)+>):a.b.c.d.e.f.g.h.i");
        FormatArrayTest.assertNotNull((Object)v);
        FormatArrayTest.assertEquals((Object)Version.parseVersion((String)"raw:<'a'.'b'.'c'.'d'.'e'.'f'.'g'.'h'.'i'>"), (Object)v);
    }

    public void testNestedArray() {
        Version v = Version.parseVersion((String)"format(<n.<n.n>.n>):1.2.3.4");
        FormatArrayTest.assertNotNull((Object)v);
        FormatArrayTest.assertEquals((Object)Version.parseVersion((String)"raw:<1.<2.3>.4>"), (Object)v);
        v = Version.parseVersion((String)"format(<n.<n.<n>>.n>):1.2.3.4");
        FormatArrayTest.assertNotNull((Object)v);
        FormatArrayTest.assertEquals((Object)Version.parseVersion((String)"raw:<1.<2.<3>>.4>"), (Object)v);
    }
}

