/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import junit.framework.TestCase;
import org.eclipse.equinox.p2.metadata.Version;

public class FormatRTest
extends TestCase {
    public void testNumeric() {
        Version v = Version.parseVersion((String)"format(r):1");
        FormatRTest.assertNotNull((Object)v);
        FormatRTest.assertEquals((Object)Version.parseVersion((String)"raw:1"), (Object)v);
    }

    public void testNegativeNumeric() {
        Version v = Version.parseVersion((String)"format(r):-1");
        FormatRTest.assertNotNull((Object)v);
        FormatRTest.assertEquals((Object)Version.parseVersion((String)"raw:-1"), (Object)v);
    }

    public void testString() {
        Version v = Version.parseVersion((String)"format(r):'a'");
        FormatRTest.assertNotNull((Object)v);
        FormatRTest.assertEquals((Object)Version.parseVersion((String)"raw:'a'"), (Object)v);
        v = Version.parseVersion((String)"format(r):\"a\"");
        FormatRTest.assertNotNull((Object)v);
        FormatRTest.assertEquals((Object)Version.parseVersion((String)"raw:'a'"), (Object)v);
    }

    public void testConcatentatedStrings() {
        Version v = Version.parseVersion((String)"format(r):'a''b'");
        FormatRTest.assertNotNull((Object)v);
        FormatRTest.assertEquals((Object)Version.parseVersion((String)"raw:'ab'"), (Object)v);
        v = Version.parseVersion((String)"format(r):'a has a \"hat\" it is '\"a's\"");
        FormatRTest.assertNotNull((Object)v);
        FormatRTest.assertEquals((Object)Version.parseVersion((String)"raw:'a has a \"hat\" it is '\"a's\""), (Object)v);
    }

    public void testMaxString() {
        Version v = Version.parseVersion((String)"format(r):m");
        FormatRTest.assertNotNull((Object)v);
        FormatRTest.assertEquals((Object)Version.parseVersion((String)"raw:m"), (Object)v);
    }

    public void testMaxNumeric() {
        Version v = Version.parseVersion((String)"format(r):M");
        FormatRTest.assertNotNull((Object)v);
        FormatRTest.assertEquals((Object)Version.parseVersion((String)"raw:M"), (Object)v);
    }

    public void testArray() {
        Version v = Version.parseVersion((String)"format(r):<1>");
        FormatRTest.assertNotNull((Object)v);
        FormatRTest.assertEquals((Object)Version.parseVersion((String)"raw:<1>"), (Object)v);
    }

    public void testNonRElements() {
        try {
            Version.parseVersion((String)"format(r):aaa");
            FormatRTest.fail((String)"a is not a valid raw element");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatRTest.assertTrue((boolean)true);
        }
        try {
            Version.parseVersion((String)"format(r):1,2");
            FormatRTest.fail((String)"comma is not a delimiter in raw format");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatRTest.assertTrue((boolean)true);
        }
    }
}

