/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.tests.omniVersion.VersionTesting;

public class FormatRangeTest
extends VersionTesting {
    public static String OSGI_PREFIX = "format(n[.n=0;[.n=0;[.S=[A-Za-z0-9_-];]]]):";

    public void testRangeWithDefaultValues() {
        VersionRange range = new VersionRange(String.valueOf(OSGI_PREFIX) + "0");
        this.assertIncludedInRange("#1", range, String.valueOf(OSGI_PREFIX) + "0");
        this.assertIncludedInRange("#2", range, String.valueOf(OSGI_PREFIX) + "0.0");
        this.assertIncludedInRange("#3", range, String.valueOf(OSGI_PREFIX) + "0.0.0");
    }

    public void testEmptyRange() {
        try {
            new VersionRange(OSGI_PREFIX);
            FormatRangeTest.fail((String)"Uncught error: range can not be empty");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FormatRangeTest.assertTrue((boolean)true);
        }
    }

    public void testRangeDelimitersInVersionString() {
        VersionRange range = new VersionRange("format(S):[one\\,\\ two,three\\,\\ \\[and\\]\\ four]");
        this.assertIncludedInRange("#1", range, "format(S):one, two");
        this.assertIncludedInRange("#1", range, "format(S):three, [and] four");
    }

    public void testSingleVersionRange() {
        VersionRange range = new VersionRange(String.valueOf(OSGI_PREFIX) + "[1.0.0, 1.0.0.x)");
        FormatRangeTest.assertEquals((String)"0.1", (Object)Version.parseVersion((String)(String.valueOf(OSGI_PREFIX) + "1.0.0")), (Object)range.getMinimum());
        FormatRangeTest.assertEquals((String)"0.2", (Object)Version.parseVersion((String)(String.valueOf(OSGI_PREFIX) + "1.0.0.x")), (Object)range.getMaximum());
        this.assertNotIncludedInRange("0.9", range, String.valueOf(OSGI_PREFIX) + "0.9");
        this.assertIncludedInRange("1.2", range, String.valueOf(OSGI_PREFIX) + "1.0.0");
        this.assertNotIncludedInRange("2.1", range, String.valueOf(OSGI_PREFIX) + "1.0.0.z");
        this.assertNotIncludedInRange("2.2", range, String.valueOf(OSGI_PREFIX) + "1.0.1");
        this.assertNotIncludedInRange("2.3", range, String.valueOf(OSGI_PREFIX) + "1.1");
        this.assertNotIncludedInRange("2.4", range, String.valueOf(OSGI_PREFIX) + "2");
    }

    public void testGreaterThan() {
        VersionRange lowerBound = new VersionRange(String.valueOf(OSGI_PREFIX) + "1.0.0");
        this.assertNotIncludedInRange("1.0", lowerBound, String.valueOf(OSGI_PREFIX) + "0.9.0");
        this.assertIncludedInRange("1.1", lowerBound, String.valueOf(OSGI_PREFIX) + "1.0.0");
        this.assertIncludedInRange("1.2", lowerBound, String.valueOf(OSGI_PREFIX) + "1.9.9.x");
        this.assertIncludedInRange("1.3", lowerBound, String.valueOf(OSGI_PREFIX) + "999.999.999.foo");
    }

    public void testGreaterThanMinimum() {
        VersionRange lowerBound = new VersionRange("raw:-M");
        this.assertIncludedInRange("0.1", lowerBound, "raw:-M");
        this.assertIncludedInRange("1.0", lowerBound, String.valueOf(OSGI_PREFIX) + "0.9.0");
        this.assertIncludedInRange("1.1", lowerBound, String.valueOf(OSGI_PREFIX) + "1.0.0");
        this.assertIncludedInRange("1.2", lowerBound, String.valueOf(OSGI_PREFIX) + "1.9.9.x");
        this.assertIncludedInRange("1.3", lowerBound, String.valueOf(OSGI_PREFIX) + "999.999.999.foo");
    }

    public void testLowerThan() {
        VersionRange upperBound = new VersionRange(String.valueOf(OSGI_PREFIX) + "[0, 2.0.0)");
        this.assertIncludedInRange("1.0", upperBound, String.valueOf(OSGI_PREFIX) + "0.0");
        this.assertIncludedInRange("1.1", upperBound, String.valueOf(OSGI_PREFIX) + "0.9");
        this.assertIncludedInRange("1.2", upperBound, String.valueOf(OSGI_PREFIX) + "1.0");
        this.assertIncludedInRange("1.3", upperBound, String.valueOf(OSGI_PREFIX) + "1.9.9.x");
        this.assertNotIncludedInRange("1.4", upperBound, String.valueOf(OSGI_PREFIX) + "2.0");
        this.assertNotIncludedInRange("1.5", upperBound, String.valueOf(OSGI_PREFIX) + "2.1");
    }
}

