/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.tests.omniVersion.VersionTesting;

public class RawRangeTest
extends VersionTesting {
    public void testEmptyRange() {
        VersionRange range = new VersionRange("raw:''");
        this.assertIncludedInRange("#1", range, "raw:'a'");
        try {
            new VersionRange("raw:");
            RawRangeTest.fail((String)"Uncaught error: a raw range can not be empty.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawRangeTest.assertTrue((boolean)true);
        }
    }

    public void testRangeDelimitersInStrings() {
        VersionRange range = null;
        range = new VersionRange("raw:['one\\,\\ two','three\\,\\ \\[and\\]\\ four']");
        this.assertIncludedInRange("#1", range, "raw:'one, two'");
        this.assertIncludedInRange("#2", range, "raw:'three, [and] four'");
    }

    public void testRangeDelimitersInStringstoString() {
        VersionRange range = null;
        String s = null;
        s = "raw:['one\\,\\ two','three\\,\\ \\[and\\]\\ four']";
        range = new VersionRange("raw:['one\\,\\ two','three\\,\\ \\[and\\]\\ four']");
        RawRangeTest.assertEquals((String)s, (String)range.toString());
    }

    public void testSingleVersionRange() {
        VersionRange range = new VersionRange("raw:[1.0.0, 1.0.0.'-')");
        RawRangeTest.assertEquals((String)"0.1", (Object)Version.parseVersion((String)"raw:1.0.0"), (Object)range.getMinimum());
        RawRangeTest.assertEquals((String)"0.2", (Object)Version.parseVersion((String)"raw:1.0.0.'-'"), (Object)range.getMaximum());
        this.assertNotIncludedInRange("0.9", range, "raw:0.9");
        this.assertNotIncludedInRange("1.0", range, "raw:1");
        this.assertNotIncludedInRange("1.1", range, "raw:1.0");
        this.assertIncludedInRange("1.2", range, "raw:1.0.0");
        this.assertNotIncludedInRange("2.1", range, "raw:1.0.0.'0'");
        this.assertNotIncludedInRange("2.2", range, "raw:1.0.1");
        this.assertNotIncludedInRange("2.3", range, "raw:1.1");
        this.assertNotIncludedInRange("2.4", range, "raw:2");
    }

    public void testInvertedRange() {
        try {
            new VersionRange("raw:[2.0.0, 1.0.0]");
            RawRangeTest.fail((String)"Inverted range is not allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawRangeTest.assertTrue((boolean)true);
        }
    }

    public void testGreaterThan() {
        VersionRange lowerBound = new VersionRange("raw:1.0.0");
        this.assertNotIncludedInRange("1.0", lowerBound, "raw:0.9.0");
        this.assertIncludedInRange("1.1", lowerBound, "raw:1.0.0");
        this.assertIncludedInRange("1.2", lowerBound, "raw:1.9.9.'x'");
        this.assertIncludedInRange("1.3", lowerBound, "raw:999.999.999.'foo'");
        this.assertIncludedInRange("1.3", lowerBound, "raw:M.M.M.m");
    }

    public void testGreaterThanSmallest() {
        VersionRange lowerBound = new VersionRange("raw:-M");
        this.assertIncludedInRange("#1", lowerBound, "raw:-M");
        this.assertIncludedInRange("#1.1", lowerBound, "raw:''");
        this.assertIncludedInRange("#1.1", lowerBound, "raw:m");
        this.assertIncludedInRange("#2", lowerBound, "raw:0.9.0");
        this.assertIncludedInRange("#3", lowerBound, "raw:1.0.0");
        this.assertIncludedInRange("#4", lowerBound, "raw:1.9.9.'x'");
        this.assertIncludedInRange("#5", lowerBound, "raw:999.999.999.'foo'");
        this.assertIncludedInRange("#6", lowerBound, "raw:M.M.M.m");
        this.assertIncludedInRange("#7", lowerBound, "raw:M");
        this.assertIncludedInRange("#8", lowerBound, "raw:MpM");
    }

    public void testLowerThan() {
        VersionRange upperBound = new VersionRange("raw:[0, 2.0)");
        this.assertIncludedInRange("1.0", upperBound, "raw:0.0");
        this.assertIncludedInRange("1.1", upperBound, "raw:0.9");
        this.assertIncludedInRange("1.2", upperBound, "raw:1.0");
        this.assertIncludedInRange("1.3", upperBound, "raw:1.9.9.'x'");
        this.assertNotIncludedInRange("1.4", upperBound, "raw:2.0");
        this.assertNotIncludedInRange("1.5", upperBound, "raw:2.1");
    }

    public void testSerialize() {
        VersionRange v = null;
        v = new VersionRange("raw:1.0.0");
        RawRangeTest.assertSerialized(v);
        v = new VersionRange("raw:[1.0.0,2.0.0]");
        RawRangeTest.assertSerialized(v);
        v = new VersionRange("raw:(1.0.0,2.0.0]");
        RawRangeTest.assertSerialized(v);
        v = new VersionRange("raw:[1.0.0,2.0.0)");
        RawRangeTest.assertSerialized(v);
        v = new VersionRange("raw:(1.0.0,2.0.0)");
        RawRangeTest.assertSerialized(v);
        v = new VersionRange("raw:1.0.0.'abcdef'");
        RawRangeTest.assertSerialized(v);
        v = new VersionRange("raw:[1.0.0.'abcdef',2.0.0.'abcdef']");
        RawRangeTest.assertSerialized(v);
        v = new VersionRange("raw:(1.0.0.'abcdef',2.0.0.'abcdef']");
        RawRangeTest.assertSerialized(v);
        v = new VersionRange("raw:[1.0.0.'abcdef',2.0.0.'abcdef')");
        RawRangeTest.assertSerialized(v);
        v = new VersionRange("raw:(1.0.0.'abcdef',2.0.0.'abcdef')");
        RawRangeTest.assertSerialized(v);
    }

    public void testToString() {
        VersionRange v = null;
        String s = null;
        s = "raw:1.0.0";
        v = new VersionRange("raw:1.0.0");
        RawRangeTest.assertEquals((String)s, (String)v.toString());
        s = "raw:[1.0.0,2.0.0]";
        v = new VersionRange("raw:[1.0.0,2.0.0]");
        RawRangeTest.assertEquals((String)s, (String)v.toString());
        s = "raw:(1.0.0,2.0.0]";
        v = new VersionRange("raw:(1.0.0,2.0.0]");
        RawRangeTest.assertEquals((String)s, (String)v.toString());
        s = "raw:[1.0.0,2.0.0)";
        v = new VersionRange("raw:[1.0.0,2.0.0)");
        RawRangeTest.assertEquals((String)s, (String)v.toString());
        s = "raw:(1.0.0,2.0.0)";
        v = new VersionRange("raw:(1.0.0,2.0.0)");
        RawRangeTest.assertEquals((String)s, (String)v.toString());
        s = "raw:1.0.0.'abcdef'";
        v = new VersionRange("raw:1.0.0.'abcdef'");
        RawRangeTest.assertEquals((String)s, (String)v.toString());
        s = "raw:[1.0.0.'abcdef',2.0.0.'abcdef']";
        v = new VersionRange("raw:[1.0.0.'abcdef',2.0.0.'abcdef']");
        RawRangeTest.assertEquals((String)s, (String)v.toString());
        s = "raw:(1.0.0.'abcdef',2.0.0.'abcdef']";
        v = new VersionRange("raw:(1.0.0.'abcdef',2.0.0.'abcdef']");
        RawRangeTest.assertEquals((String)s, (String)v.toString());
        s = "raw:[1.0.0.'abcdef',2.0.0.'abcdef')";
        v = new VersionRange("raw:[1.0.0.'abcdef',2.0.0.'abcdef')");
        RawRangeTest.assertEquals((String)s, (String)v.toString());
        s = "raw:(1.0.0.'abcdef',2.0.0.'abcdef')";
        v = new VersionRange("raw:(1.0.0.'abcdef',2.0.0.'abcdef')");
        RawRangeTest.assertEquals((String)s, (String)v.toString());
    }
}

