/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.omniVersion;

import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.tests.omniVersion.VersionTesting;

public class RawRangeWithOriginalTest
extends VersionTesting {
    public void testRawWithUnknownFormat() {
        VersionRange v = new VersionRange("raw:[1.0,2.0]/:sailor.moon.R,sailor.moon.S");
        RawRangeWithOriginalTest.assertEquals((Object)v, (Object)new VersionRange("raw:[1.0,2.0]"));
    }

    public void testRawWithUnknownFormatToString() {
        RawRangeWithOriginalTest.assertEquals((String)"raw:[1.0,2.0]/:sailor.moon.R,sailor.moon.S", (String)new VersionRange("raw:[1.0,2.0]/:sailor.moon.R,sailor.moon.S").toString());
    }

    public void testRawWithUnknownFormatSerialized() {
        RawRangeWithOriginalTest.assertSerialized(new VersionRange("raw:[1.0,2.0]/:sailor.moon.R,sailor.moon.S"));
        RawRangeWithOriginalTest.assertEquals((String)"raw:[1.0,2.0]/:sailor.moon.R,sailor.moon.S", (String)RawRangeWithOriginalTest.getSerialized(new VersionRange("raw:[1.0,2.0]/:sailor.moon.R,sailor.moon.S")).toString());
    }

    public void testRawWithSimpleFormat() {
        VersionRange v = new VersionRange("raw:[1.0,2.0]/format(n.n):[1.0,2.0]");
        RawRangeWithOriginalTest.assertEquals((Object)v, (Object)new VersionRange("raw:[1.0,2.0]"));
    }

    public void testRawWithSimpleFormatToString() {
        RawRangeWithOriginalTest.assertEquals((String)"raw:[1.0,2.0]/format(n.n):1.0,2.0", (String)new VersionRange("raw:[1.0,2.0]/format(n.n):[1.0,2.0]").toString());
    }

    public void testSimpleFormatToString() {
        RawRangeWithOriginalTest.assertEquals((String)"raw:[1.0,2.0]/format(n.n):1.0,2.0", (String)new VersionRange("format(n.n):[1.0,2.0]").toString());
    }

    public void testRawWithSimpleFormatSerialized() {
        RawRangeWithOriginalTest.assertSerialized(new VersionRange("raw:[1.0,2.0]/format(n.n):[1.0,2.0]"));
        RawRangeWithOriginalTest.assertEquals((String)"raw:[1.0,2.0]/format(n.n):1.0,2.0", (String)RawRangeWithOriginalTest.getSerialized(new VersionRange("raw:[1.0,2.0]/format(n.n):[1.0,2.0]")).toString());
    }

    public void testOriginalStatedButMissing() {
        try {
            new VersionRange("raw:[1.0,2.0]/");
            RawRangeWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawRangeWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testOriginalAndUnknownStatedButMissing() {
        try {
            new VersionRange("raw:[1.0,2.0]/:");
            RawRangeWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawRangeWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testOriginalIllegalFormat() {
        try {
            new VersionRange("raw:[1.0,2.0]/foo:");
            RawRangeWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawRangeWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testOriginalIllegalFormat2() {
        try {
            new VersionRange("raw:[1.0,2.0]/100:");
            RawRangeWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawRangeWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testOriginalIllegalFormat3() {
        try {
            new VersionRange("raw:[1.0,2.0]/'format':");
            RawRangeWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawRangeWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testOriginalIllegalFormat4() {
        try {
            new VersionRange("raw:[1.0,2.0]//1.0");
            RawRangeWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawRangeWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testOriginalIllegalFormat5() {
        try {
            new VersionRange("raw:[1.0,2.0]/format:");
            RawRangeWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawRangeWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testOriginalFormatUnbalancedLeft() {
        try {
            new VersionRange("raw:[1.0,2.0]/formatn.n):");
            RawRangeWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawRangeWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testOriginalFormatUnbalancedRight() {
        try {
            new VersionRange("raw:[1.0,2.0]/format(n.n:1.0");
            RawRangeWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawRangeWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testOriginalFormatOriginalMissing() {
        try {
            new VersionRange("raw:[1.0,2.0]/format(n.n):");
            RawRangeWithOriginalTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RawRangeWithOriginalTest.assertTrue((boolean)true);
        }
    }

    public void testGreaterThan() {
        VersionRange lowerBound = new VersionRange("raw:2.1.0.M/format(n[.n=0;[.n=0;]][d?S=M;]):2.1");
        this.assertNotIncludedInRange("1.0", lowerBound, "raw:2.0.9");
        this.assertIncludedInRange("1.1", lowerBound, "raw:2.2");
        this.assertIncludedInRange("1.3", lowerBound, "raw:999.999.999.'foo'");
    }

    public void testMinBoundary() {
        String rangeString = "raw:[-M,2.1.0.M]/format(n[.n=0;[.n=0;]][d?S=M;]):-M,2.1";
        VersionRange range = new VersionRange(rangeString);
        RawRangeWithOriginalTest.assertEquals((String)rangeString, (String)range.toString());
        VersionRange range1 = new VersionRange(range.getMinimum(), range.getIncludeMinimum(), range.getMaximum(), range.getIncludeMaximum());
        RawRangeWithOriginalTest.assertEquals((Object)range1, (Object)range);
        VersionRange range2 = new VersionRange(null, true, range.getMaximum(), range.getIncludeMaximum());
        RawRangeWithOriginalTest.assertEquals((Object)range2, (Object)range);
    }

    public void testOSGiMinBoundary() {
        String rangeString = "raw:[-M,2.1.0.'']/format(n[.n=0;[.n=0;[.S='';=[A-Za-z0-9_-];]]]):-M,2.1.0";
        VersionRange range = new VersionRange(rangeString);
        VersionRange range1 = new VersionRange("[0.0.0,2.1.0]");
        RawRangeWithOriginalTest.assertEquals((Object)range1, (Object)range);
        RawRangeWithOriginalTest.assertEquals((String)"[0.0.0,2.1.0]", (String)range.toString());
        VersionRange range2 = new VersionRange(null, true, range.getMaximum(), range.getIncludeMaximum());
        RawRangeWithOriginalTest.assertEquals((Object)range2, (Object)range);
    }

    public void testMaxBoundary() {
        String rangeString = "raw:[2.1.0.M,MpM]/format(n[.n=0;[.n=0;]][d?S=M;]):2.1,MpM";
        VersionRange range = new VersionRange(rangeString);
        RawRangeWithOriginalTest.assertEquals((String)"raw:2.1.0.M/format(n[.n=0;[.n=0;]][d?S=M;]):2.1", (String)range.toString());
        VersionRange range1 = new VersionRange(range.getMinimum(), range.getIncludeMinimum(), range.getMaximum(), range.getIncludeMaximum());
        RawRangeWithOriginalTest.assertEquals((Object)range1, (Object)range);
        VersionRange range2 = new VersionRange(range.getMinimum(), true, null, true);
        RawRangeWithOriginalTest.assertEquals((Object)range2, (Object)range);
    }

    public void testRecreateUsingMaxUpper() {
        Version v = Version.create((String)"format(n[.n=0;[.n=0;]][d?S=M;]):2.1");
        VersionRange range = new VersionRange(v, true, null, true);
        Version min = range.getMinimum();
        Version max = range.getMaximum();
        VersionRange range2 = new VersionRange(min, true, max, true);
        RawRangeWithOriginalTest.assertEquals((Object)range2, (Object)range);
    }

    public void testRecreateUsingMinLower() {
        Version v = Version.create((String)"format(n[.n=0;[.n=0;]][d?S=M;]):2.1");
        VersionRange range = new VersionRange(null, true, v, true);
        Version min = range.getMinimum();
        Version max = range.getMaximum();
        VersionRange range2 = new VersionRange(min, true, max, true);
        RawRangeWithOriginalTest.assertEquals((Object)range2, (Object)range);
    }

    public void testOSGiMaxBoundary() {
        String rangeString = "raw:[2.1.0.'',MpM]/format(n[.n=0;[.n=0;[.S='';=[A-Za-z0-9_-];]]]):2.1.0,MpM";
        VersionRange range = new VersionRange(rangeString);
        VersionRange range1 = new VersionRange("2.1.0");
        RawRangeWithOriginalTest.assertEquals((Object)range1, (Object)range);
        RawRangeWithOriginalTest.assertEquals((String)"2.1.0", (String)range.toString());
        VersionRange range2 = new VersionRange(range.getMinimum(), true, null, true);
        RawRangeWithOriginalTest.assertEquals((Object)range2, (Object)range);
    }
}

