/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.Operand;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPlannerTest
extends AbstractProvisioningTest {
    private IProfile profile;
    private File previousStoreValue = null;
    IMetadataRepository repo = null;

    protected abstract String getTestDataPath();

    protected abstract String getProfileId();

    protected IProfile getProfile() {
        return this.profile;
    }

    protected Collection compress(IProvisioningPlan plan) {
        HashMap<String, InstallableUnitOperand> result = new HashMap<String, InstallableUnitOperand>();
        Operand[] operands = ((ProvisioningPlan)plan).getOperands();
        int i = 0;
        while (i < operands.length) {
            if (operands[i] instanceof InstallableUnitOperand) {
                InstallableUnitOperand operand = (InstallableUnitOperand)operands[i];
                String id = operand.first() == null ? operand.second().getId() : operand.first().getId();
                InstallableUnitOperand existing = (InstallableUnitOperand)result.get(id);
                if (existing == null) {
                    result.put(id, operand);
                } else {
                    IInstallableUnit first = existing.first() == null ? operand.first() : existing.first();
                    IInstallableUnit second = existing.second() == null ? operand.second() : existing.second();
                    result.put(id, new InstallableUnitOperand(first, second));
                }
            }
            ++i;
        }
        return result.values();
    }

    protected ProvisioningContext getContext(Collection<URI> repoLocations) {
        ProvisioningContext result = new ProvisioningContext(AbstractPlannerTest.getAgent());
        result.setMetadataRepositories(repoLocations == null ? new URI[]{} : repoLocations.toArray(new URI[repoLocations.size()]));
        result.setArtifactRepositories(new URI[0]);
        return result;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File reporegistry1 = AbstractPlannerTest.getTestData("loading planner test data", this.getTestDataPath());
        File tempFolder = this.getTempFolder();
        AbstractPlannerTest.copy("0.2", reporegistry1, tempFolder);
        IProfileRegistry realProfileRegistry = this.getProfileRegistry();
        Field profileStore = SimpleProfileRegistry.class.getDeclaredField("store");
        profileStore.setAccessible(true);
        this.previousStoreValue = (File)profileStore.get(realProfileRegistry);
        profileStore.set(realProfileRegistry, new File(tempFolder, "p2/org.eclipse.equinox.p2.engine/profileRegistry"));
        Field profilesMapField = SimpleProfileRegistry.class.getDeclaredField("profiles");
        profilesMapField.setAccessible(true);
        profilesMapField.set(realProfileRegistry, null);
        this.profile = realProfileRegistry.getProfile(this.getProfileId());
        AbstractPlannerTest.assertNotNull((Object)this.profile);
        this.repo = this.loadMetadataRepository(AbstractPlannerTest.getTestData("planner test repo", String.valueOf(this.getTestDataPath()) + "/repo").toURI());
    }

    @Override
    protected void tearDown() throws Exception {
        SimpleProfileRegistry realProfileRegistry = (SimpleProfileRegistry)this.getProfileRegistry();
        Field profilesMapField = SimpleProfileRegistry.class.getDeclaredField("profiles");
        profilesMapField.setAccessible(true);
        profilesMapField.set(realProfileRegistry, null);
        Field profileStore = SimpleProfileRegistry.class.getDeclaredField("store");
        profileStore.setAccessible(true);
        profileStore.set(realProfileRegistry, this.previousStoreValue);
        super.tearDown();
    }

    protected IProfileChangeRequest createProfileChangeRequest(Collection optionalAdds, Collection strictAdds, Collection toRemove) {
        ProfileChangeRequest result = new ProfileChangeRequest(this.profile);
        if (optionalAdds != null) {
            for (IInstallableUnit iu : optionalAdds) {
                result.add(iu);
                result.setInstallableUnitInclusionRules(iu, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)iu));
                result.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.lock", "1");
                result.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.reconciler.dropins", "true");
            }
        }
        if (strictAdds != null) {
            for (IInstallableUnit iu : strictAdds) {
                result.add(iu);
                result.setInstallableUnitInclusionRules(iu, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)iu));
            }
        }
        if (toRemove != null) {
            for (IInstallableUnit iu : toRemove) {
                result.remove(iu);
            }
        }
        return result;
    }

    protected void assertContains(String message, IProvisioningPlan expectedPlan, IProvisioningPlan actualPlan) {
        Operand[] expectedOperands = ((ProvisioningPlan)expectedPlan).getOperands();
        Operand[] actualOperands = ((ProvisioningPlan)actualPlan).getOperands();
        AbstractPlannerTest.assertFalse((String)"0.9 Plan is empty.", (expectedOperands.length == 0 ? 1 : 0) != 0);
        int outer = 0;
        while (outer < expectedOperands.length) {
            block7: {
                if (!(expectedOperands[outer] instanceof InstallableUnitOperand)) break block7;
                IInstallableUnit first = ((InstallableUnitOperand)expectedOperands[outer]).first();
                IInstallableUnit second = ((InstallableUnitOperand)expectedOperands[outer]).second();
                boolean found = false;
                int inner = 0;
                while (inner < actualOperands.length) {
                    block8: {
                        InstallableUnitOperand actual;
                        block9: {
                            if (!(actualOperands[inner] instanceof InstallableUnitOperand)) break block8;
                            actual = (InstallableUnitOperand)actualOperands[inner];
                            if (second != null) break block9;
                            if (actual.second() != null || !actual.first().getId().equals(first.getId())) break block8;
                            AbstractPlannerTest.assertEquals("0.5", first, actual.first());
                        }
                        AbstractPlannerTest.assertNotNull((String)("1.2 " + actual), (Object)actual.second());
                        if (actual.second().getId().equals(second.getId())) {
                            AbstractPlannerTest.assertEquals("2.0", second, actual.second());
                            found = true;
                        }
                    }
                    ++inner;
                }
                if (!found) {
                    AbstractPlannerTest.fail((String)("3.0 Plan is missing install operand for: " + second));
                }
            }
            ++outer;
        }
    }
}

