/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class AllOptional
extends AbstractProvisioningTest {
    private IInstallableUnit a1;
    private IInstallableUnit b1;
    private IInstallableUnit c1;
    private IInstallableUnit d1;
    private IInstallableUnit e1;
    private IProfile profile;
    private IPlanner planner;

    protected void setUp() throws Exception {
        super.setUp();
        IRequirement[] reqA = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)true)};
        this.a1 = AllOptional.createIU("A", Version.create((String)"1.0.0"), reqA);
        this.b1 = AllOptional.createIU("B", Version.create((String)"1.0.0"), true);
        IRequirement[] reqC = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"D", (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"E", (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)false, (boolean)true)};
        this.c1 = AllOptional.createIU("C", Version.create((String)"1.0.0"), reqC);
        this.d1 = AllOptional.createIU("D", Version.create((String)"1.0.0"), true);
        this.e1 = AllOptional.createIU("E", Version.create((String)"1.0.0"), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1, this.c1, this.d1, this.e1});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = AllOptional.createPlanner();
    }

    public void testInstallation() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1, this.c1});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        AllOptional.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        AllOptional.assertInstallOperand(plan, this.a1);
        AllOptional.assertInstallOperand(plan, this.b1);
        AllOptional.assertInstallOperand(plan, this.c1);
        AllOptional.assertInstallOperand(plan, this.d1);
        AllOptional.assertInstallOperand(plan, this.e1);
    }
}

