/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug207319
extends AbstractProvisioningTest {
    IInstallableUnit a;
    IInstallableUnit b;
    IInstallableUnit c;
    IDirector director;
    IProfile profile;

    protected void setUp() throws Exception {
        super.setUp();
        this.a = Bug207319.createIU("A", Version.create((String)"1.0.0"));
        this.b = Bug207319.createIU("B", Version.create((String)"1.0.0"), new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"A", (Version)Version.create((String)"1.0.0"))});
        this.c = Bug207319.createIU("C", Version.create((String)"1.0.0"), Bug207319.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "A", new VersionRange("[1.0.0, 1.0.0]")));
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a, this.b, this.c});
        this.profile = this.createProfile(Bug207319.class.getName());
        this.director = Bug207319.createDirector();
    }

    public void testEnsureANeverInstalled() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.b});
        Bug207319.assertEquals((int)0, (int)this.director.provision((IProfileChangeRequest)req, null, null).getSeverity());
        Bug207319.assertProfileContainsAll("B is missing", this.profile, new IInstallableUnit[]{this.b});
        Bug207319.assertNotIUs(new IInstallableUnit[]{this.a}, this.profile.query(QueryUtil.createIUAnyQuery(), null).iterator());
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile);
        req2.addInstallableUnits(new IInstallableUnit[]{this.c});
        Bug207319.assertEquals((int)0, (int)this.director.provision((IProfileChangeRequest)req2, null, null).getSeverity());
        Bug207319.assertProfileContainsAll("B and C are missing", this.profile, new IInstallableUnit[]{this.b, this.c});
        Bug207319.assertNotIUs(new IInstallableUnit[]{this.a}, this.profile.query(QueryUtil.createIUAnyQuery(), null).iterator());
    }
}

