/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug259537
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit a2;
    IInstallableUnit a3;
    IInstallableUnit a4;
    IInstallableUnit b1;
    IInstallableUnit b2;
    IInstallableUnit b3;
    IInstallableUnit f1;
    IInstallableUnit f2;
    IInstallableUnit f3;
    IInstallableUnit x1;
    IInstallableUnit x2;
    IInstallableUnit y1;
    IPlanner planner;
    IProfile profile;
    private IEngine engine;
    private String profileId;

    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = Bug259537.createIU("A", Version.create((String)"1.0.0"), true);
        this.b1 = Bug259537.createIU("B", Version.create((String)"2.0.0"), true);
        IRequirement c1 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false);
        IRequirement c2 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[2.0.0, 3.0.0)"), null, (boolean)false, (boolean)false);
        this.f1 = Bug259537.createIU("F", Version.createOSGi((int)2, (int)0, (int)0), new IRequirement[]{c1, c2});
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1, this.f1});
        this.profileId = "TestProfile." + this.getName();
        this.profile = this.createProfile(this.profileId);
        this.planner = Bug259537.createPlanner();
        this.engine = Bug259537.createEngine();
    }

    public void test1() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.getProfile(this.profileId));
        req.addInstallableUnits(new IInstallableUnit[]{this.f1});
        ProvisioningPlan provisioningPlan = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        Bug259537.assertOK("Plan not OK", provisioningPlan.getStatus());
        Bug259537.assertFalse((boolean)provisioningPlan.getAdditions().query(QueryUtil.createIUQuery((IVersionedId)this.f1), null).isEmpty());
        Bug259537.assertFalse((boolean)provisioningPlan.getAdditions().query(QueryUtil.createIUQuery((IVersionedId)this.a1), null).isEmpty());
        Bug259537.assertFalse((boolean)provisioningPlan.getAdditions().query(QueryUtil.createIUQuery((IVersionedId)this.b1), null).isEmpty());
        Bug259537.assertOK("Engine failed", this.engine.perform((IProvisioningPlan)provisioningPlan, null));
        this.a2 = Bug259537.createIU("A", Version.create((String)"1.1.0"), true);
        this.b2 = Bug259537.createIU("B", Version.create((String)"2.1.0"), true);
        IRequirement c1 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false);
        IRequirement c2 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[2.0.0, 3.0.0)"), null, (boolean)false, (boolean)false);
        this.f2 = Bug259537.createIU("F", Version.createOSGi((int)2, (int)1, (int)0), new IRequirement[]{c1, c2});
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a2, this.b2, this.f2});
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.getProfile("TestProfile." + this.getName()));
        req2.addInstallableUnits(new IInstallableUnit[]{this.f2});
        req2.remove(this.f1);
        ProvisioningPlan provisioningPlan2 = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        Bug259537.assertFalse((boolean)provisioningPlan2.getAdditions().query(QueryUtil.createIUQuery((IVersionedId)this.f2), null).isEmpty());
        Bug259537.assertFalse((boolean)provisioningPlan2.getAdditions().query(QueryUtil.createIUQuery((IVersionedId)this.a2), null).isEmpty());
        Bug259537.assertFalse((boolean)provisioningPlan2.getAdditions().query(QueryUtil.createIUQuery((IVersionedId)this.b2), null).isEmpty());
        Bug259537.assertOK("Plan not OK", provisioningPlan2.getStatus());
        Bug259537.assertOK("Engine failed", this.engine.perform((IProvisioningPlan)provisioningPlan2, null));
        this.a3 = Bug259537.createIU("A", Version.create((String)"1.2.0"), true);
        this.b3 = Bug259537.createIU("B", Version.create((String)"2.2.0"), true);
        this.y1 = Bug259537.createIU("Y", Version.create((String)"1.1.1"), true);
        IRequirement d4 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false);
        this.x1 = Bug259537.createIU("X", Version.create((String)"3.3.3"), new IRequirement[]{d4});
        IRequirement d3 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false);
        this.x2 = Bug259537.createIU("X", Version.createOSGi((int)3, (int)4, (int)4), new IRequirement[]{d3});
        IRequirement d1 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false);
        IRequirement d2 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[2.0.0, 3.0.0)"), null, (boolean)false, (boolean)false);
        this.f3 = Bug259537.createIU("F", Version.createOSGi((int)2, (int)2, (int)0), new IRequirement[]{d1, d2});
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a3, this.b3, this.f3, this.x1, this.x2});
        ProfileChangeRequest req4 = new ProfileChangeRequest(this.getProfile("TestProfile." + this.getName()));
        req4.add(this.y1);
        ProvisioningPlan provisioningPlan4 = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req4, null, null);
        Bug259537.assertOK("Plan not OK", provisioningPlan4.getStatus());
        Bug259537.assertEquals((int)1, (int)provisioningPlan4.getAdditions().query(QueryUtil.ALL_UNITS, null).toUnmodifiableSet().size());
        Bug259537.assertOK("Engine failed", this.engine.perform((IProvisioningPlan)provisioningPlan4, null));
        ProfileChangeRequest req5 = new ProfileChangeRequest(this.getProfile("TestProfile." + this.getName()));
        req5.add(this.x1);
        ProvisioningPlan provisioningPlan5 = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req5, null, null);
        Bug259537.assertOK("Plan not OK", provisioningPlan5.getStatus());
        Bug259537.assertEquals((int)2, (int)provisioningPlan5.getAdditions().query(QueryUtil.ALL_UNITS, null).toUnmodifiableSet().size());
        Bug259537.assertFalse((boolean)provisioningPlan5.getAdditions().query(QueryUtil.createIUQuery((IVersionedId)this.a3), null).isEmpty());
        Bug259537.assertOK("Engine failed", this.engine.perform((IProvisioningPlan)provisioningPlan5, null));
        this.a4 = Bug259537.createIU("A", Version.create((String)"1.3.0"), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a4});
        ProfileChangeRequest req3 = new ProfileChangeRequest(this.getProfile("TestProfile." + this.getName()));
        req3.remove(this.f2);
        ProvisioningPlan provisioningPlan3 = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req3, null, null);
        Bug259537.assertOK("Plan not OK", provisioningPlan3.getStatus());
        Bug259537.assertTrue((boolean)provisioningPlan3.getAdditions().query(QueryUtil.ALL_UNITS, null).isEmpty());
        Bug259537.assertFalse((boolean)provisioningPlan3.getRemovals().query(QueryUtil.createIUQuery((IVersionedId)this.f2), null).isEmpty());
        Bug259537.assertFalse((boolean)provisioningPlan3.getRemovals().query(QueryUtil.createIUQuery((IVersionedId)this.b2), null).isEmpty());
        Bug259537.assertOK("Engine failed", this.engine.perform((IProvisioningPlan)provisioningPlan3, null));
    }
}

