/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug270668
extends AbstractProvisioningTest {
    private IInstallableUnit a1;
    private IInstallableUnit b1;
    private IProfile profile;
    private IPlanner planner;

    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = Bug270668.createIU("A", Version.create((String)"1.0.0"), "(os=win32)", new IProvidedCapability[]{new ProvidedCapability("org.eclipse.equinox.p2.iu", "A", Version.create((String)"1.0.0"))});
        this.b1 = Bug270668.createIU("B", Version.create((String)"1.0.0"), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = Bug270668.createPlanner();
    }

    public void testInstallStrict() {
        IProfileChangeRequest pcr = this.planner.createChangeRequest(this.profile);
        pcr.add(this.a1);
        pcr.add(this.b1);
        IProvisioningPlan plan = this.planner.getProvisioningPlan(pcr, null, null);
        Bug270668.assertNotOK(plan.getStatus());
        Bug270668.assertTrue((String)"Explanation does not mention filter!", (boolean)plan.getStatus().getChildren()[0].getMessage().contains("filter"));
    }

    public void testInstallOptional() {
        IProfileChangeRequest pcr = this.planner.createChangeRequest(this.profile);
        pcr.add(this.a1);
        pcr.add(this.b1);
        pcr.setInstallableUnitInclusionRules(this.a1, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.a1));
        IProvisioningPlan plan = this.planner.getProvisioningPlan(pcr, null, null);
        Bug270668.assertOK("Optional install", plan.getStatus());
    }
}

