/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug272251
extends AbstractProvisioningTest {
    IProfile profile = null;
    IMetadataRepository repo = null;

    protected void setUp() throws Exception {
        super.setUp();
        File reporegistry1 = Bug272251.getTestData("test data bug 272251", "testData/bug272251/profileRegistry/");
        File tempFolder = this.getTempFolder();
        Bug272251.copy("0.2", reporegistry1, tempFolder);
        SimpleProfileRegistry registry = new SimpleProfileRegistry(Bug272251.getAgent(), tempFolder, null, false);
        this.profile = registry.getProfile("PlatformProfile");
        Bug272251.assertNotNull((Object)this.profile);
        this.repo = Bug272251.getMetadataRepositoryManager().loadRepository(Bug272251.getTestData("test data bug 272251", "testData/bug272251/repo").toURI(), null);
        Bug272251.assertNotNull((Object)this.repo);
    }

    protected void tearDown() throws Exception {
        Bug272251.getMetadataRepositoryManager().removeRepository(Bug272251.getTestData("test data bug 272251", "testData/bug272251/repo").toURI());
        super.tearDown();
    }

    public void testInstallFeaturePatch() {
        IQueryResult c = this.repo.query(QueryUtil.createIUQuery((String)"org.eclipse.wst.jsdt.feature.patch.feature.group", (Version)Version.create((String)"3.0.4.v200904020304-1-8d7w311_15131415")), (IProgressMonitor)new NullProgressMonitor());
        Bug272251.assertEquals((int)1, (int)Bug272251.queryResultSize(c));
        IQueryResult expectedIU = this.repo.query(QueryUtil.createIUQuery((String)"org.eclipse.wst.jsdt.web.ui", (Version)Version.create((String)"1.0.105.v200904020304")), (IProgressMonitor)new NullProgressMonitor());
        Bug272251.assertEquals((int)1, (int)Bug272251.queryResultSize(expectedIU));
        IInstallableUnit patch = (IInstallableUnit)c.iterator().next();
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        request.addInstallableUnits(new IInstallableUnit[]{patch});
        request.setInstallableUnitInclusionRules(patch, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)patch));
        IPlanner planner = Bug272251.createPlanner();
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, null, (IProgressMonitor)new NullProgressMonitor());
        Bug272251.assertOK("Plan OK", plan.getStatus());
        Bug272251.assertNoOperand(plan, patch);
        Bug272251.assertNoOperand(plan, (IInstallableUnit)expectedIU.iterator().next());
    }
}

