/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug300104
extends AbstractProvisioningTest {
    String profileLoadedId = "SDKProfile";
    IMetadataRepository repo = null;
    IProvisioningAgent agent = null;
    private IProfileRegistry profileRegistry;

    protected void setUp() throws Exception {
        super.setUp();
        File reporegistry1 = Bug300104.getTestData("test data bug 300104", "testData/bug300104/p2");
        File tempFolder = new File(this.getTempFolder(), "p2");
        Bug300104.copy("0.2", reporegistry1, tempFolder);
        IProvisioningAgentProvider provider = Bug300104.getAgentProvider();
        this.agent = provider.createAgent(tempFolder.toURI());
        this.profileRegistry = (IProfileRegistry)this.agent.getService(IProfileRegistry.SERVICE_NAME);
        Bug300104.assertNotNull((Object)this.profileRegistry.getProfile(this.profileLoadedId));
    }

    IInstallableUnit getIU(IMetadataRepository source, String id, String version) {
        IQueryResult c = this.repo.query(QueryUtil.createIUQuery((String)id, (Version)Version.create((String)version)), (IProgressMonitor)new NullProgressMonitor());
        Bug300104.assertEquals((int)1, (int)Bug300104.queryResultSize(c));
        return (IInstallableUnit)c.iterator().next();
    }

    public void testInstallPatchesInOrder() throws ProvisionException {
        boolean optional = true;
        this.installHello(optional);
        this.applyHelloPatch1();
        this.applyHelloPatch2();
    }

    public void testInstallPatchesInOrderStricy() throws ProvisionException {
        boolean optional = false;
        this.installHello(optional);
        this.applyHelloPatch1();
        this.applyHelloPatch2();
    }

    public void testInstallOnlyLaterPatch() throws ProvisionException {
        boolean optional = true;
        this.installHello(optional);
        this.applyHelloPatch2();
    }

    private void installHello(boolean optional) throws ProvisionException {
        this.repo = this.loadMetadataRepository(Bug300104.getTestData("Repository for 300104", "testData/bug300104/hello1.0").toURI());
        ProfileChangeRequest installFeature1 = new ProfileChangeRequest(this.profileRegistry.getProfile(this.profileLoadedId));
        IInstallableUnit featureGroup = this.getIU(this.repo, "hellofeature.feature.group", "1.0.0.200911201237");
        IInstallableUnit featureJar = this.getIU(this.repo, "hellofeature.feature.jar", "1.0.0.200911201237");
        IInstallableUnit helloIU = this.getIU(this.repo, "hello", "1.0.0.200911201237");
        installFeature1.addInstallableUnits(new IInstallableUnit[]{featureGroup, featureJar, helloIU});
        installFeature1.setInstallableUnitInclusionRules(featureGroup, this.createInclusionRule(featureGroup, optional));
        installFeature1.setInstallableUnitInclusionRules(featureJar, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)featureJar));
        installFeature1.setInstallableUnitInclusionRules(helloIU, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)helloIU));
        IProvisioningPlan feature1Plan = this.getPlannerService().getProvisioningPlan((IProfileChangeRequest)installFeature1, new ProvisioningContext(Bug300104.getAgent()), null);
        Bug300104.assertOK("installation of feature1", this.getEngineService().perform(feature1Plan, (IProgressMonitor)new NullProgressMonitor()));
        Bug300104.assertEquals((int)1, (int)Bug300104.queryResultSize(this.profileRegistry.getProfile(this.profileLoadedId).query(QueryUtil.createIUQuery((String)"hello", (Version)Version.create((String)"1.0.0.200911201237")), (IProgressMonitor)new NullProgressMonitor())));
    }

    private IEngine getEngineService() {
        return (IEngine)this.agent.getService(IEngine.SERVICE_NAME);
    }

    private IPlanner getPlannerService() {
        return (IPlanner)this.agent.getService(IPlanner.SERVICE_NAME);
    }

    private String createInclusionRule(IInstallableUnit unit, boolean optional) {
        return optional ? ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)unit) : ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)unit);
    }

    private void applyHelloPatch1() throws ProvisionException {
        this.repo = this.loadMetadataRepository(Bug300104.getTestData("Repository for 300104", "testData/bug300104/hellopatch1").toURI());
        ProfileChangeRequest installFeature1 = new ProfileChangeRequest(this.profileRegistry.getProfile(this.profileLoadedId));
        IInstallableUnit featureGroup = this.getIU(this.repo, "hellopatch.feature.group", "1.0.0");
        IInstallableUnit featureJar = this.getIU(this.repo, "hellopatch.feature.jar", "1.0.0");
        IInstallableUnit helloIU = this.getIU(this.repo, "hello", "1.0.1.200911201237");
        installFeature1.addInstallableUnits(new IInstallableUnit[]{featureGroup, featureJar, helloIU});
        installFeature1.setInstallableUnitInclusionRules(featureGroup, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)featureGroup));
        installFeature1.setInstallableUnitInclusionRules(featureJar, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)featureJar));
        installFeature1.setInstallableUnitInclusionRules(helloIU, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)helloIU));
        IProvisioningPlan feature1Plan = this.getPlannerService().getProvisioningPlan((IProfileChangeRequest)installFeature1, new ProvisioningContext(Bug300104.getAgent()), null);
        Bug300104.assertOK("installation of feature1", this.getEngineService().perform(feature1Plan, (IProgressMonitor)new NullProgressMonitor()));
        Bug300104.assertEquals((int)0, (int)Bug300104.queryResultSize(this.profileRegistry.getProfile(this.profileLoadedId).query(QueryUtil.createIUQuery((String)"hello", (Version)Version.create((String)"1.0.0.200911201237")), (IProgressMonitor)new NullProgressMonitor())));
        Bug300104.assertEquals((int)1, (int)Bug300104.queryResultSize(this.profileRegistry.getProfile(this.profileLoadedId).query(QueryUtil.createIUQuery((String)"hello", (Version)Version.create((String)"1.0.1.200911201237")), (IProgressMonitor)new NullProgressMonitor())));
    }

    private void applyHelloPatch2() throws ProvisionException {
        this.repo = this.loadMetadataRepository(Bug300104.getTestData("Repository for 300104", "testData/bug300104/hellopatch2").toURI());
        ProfileChangeRequest installFeature1 = new ProfileChangeRequest(this.profileRegistry.getProfile(this.profileLoadedId));
        IInstallableUnit featureGroup = this.getIU(this.repo, "hellopatch.feature.group", "1.0.1.200911201358");
        IInstallableUnit featureJar = this.getIU(this.repo, "hellopatch.feature.jar", "1.0.1.200911201358");
        IInstallableUnit helloIU = this.getIU(this.repo, "hello", "1.0.1.200911201358");
        IInstallableUnit hello2IU = this.getIU(this.repo, "hello2", "1.0.0.200911201358");
        installFeature1.addInstallableUnits(new IInstallableUnit[]{featureGroup, featureJar, helloIU, hello2IU});
        installFeature1.setInstallableUnitInclusionRules(featureGroup, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)featureGroup));
        installFeature1.setInstallableUnitInclusionRules(featureJar, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)featureJar));
        installFeature1.setInstallableUnitInclusionRules(helloIU, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)helloIU));
        installFeature1.setInstallableUnitInclusionRules(hello2IU, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)hello2IU));
        IProvisioningPlan feature1Plan = this.getPlannerService().getProvisioningPlan((IProfileChangeRequest)installFeature1, new ProvisioningContext(Bug300104.getAgent()), null);
        Bug300104.assertOK("installation of feature1", this.getEngineService().perform(feature1Plan, (IProgressMonitor)new NullProgressMonitor()));
        Bug300104.assertEquals((int)1, (int)Bug300104.queryResultSize(this.profileRegistry.getProfile(this.profileLoadedId).query(QueryUtil.createIUQuery((String)"hello2", (Version)Version.create((String)"1.0.0.200911201358")), (IProgressMonitor)new NullProgressMonitor())));
        Bug300104.assertEquals((int)0, (int)Bug300104.queryResultSize(this.profileRegistry.getProfile(this.profileLoadedId).query(QueryUtil.createIUQuery((String)"hello", (Version)Version.create((String)"1.0.0.200911201237")), (IProgressMonitor)new NullProgressMonitor())));
        Bug300104.assertEquals((int)0, (int)Bug300104.queryResultSize(this.profileRegistry.getProfile(this.profileLoadedId).query(QueryUtil.createIUQuery((String)"hello", (Version)Version.create((String)"1.0.1.200911201237")), (IProgressMonitor)new NullProgressMonitor())));
        Bug300104.assertEquals((int)1, (int)Bug300104.queryResultSize(this.profileRegistry.getProfile(this.profileLoadedId).query(QueryUtil.createIUQuery((String)"hello", (Version)Version.create((String)"1.0.1.200911201358")), (IProgressMonitor)new NullProgressMonitor())));
    }
}

