/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug300572Small3
extends AbstractProvisioningTest {
    IInstallableUnit featureBeingPatched;
    IInstallableUnitPatch p1;
    IInstallableUnitPatch p2;
    IProfile profile1;
    IPlanner planner;
    IEngine engine;
    private IInstallableUnit p1b;
    private IInstallableUnit p2b;

    protected void setUp() throws Exception {
        super.setUp();
        IMetadataRepository repo = Bug300572Small3.getMetadataRepositoryManager().loadRepository(Bug300572Small3.getTestData("bug300572 data", "testData/bug300572Small/repo/").toURI(), (IProgressMonitor)new NullProgressMonitor());
        this.featureBeingPatched = (IInstallableUnit)repo.query(QueryUtil.createIUQuery((String)"hellofeature.feature.group"), null).iterator().next();
        this.p1 = (IInstallableUnitPatch)repo.query(QueryUtil.createIUQuery((String)"hellopatch.feature.group", (Version)Version.create((String)"1.0.0")), null).iterator().next();
        this.p1b = (IInstallableUnit)repo.query(QueryUtil.createIUQuery((String)"hello", (Version)Version.create((String)"1.0.1.200911201237")), null).iterator().next();
        this.p2 = (IInstallableUnitPatch)repo.query(QueryUtil.createIUQuery((String)"hellopatch.feature.group", (Version)Version.create((String)"1.0.2.201001211536")), null).iterator().next();
        this.p2b = (IInstallableUnit)repo.query(QueryUtil.createIUQuery((String)"hello", (Version)Version.create((String)"1.0.2.201001211536")), null).iterator().next();
        this.planner = Bug300572Small3.createPlanner();
        this.engine = Bug300572Small3.createEngine();
    }

    public void testInstallAandP1ThenP2() {
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.featureBeingPatched, this.p1, this.p1b});
        req1.setInstallableUnitInclusionRules((IInstallableUnit)this.p1, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.p1));
        req1.setInstallableUnitInclusionRules(this.p1b, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.p1b));
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        Bug300572Small3.assertEquals((int)0, (int)plan1.getStatus().getSeverity());
        Bug300572Small3.assertContains(plan1.getAdditions().query(QueryUtil.ALL_UNITS, null), this.p1);
        Bug300572Small3.assertOK("plan execution", this.engine.perform(plan1, null));
        Bug300572Small3.assertProfileContainsAll("Patch 1 not installed", this.profile1, new IInstallableUnit[]{this.p1, this.p1b});
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile1);
        req2.addInstallableUnits(new IInstallableUnit[]{this.p2, this.p2b});
        req2.setInstallableUnitInclusionRules((IInstallableUnit)this.p2, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.p2));
        req2.setInstallableUnitInclusionRules((IInstallableUnit)this.p2, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.p2b));
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        Bug300572Small3.assertOK("Planning for installing P2", plan2.getStatus());
        Bug300572Small3.assertContains(plan2.getAdditions().query(QueryUtil.ALL_UNITS, null), this.p2);
        Bug300572Small3.assertFalse((boolean)plan2.getAdditions().query(QueryUtil.createIUQuery((IVersionedId)this.p2b), null).isEmpty());
        Bug300572Small3.assertFalse((boolean)plan2.getAdditions().query(QueryUtil.createIUQuery((IVersionedId)this.p2), null).isEmpty());
        Bug300572Small3.assertFalse((boolean)plan2.getRemovals().query(QueryUtil.createIUQuery((IVersionedId)this.p1), null).isEmpty());
        Bug300572Small3.assertFalse((boolean)plan2.getRemovals().query(QueryUtil.createIUQuery((IVersionedId)this.p1b), null).isEmpty());
    }
}

