/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class Bug300572Small4
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit b2;
    IInstallableUnit b3;
    IInstallableUnitPatch p1;
    IInstallableUnitPatch p2;
    IProfile profile1;
    IPlanner planner;
    IEngine engine;

    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = Bug300572Small4.createIU("A", Version.create((String)"1.0.0"), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)true)});
        this.b2 = Bug300572Small4.createIU("B", Version.createOSGi((int)2, (int)0, (int)0), true);
        this.b3 = Bug300572Small4.createIU("B", Version.createOSGi((int)3, (int)0, (int)0), true);
        IRequirementChange change = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[2.0.0, 2.0.0]"), null, (boolean)false, (boolean)false, (boolean)true));
        this.p1 = Bug300572Small4.createIUPatch("P", Version.create((String)"1.0.0"), true, new IRequirementChange[]{change}, new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}}, null);
        IRequirementChange changeP2 = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[3.0.0,3.0.0]"), null, (boolean)false, (boolean)false, (boolean)true));
        this.p2 = Bug300572Small4.createIUPatch("P", Version.create((String)"2.0.0"), true, new IRequirementChange[]{changeP2}, new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}}, null);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b2, this.b3, this.p1});
        this.planner = Bug300572Small4.createPlanner();
        this.engine = Bug300572Small4.createEngine();
    }

    public void testInstall() {
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.a1});
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        Bug300572Small4.assertEquals((int)4, (int)plan1.getStatus().getSeverity());
    }

    public void testInstallAandP1() {
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.a1, this.p1});
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        Bug300572Small4.assertEquals((int)0, (int)plan1.getStatus().getSeverity());
    }

    public void testInstallAandP2() {
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.a1, this.p2});
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        Bug300572Small4.assertEquals((int)0, (int)plan1.getStatus().getSeverity());
    }

    public void testInstallAandP1AndP2() {
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.a1, this.p1, this.p2});
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        Bug300572Small4.assertEquals((int)4, (int)plan1.getStatus().getSeverity());
    }

    public void testInstallAandP1ThenP2() {
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.a1, this.p1});
        req1.setInstallableUnitInclusionRules((IInstallableUnit)this.p1, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.p1));
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        Bug300572Small4.assertEquals((int)0, (int)plan1.getStatus().getSeverity());
        Bug300572Small4.assertContains(plan1.getAdditions().query(QueryUtil.ALL_UNITS, null), this.p1);
        Bug300572Small4.assertOK("plan execution", this.engine.perform(plan1, null));
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile1);
        req2.addInstallableUnits(new IInstallableUnit[]{this.p2});
        req2.setInstallableUnitInclusionRules((IInstallableUnit)this.p2, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.p2));
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        Bug300572Small4.assertOK("Planning for installing P2", plan2.getStatus());
        Bug300572Small4.assertContains(plan2.getAdditions().query(QueryUtil.ALL_UNITS, null), this.p2);
        Bug300572Small4.assertContains(plan2.getAdditions().query(QueryUtil.ALL_UNITS, null), this.b3);
    }
}

