/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bug302582d
extends AbstractProvisioningTest {
    String profileLoadedId = "bootProfile";
    IMetadataRepository repo = null;
    IProvisioningAgent agent = null;
    private IProfileRegistry profileRegistry;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File reporegistry1 = Bug302582d.getTestData("test data bug 302582d", "testData/bug302582d/p2");
        File tempFolder = new File(this.getTempFolder(), "p2");
        Bug302582d.copy("0.2", reporegistry1, tempFolder);
        IProvisioningAgentProvider provider = Bug302582d.getAgentProvider();
        this.agent = provider.createAgent(tempFolder.toURI());
        this.profileRegistry = (IProfileRegistry)this.agent.getService(IProfileRegistry.SERVICE_NAME);
        Bug302582d.assertNotNull((Object)this.profileRegistry.getProfile(this.profileLoadedId));
    }

    IInstallableUnit getIU(IMetadataRepository source, String id, String version) {
        IQueryResult c = this.repo.query(QueryUtil.createIUQuery((String)id, (Version)Version.create((String)version)), (IProgressMonitor)new NullProgressMonitor());
        Bug302582d.assertEquals((int)1, (int)Bug302582d.queryResultSize(c));
        return (IInstallableUnit)c.iterator().next();
    }

    public void testInstall() {
        IMetadataRepositoryManager mgr = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        try {
            this.repo = mgr.loadRepository(Bug302582d.getTestData("test data bug bug302582d repo", "testData/bug302582d/repo").toURI(), null);
        }
        catch (ProvisionException e) {
            Bug302582d.assertNull((Object)((Object)e));
        }
        IQueryResult ius = this.repo.query(QueryUtil.createIUAnyQuery(), null);
        IPlanner planner = this.getPlanner(this.agent);
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)this.createRequest((IQueryResult<IInstallableUnit>)ius), null, (IProgressMonitor)new NullProgressMonitor());
        IProvisioningPlan expected = planner.getProvisioningPlan((IProfileChangeRequest)this.createFilteredRequest((IQueryResult<IInstallableUnit>)ius), null, (IProgressMonitor)new NullProgressMonitor());
        Bug302582d.assertEquals("Plan comparison", expected.getAdditions().query(QueryUtil.createIUAnyQuery(), null).toArray(IInstallableUnit.class), plan.getAdditions().query(QueryUtil.createIUAnyQuery(), null).toArray(IInstallableUnit.class), false);
    }

    private ProfileChangeRequest createFilteredRequest(IQueryResult<IInstallableUnit> ius) {
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profileRegistry.getProfile(this.profileLoadedId));
        for (IInstallableUnit iu : ius) {
            if (!(iu.getId().equals("com.dcns.rsm.rda") && iu.getVersion().equals(Version.create((String)"5.1.0.v20100112")) || iu.getId().equals("com.dcns.rsm.profile.equipment") && iu.getVersion().equals(Version.create((String)"1.2.2.v20100108")) || iu.getId().equals("com.dcns.rsm.profile.gemo") && iu.getVersion().equals(Version.create((String)"3.7.2.v20100108"))) && (!iu.getId().equals("com.dcns.rsm.profile.system") || !iu.getVersion().equals(Version.create((String)"4.2.2.v20100112")))) continue;
            pcr.addInstallableUnits(new IInstallableUnit[]{iu});
        }
        return pcr;
    }

    private ProfileChangeRequest createRequest(IQueryResult<IInstallableUnit> ius) {
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profileRegistry.getProfile(this.profileLoadedId));
        pcr.addInstallableUnits((IInstallableUnit[])ius.toArray(IInstallableUnit.class));
        for (IInstallableUnit iu : ius) {
            pcr.setInstallableUnitInclusionRules(iu, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)iu));
        }
        return pcr;
    }
}

