/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.osgi.framework.Version;

public class ExplanationDeepConflict
extends AbstractProvisioningTest {
    private IProfile profile;
    private IPlanner planner;
    private IEngine engine;
    private IInstallableUnit sdk;

    protected void setUp() throws Exception {
        super.setUp();
        this.sdk = ExplanationDeepConflict.createIU("SDK", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), ExplanationDeepConflict.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "SDKPart", new VersionRange("[1.0.0, 1.0.0]")));
        IInstallableUnit sdkPart = ExplanationDeepConflict.createIU("SDKPart", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), ExplanationDeepConflict.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "InnerSDKPart", new VersionRange("[1.0.0, 1.0.0]")));
        IInstallableUnit innerSdkPart = ExplanationDeepConflict.createIU("InnerSDKPart", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), ExplanationDeepConflict.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "InnerInnerSDKPart", new VersionRange("[1.0.0, 1.0.0]")));
        IInstallableUnit innerInnerSDKPart = ExplanationDeepConflict.createIU("InnerInnerSDKPart", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.sdk, sdkPart, innerSdkPart, innerInnerSDKPart});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = ExplanationDeepConflict.createPlanner();
        this.engine = ExplanationDeepConflict.createEngine();
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.addInstallableUnits(new IInstallableUnit[]{this.sdk});
        this.engine.perform(this.planner.getProvisioningPlan((IProfileChangeRequest)pcr, null, null), null);
        ExplanationDeepConflict.assertProfileContains("1.0", this.profile, new IInstallableUnit[]{this.sdk, sdkPart, innerSdkPart, innerInnerSDKPart});
    }

    public void testDeepSingletonConflict() {
        IInstallableUnit cdt = ExplanationDeepConflict.createIU("CDT", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), ExplanationDeepConflict.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "CDTPart", new VersionRange("[1.0.0, 1.0.0]")));
        IInstallableUnit cdtPart = ExplanationDeepConflict.createIU("CDTPart", PublisherHelper.fromOSGiVersion((Version)new Version("1.0.0")), ExplanationDeepConflict.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "InnerInnerSDKPart", new VersionRange("[2.0.0, 2.0.0]")));
        IInstallableUnit innerInnerSDKPart2 = ExplanationDeepConflict.createIU("InnerInnerSDKPart", PublisherHelper.fromOSGiVersion((Version)new Version("2.0.0")), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{cdt, cdtPart, innerInnerSDKPart2});
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.addInstallableUnits(new IInstallableUnit[]{cdt});
        ProvisioningPlan plan = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)pcr, null, null);
        RequestStatus requestStatus = ((PlannerStatus)plan.getStatus()).getRequestStatus();
        ExplanationDeepConflict.assertTrue((boolean)requestStatus.getConflictsWithInstalledRoots().contains(cdt));
        ExplanationDeepConflict.assertFalse((boolean)requestStatus.getConflictsWithInstalledRoots().contains(this.sdk));
        ExplanationDeepConflict.assertTrue((boolean)requestStatus.getConflictsWithAnyRoots().contains(this.sdk));
    }
}

