/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class FindingPatchesThroughUpdates
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit a120;
    IInstallableUnitPatch patchA1;
    IInstallableUnitPatch patchA2;
    IInstallableUnitPatch anotherPatch2;
    IInstallableUnitPatch anotherPatch3;
    IProfile profile1;
    IPlanner planner;
    IEngine engine;

    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = FindingPatchesThroughUpdates.createIU("A", Version.create((String)"1.0.0"));
        IUpdateDescriptor update = MetadataFactory.createUpdateDescriptor((String)"A", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), (int)0, (String)"update description");
        this.a120 = FindingPatchesThroughUpdates.createIU("UpdateA", Version.createOSGi((int)1, (int)2, (int)0), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, null, NO_TP_DATA, false, update, (IRequirement[])NO_REQUIRES);
        IRequirementChange change = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.1.0, 1.3.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement lifeCycle = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.0.0, 1.2.0]"), null, (boolean)false, (boolean)false);
        this.patchA1 = FindingPatchesThroughUpdates.createIUPatch("P", Version.create((String)"1.0.0"), true, new IRequirementChange[]{change}, new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}}, lifeCycle);
        IRequirementChange change2 = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.1.0, 1.3.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement lifeCycle2 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[2.0.0, 3.2.0]"), null, (boolean)false, (boolean)false);
        this.patchA2 = FindingPatchesThroughUpdates.createIUPatch("P", Version.create((String)"1.0.0"), true, new IRequirementChange[]{change2}, new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}}, lifeCycle2);
        IRequirementChange change3 = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.1.0, 1.3.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement lifeCycle3 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[2.0.0, 3.2.0]"), null, (boolean)false, (boolean)false);
        this.anotherPatch2 = FindingPatchesThroughUpdates.createIUPatch("ANOTHERPATCH", Version.create((String)"1.0.0"), true, new IRequirementChange[]{change3}, new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}}, lifeCycle3);
        IRequirementChange change4 = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.1.0, 1.3.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement lifeCycle4 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[2.0.0, 3.2.0]"), null, (boolean)false, (boolean)false);
        this.anotherPatch3 = FindingPatchesThroughUpdates.createIUPatch("ANOTHERPATCH", Version.create((String)"2.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, new Properties(), null, null, true, MetadataFactory.createUpdateDescriptor((String)"ANOTHERPATCH", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), (int)0, (String)""), new IRequirementChange[]{change4}, new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}}, lifeCycle4, (IRequirement[])NO_REQUIRES);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.a120, this.patchA1, this.patchA2, this.anotherPatch2, this.anotherPatch3});
        this.planner = FindingPatchesThroughUpdates.createPlanner();
    }

    public void testInstall() {
        IQueryResult updates = this.planner.updatesFor(this.a1, new ProvisioningContext(FindingPatchesThroughUpdates.getAgent()), (IProgressMonitor)new NullProgressMonitor());
        FindingPatchesThroughUpdates.assertEquals((int)2, (int)updates.toUnmodifiableSet().size());
        FindingPatchesThroughUpdates.assertTrue((boolean)updates.toUnmodifiableSet().contains(this.a120));
        FindingPatchesThroughUpdates.assertTrue((boolean)updates.toUnmodifiableSet().contains(this.patchA1));
    }

    public void testFindUpdatesOfPatches() {
        IQueryResult updates = this.planner.updatesFor((IInstallableUnit)this.anotherPatch2, new ProvisioningContext(FindingPatchesThroughUpdates.getAgent()), (IProgressMonitor)new NullProgressMonitor());
        FindingPatchesThroughUpdates.assertEquals((int)1, (int)updates.toUnmodifiableSet().size());
        FindingPatchesThroughUpdates.assertTrue((boolean)updates.toUnmodifiableSet().contains(this.anotherPatch3));
    }
}

