/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.IUDescription;
import org.eclipse.equinox.p2.tests.IULoader;

public class FromStrictToOptional
extends AbstractProvisioningTest {
    @IUDescription(content="package: A \nsingleton: true\nversion: 1 \ndepends: B = 1")
    public IInstallableUnit a1;
    @IUDescription(content="package: B \nsingleton: true\nversion: 1 \n")
    public IInstallableUnit b1;
    @IUDescription(content="package: C \nsingleton: true\nversion: 1 \ndepends: B = 2")
    public IInstallableUnit c1;
    @IUDescription(content="package: B \nsingleton: true\nversion: 2 \n")
    public IInstallableUnit b2;
    IProfile profile = this.createProfile("TestProfile." + this.getName());
    private IPlanner planner;
    private IEngine engine;

    protected void setUp() throws Exception {
        super.setUp();
        IULoader.loadIUs((Object)this);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1, this.b2, this.c1});
        this.planner = FromStrictToOptional.createPlanner();
        this.engine = FromStrictToOptional.createEngine();
        FromStrictToOptional.assertOK(this.install(this.profile, new IInstallableUnit[]{this.a1}, true, this.planner, this.engine));
    }

    public void testChangeFromStrictToOptional() {
        FromStrictToOptional.assertNotOK(this.install(this.profile, new IInstallableUnit[]{this.c1}, true, this.planner, this.engine));
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.add(this.a1);
        req.setInstallableUnitInclusionRules(this.a1, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.a1));
        req.add(this.c1);
        req.setInstallableUnitInclusionRules(this.c1, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.c1));
        FromStrictToOptional.assertOK(this.install((IProfileChangeRequest)req, this.planner, this.engine));
    }
}

