/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class GreedyRequirement
extends AbstractProvisioningTest {
    private IInstallableUnit a1;
    private IInstallableUnit b1;
    private IInstallableUnit c1;
    private IProfile profile;
    private IPlanner planner;

    protected void setUp() throws Exception {
        super.setUp();
        this.b1 = GreedyRequirement.createIU("B", Version.create((String)"1.0.0"), true);
        IRequirement[] reqB = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)false, (boolean)false)};
        this.a1 = GreedyRequirement.createIU("A", Version.create((String)"1.0.0"), reqB);
        IRequirement[] reqC = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)true)};
        this.c1 = GreedyRequirement.createIU("C", Version.create((String)"1.0.0"), reqC);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1, this.c1});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = GreedyRequirement.createPlanner();
    }

    public void testInstall() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1, this.c1});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        GreedyRequirement.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        GreedyRequirement.assertInstallOperand(plan, this.a1);
        GreedyRequirement.assertInstallOperand(plan, this.b1);
        GreedyRequirement.assertInstallOperand(plan, this.c1);
    }
}

