/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class InclusionRuleTest
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit a2;
    IInstallableUnit b1;
    IProfile profile1;
    IProfile profile2;
    IProfile profile3;
    IProfile profile4;
    IPlanner planner;
    IEngine engine;

    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = InclusionRuleTest.createIU("A", Version.create((String)"1.0.0"), true);
        this.a2 = InclusionRuleTest.createIU("A", Version.create((String)"2.0.0"), true);
        this.b1 = InclusionRuleTest.createIU("B", Version.create((String)"1.0.0"), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.a2});
        this.planner = InclusionRuleTest.createPlanner();
        this.engine = InclusionRuleTest.createEngine();
    }

    public void testMultipleInstallations() {
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile1);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        InclusionRuleTest.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        this.engine.perform(plan, null);
        InclusionRuleTest.assertProfileContainsAll("A1 is missing", this.profile1, new IInstallableUnit[]{this.a1});
        InclusionRuleTest.assertEquals((int)InclusionRuleTest.queryResultSize(this.profile1.query(QueryUtil.createIUAnyQuery(), null)), (int)1);
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile1);
        req2.setInstallableUnitInclusionRules(this.a1, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.a1));
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        InclusionRuleTest.assertEquals((int)0, (int)plan2.getStatus().getSeverity());
        this.engine.perform(plan2, null);
        InclusionRuleTest.assertProfileContainsAll("A1 is missing", this.profile1, new IInstallableUnit[]{this.a1});
        InclusionRuleTest.assertEquals((int)InclusionRuleTest.queryResultSize(this.profile1.query(QueryUtil.createIUAnyQuery(), null)), (int)1);
        ProfileChangeRequest req3 = new ProfileChangeRequest(this.profile1);
        req3.addInstallableUnits(new IInstallableUnit[]{this.b1});
        IProvisioningPlan plan3 = this.planner.getProvisioningPlan((IProfileChangeRequest)req3, null, null);
        InclusionRuleTest.assertEquals((int)0, (int)plan3.getStatus().getSeverity());
        this.engine.perform(plan3, null);
        InclusionRuleTest.assertProfileContainsAll("A1 or B1 is missing", this.profile1, new IInstallableUnit[]{this.a1, this.b1});
        InclusionRuleTest.assertEquals((int)InclusionRuleTest.queryResultSize(this.profile1.query(QueryUtil.createIUAnyQuery(), null)), (int)2);
        ProfileChangeRequest req4 = new ProfileChangeRequest(this.profile1);
        req4.addInstallableUnits(new IInstallableUnit[]{this.a2});
        IProvisioningPlan plan4 = this.planner.getProvisioningPlan((IProfileChangeRequest)req4, null, null);
        InclusionRuleTest.assertEquals((int)0, (int)plan4.getStatus().getSeverity());
        this.engine.perform(plan4, null);
        InclusionRuleTest.assertProfileContainsAll("A2 is missing", this.profile1, new IInstallableUnit[]{this.a2});
        InclusionRuleTest.assertNotIUs(new IInstallableUnit[]{this.a1}, this.profile1.query(QueryUtil.createIUAnyQuery(), null).iterator());
        InclusionRuleTest.assertEquals((int)InclusionRuleTest.queryResultSize(this.profile1.query(QueryUtil.createIUAnyQuery(), null)), (int)2);
        ProfileChangeRequest req5 = new ProfileChangeRequest(this.profile1);
        req5.addInstallableUnits(new IInstallableUnit[]{this.a1});
        IProvisioningPlan plan5 = this.planner.getProvisioningPlan((IProfileChangeRequest)req5, null, null);
        InclusionRuleTest.assertEquals((int)4, (int)plan5.getStatus().getSeverity());
    }

    public void testRemoveInclusionRule() {
        this.profile2 = this.createProfile("TestProfile2." + this.getName());
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile2);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        InclusionRuleTest.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        this.engine.perform(plan, null);
        InclusionRuleTest.assertProfileContainsAll("A1 is missing", this.profile2, new IInstallableUnit[]{this.a1});
        InclusionRuleTest.assertEquals((int)InclusionRuleTest.queryResultSize(this.profile2.query(QueryUtil.createIUAnyQuery(), null)), (int)1);
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile2);
        req2.setInstallableUnitInclusionRules(this.a1, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.a1));
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        InclusionRuleTest.assertEquals((int)0, (int)plan2.getStatus().getSeverity());
        this.engine.perform(plan2, null);
        InclusionRuleTest.assertProfileContainsAll("A1 is missing", this.profile2, new IInstallableUnit[]{this.a1});
        InclusionRuleTest.assertEquals((int)InclusionRuleTest.queryResultSize(this.profile2.query(QueryUtil.createIUAnyQuery(), null)), (int)1);
        ProfileChangeRequest req3 = new ProfileChangeRequest(this.profile2);
        req3.addInstallableUnits(new IInstallableUnit[]{this.b1});
        IProvisioningPlan plan3 = this.planner.getProvisioningPlan((IProfileChangeRequest)req3, null, null);
        InclusionRuleTest.assertEquals((int)0, (int)plan3.getStatus().getSeverity());
        this.engine.perform(plan3, null);
        this.profile2 = this.getProfile(this.profile2.getProfileId());
        InclusionRuleTest.assertProfileContainsAll("A1 or B1 is missing", this.profile2, new IInstallableUnit[]{this.a1, this.b1});
        InclusionRuleTest.assertEquals((int)InclusionRuleTest.queryResultSize(this.profile2.query(QueryUtil.createIUAnyQuery(), null)), (int)2);
        ProfileChangeRequest req5 = new ProfileChangeRequest(this.profile2);
        req5.removeInstallableUnitInclusionRules(this.a1);
        IProvisioningPlan plan5 = this.planner.getProvisioningPlan((IProfileChangeRequest)req5, null, null);
        InclusionRuleTest.assertEquals((int)0, (int)plan5.getStatus().getSeverity());
        this.engine.perform(plan5, null);
        this.profile2 = this.getProfile(this.profile2.getProfileId());
        InclusionRuleTest.assertProfileContainsAll("A1 or B1 is missing", this.profile2, new IInstallableUnit[]{this.a1, this.b1});
        InclusionRuleTest.assertEquals((int)InclusionRuleTest.queryResultSize(this.profile2.query(QueryUtil.createIUAnyQuery(), null)), (int)2);
    }

    public void testRemoveIUandInclusionRule() {
        this.profile3 = this.createProfile("TestProfile3." + this.getName());
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile3);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        InclusionRuleTest.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        this.engine.perform(plan, null);
        InclusionRuleTest.assertProfileContainsAll("A1 is missing", this.profile3, new IInstallableUnit[]{this.a1});
        InclusionRuleTest.assertEquals((int)InclusionRuleTest.queryResultSize(this.profile3.query(QueryUtil.createIUAnyQuery(), null)), (int)1);
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile3);
        req2.setInstallableUnitInclusionRules(this.a1, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.a1));
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        InclusionRuleTest.assertEquals((int)0, (int)plan2.getStatus().getSeverity());
        this.engine.perform(plan2, null);
        InclusionRuleTest.assertProfileContainsAll("A1 is missing", this.profile3, new IInstallableUnit[]{this.a1});
        InclusionRuleTest.assertEquals((int)InclusionRuleTest.queryResultSize(this.profile3.query(QueryUtil.createIUAnyQuery(), null)), (int)1);
        ProfileChangeRequest req3 = new ProfileChangeRequest(this.profile3);
        req3.addInstallableUnits(new IInstallableUnit[]{this.b1});
        IProvisioningPlan plan3 = this.planner.getProvisioningPlan((IProfileChangeRequest)req3, null, null);
        InclusionRuleTest.assertEquals((int)0, (int)plan3.getStatus().getSeverity());
        this.engine.perform(plan3, null);
        InclusionRuleTest.assertProfileContainsAll("A1 or B1 is missing", this.profile3, new IInstallableUnit[]{this.a1, this.b1});
        InclusionRuleTest.assertEquals((int)InclusionRuleTest.queryResultSize(this.profile3.query(QueryUtil.createIUAnyQuery(), null)), (int)2);
        ProfileChangeRequest req5 = new ProfileChangeRequest(this.profile3);
        req5.removeInstallableUnits(new IInstallableUnit[]{this.a1});
        req5.removeInstallableUnitInclusionRules(this.a1);
        IProvisioningPlan plan5 = this.planner.getProvisioningPlan((IProfileChangeRequest)req5, null, null);
        InclusionRuleTest.assertEquals((int)0, (int)plan5.getStatus().getSeverity());
        this.engine.perform(plan5, null);
        InclusionRuleTest.assertProfileContainsAll("bB1 is missing", this.profile3, new IInstallableUnit[]{this.b1});
        InclusionRuleTest.assertEquals((int)InclusionRuleTest.queryResultSize(this.profile3.query(QueryUtil.createIUAnyQuery(), null)), (int)1);
    }

    public void testAdditionWithInclusionRule() {
        this.profile4 = this.createProfile("TestProfile4." + this.getName());
        ProfileChangeRequest req5 = new ProfileChangeRequest(this.profile4);
        req5.addInstallableUnits(new IInstallableUnit[]{this.a1, this.a2});
        IProvisioningPlan plan5 = this.planner.getProvisioningPlan((IProfileChangeRequest)req5, null, null);
        InclusionRuleTest.assertEquals((int)4, (int)plan5.getStatus().getSeverity());
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile4);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1, this.a2});
        req.setInstallableUnitInclusionRules(this.a1, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.a1));
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        InclusionRuleTest.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        this.engine.perform(plan, null);
        InclusionRuleTest.assertProfileContainsAll("A2 is missing", this.profile4, new IInstallableUnit[]{this.a2});
        InclusionRuleTest.assertEquals((int)InclusionRuleTest.queryResultSize(this.profile4.query(QueryUtil.createIUAnyQuery(), null)), (int)1);
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile4);
        req2.setInstallableUnitInclusionRules(this.a1, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.a1));
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        InclusionRuleTest.assertEquals((int)0, (int)plan2.getStatus().getSeverity());
        this.engine.perform(plan2, null);
        InclusionRuleTest.assertProfileContainsAll("A2 is missing", this.profile4, new IInstallableUnit[]{this.a2});
        InclusionRuleTest.assertEquals((int)InclusionRuleTest.queryResultSize(this.profile4.query(QueryUtil.createIUAnyQuery(), null)), (int)1);
        ProfileChangeRequest req3 = new ProfileChangeRequest(this.profile4);
        req3.addInstallableUnits(new IInstallableUnit[]{this.a1});
        IProvisioningPlan plan3 = this.planner.getProvisioningPlan((IProfileChangeRequest)req3, null, null);
        InclusionRuleTest.assertEquals((int)4, (int)plan3.getStatus().getSeverity());
    }
}

