/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.Set;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class MissingDependency
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit b1;
    private IProfile profile;
    private IPlanner planner;

    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = MissingDependency.createIU("A", Version.create((String)"1.0.0"), true);
        IRequirement[] req = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"C", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)true)};
        this.b1 = MissingDependency.createIU("B", Version.create((String)"1.0.0"), req);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = MissingDependency.createPlanner();
    }

    public void testContradiction() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1, this.b1});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        MissingDependency.assertEquals((int)4, (int)plan.getStatus().getSeverity());
    }

    public void testExplanation() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1, this.b1});
        ProvisioningPlan plan = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        MissingDependency.assertEquals((int)4, (int)plan.getStatus().getSeverity());
        RequestStatus requestStatus = ((PlannerStatus)plan.getStatus()).getRequestStatus();
        Set explanation = requestStatus.getExplanations();
        MissingDependency.assertEquals((int)2, (int)explanation.size());
        Set rootConflictingIUs = requestStatus.getConflictsWithInstalledRoots();
        MissingDependency.assertEquals((int)1, (int)rootConflictingIUs.size());
        MissingDependency.assertTrue((boolean)rootConflictingIUs.contains(this.b1));
        MissingDependency.assertFalse((boolean)rootConflictingIUs.contains(this.a1));
        MissingDependency.assertEquals((int)1, (int)requestStatus.getShortExplanation());
    }
}

